/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.audioengines.joal;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.java.games.joal.AL;
import net.java.games.joal.util.ALut;

public class JOALSample
extends Sample {
    private static boolean debug = true;
    private static boolean debugPosition = false;
    private static boolean debugDirection = false;
    private static boolean debugDistanceGain = false;
    private static boolean debugGain = false;
    private static boolean debugLoopCount = false;
    private static boolean debugMute = false;
    private static boolean debugLoad = true;
    private static boolean debugDuration = false;
    private static boolean debugClear = true;
    private int index;
    private int[] buffer;
    private int[] source;
    private AL al;
    private static double pi = Math.PI;
    private int sampleSize;
    private int sampleBits;
    private int sampleFrequency;
    private int sampleChannels = 1;
    public static final int NULL_SAMPLE = -1;
    protected MediaContainer soundData = null;
    protected int soundType = -1;
    protected float gain = 1.0f;
    protected float rateScaleFactor = 1.0f;
    protected int loopCount = 0;
    public static final int DURATION_UNKNOWN = -1;
    protected long duration = -1L;
    protected int numberOfChannels = 0;
    protected boolean mute = false;
    protected Transform3D vworldXfrm = new Transform3D();
    protected boolean vwXfrmFlag = false;
    protected Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    protected float[] positionArray = new float[]{0.0f, 0.0f, 0.0f};
    protected double[] attenuationDistance = null;
    protected float[] attenuationGain = null;
    protected int dirtyFlags = 65535;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected float[] directionArray = new float[]{0.0f, 0.0f, 0.0f};
    protected double[] backAttenuationDistance = null;
    protected float[] backAttenuationGain = null;
    protected double[] angularDistance = new double[]{0.0, 1.5707963267948966};
    protected float[] angularGain = new float[]{1.0f, 0.0f};
    public static final int NO_FILTERING = -1;
    public static final int LOW_PASS = 1;
    protected int angularFilterType = -1;
    protected float[] angularFilterCutoff = new float[]{-1.0f, -1.0f};
    protected float obstructionGain = 1.0f;
    protected int obstructionFilterType = -1;
    protected float obstructionFilterCutoff = -1.0f;
    protected float occlusionGain = 1.0f;
    protected int occlusionFilterType = -1;
    protected float occlusionFilterCutoff = -1.0f;
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;

    public long getDuration() {
        long l = (long)((double)this.sampleSize / (double)this.sampleFrequency * 1000.0);
        if (debug && debugDuration) {
            System.out.println("JOALSample - getDuration of " + this.index + " is " + l);
        }
        return l;
    }

    public long getStartTime() {
        return 0L;
    }

    public int getNumberOfChannelsUsed() {
        int[] nArray = new int[1];
        this.al.alGetBufferiv(this.index, 8195, nArray, 0);
        this.sampleChannels = nArray[0];
        return this.sampleChannels;
    }

    public void setDirtyFlags(int n) {
        this.dirtyFlags = n;
    }

    public int getDirtyFlags() {
        return this.dirtyFlags;
    }

    public void setSoundType(int n) {
        this.soundType = n;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public void setSoundData(MediaContainer mediaContainer) {
        this.soundData = mediaContainer;
    }

    public MediaContainer getSoundData() {
        return this.soundData;
    }

    public void setMuteFlag(boolean bl) {
        if (debug & debugMute) {
            System.out.println("JOALSample - setMuteFlag " + bl);
        }
        this.mute = bl;
        if (this.mute) {
            this.al.alSourcef(this.index, 4106, 0.0f);
        } else {
            this.al.alSourcef(this.index, 4106, this.gain);
        }
    }

    public boolean getMuteFlag() {
        return this.mute;
    }

    public void setVWrldXfrmFlag(boolean bl) {
        this.vwXfrmFlag = bl;
    }

    public boolean getVWrldXfrmFlag() {
        return this.vwXfrmFlag;
    }

    public void setGain(float f) {
        if (debug & debugGain) {
            System.out.println("JOALSample - setGain " + f);
        }
        this.gain = f;
        this.al.alSourcef(this.index, 4106, f);
    }

    public float getGain() {
        return this.gain;
    }

    public void setLoopCount(int n) {
        if (debug & debugLoopCount) {
            System.out.println("JOALSample - setLoopCount " + n);
        }
        this.loopCount = n;
        if (n == 0) {
            this.al.alSourcei(this.index, 4103, 0);
        } else if (n > 0) {
            this.al.alSourcei(this.index, 4103, 1);
        } else {
            this.al.alSourcei(this.index, 4103, 1);
        }
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setPosition(Point3d point3d) {
        if (debug & debugPosition) {
            System.out.println("JOALSample - setPosition " + point3d);
        }
        this.position.set((Tuple3d)point3d);
        this.positionArray[0] = (float)point3d.x;
        this.positionArray[1] = (float)point3d.y;
        this.positionArray[2] = (float)point3d.z;
        this.al.alSourcefv(this.index, 4100, this.positionArray, 0);
    }

    public void setDistanceGain(double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        int n;
        if (debug & debugDistanceGain) {
            System.out.println("JOALSample - setDistanceGain " + dArray + ", " + fArray);
        }
        if (dArray != null) {
            double d;
            if (dArray.length == 1) {
                d = dArray[0];
                float f = fArray[0];
                this.al.alSourcefv(this.index, 4128, new float[]{(float)d}, 0);
                this.al.alSourcef(this.index, 4129, 1.0f);
            } else if (dArray.length > 1) {
                d = dArray[0];
                double d2 = dArray[dArray.length - 1];
                float f = fArray[0];
                float f2 = fArray[fArray.length - 1];
                this.al.alSourcefv(this.index, 4131, new float[]{(float)d2}, 0);
                this.al.alSourcef(this.index, 4129, 1.0f);
            }
        }
        if (dArray != null) {
            int n2 = dArray.length;
            this.attenuationDistance = new double[n2];
            this.attenuationGain = new float[n2];
            for (n = 0; n < n2; ++n) {
                this.attenuationDistance[n] = dArray[n];
                this.attenuationGain[n] = fArray[n];
            }
        } else {
            this.attenuationDistance = null;
            this.attenuationGain = null;
        }
        if (dArray2 != null && dArray != null) {
            int n3 = dArray2.length;
            this.backAttenuationDistance = new double[n3];
            this.backAttenuationGain = new float[n3];
            for (n = 0; n < n3; ++n) {
                this.backAttenuationDistance[n] = dArray2[n];
                this.backAttenuationGain[n] = fArray2[n];
            }
        } else {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        }
    }

    public void setDirection(Vector3d vector3d) {
        if (debug && debugDirection) {
            System.out.println("JOALSample - setDirection " + vector3d);
        }
        this.direction.set((Tuple3d)vector3d);
        this.directionArray[0] = (float)vector3d.x;
        this.directionArray[1] = (float)vector3d.y;
        this.directionArray[2] = (float)vector3d.z;
        this.al.alSourcefv(this.index, 4101, this.directionArray, 0);
    }

    public void setAngularAttenuation(int n, double[] dArray, float[] fArray, float[] fArray2) {
        if (dArray != null) {
            float f;
            float f2;
            if (dArray.length == 1) {
                f2 = this.radiansToDegrees(dArray[0]);
                this.al.alSourcef(this.index, 4097, f2 / 2.0f);
                this.al.alSourcef(this.index, 4098, f2);
            } else if (dArray.length == 2) {
                f2 = this.radiansToDegrees(dArray[0]);
                f = this.radiansToDegrees(dArray[1]);
                this.al.alSourcef(this.index, 4097, f2);
                this.al.alSourcef(this.index, 4098, f);
            } else {
                f2 = this.radiansToDegrees(dArray[0]);
                f = this.radiansToDegrees(dArray[dArray.length - 1]);
                this.al.alSourcef(this.index, 4097, f2);
                this.al.alSourcef(this.index, 4098, f);
            }
        }
        if (dArray != null) {
            int n2 = dArray.length;
            this.angularDistance = new double[n2];
            this.angularGain = new float[n2];
            this.angularFilterCutoff = (float[])(n != -1 && fArray2 != null ? new float[n2] : null);
            for (int i = 0; i < n2; ++i) {
                this.angularDistance[i] = dArray[i];
                this.angularGain[i] = fArray[i];
                if (n == -1) continue;
                this.angularFilterCutoff[i] = fArray2[i];
            }
            this.angularFilterType = n;
        } else {
            this.angularDistance = null;
            this.angularGain = null;
            this.angularFilterCutoff = null;
            this.angularFilterType = -1;
        }
    }

    public void setRateScaleFactor(float f) {
        this.rateScaleFactor = f;
        this.al.alSourcef(this.index, 4099, f);
    }

    public float getRateScaleFactor() {
        return this.rateScaleFactor;
    }

    public void setObstructionGain(float f) {
        this.obstructionGain = f;
    }

    public float getObstructionGain() {
        return this.obstructionGain;
    }

    public void setObstructionFilter(float f) {
        this.obstructionFilterType = 1;
        this.obstructionFilterCutoff = f;
    }

    public void setOcclusionGain(float f) {
        this.occlusionGain = f;
    }

    public float getOcclusionGain() {
        return this.occlusionGain;
    }

    public void setOcclusionFilter(float f) {
        this.occlusionFilterType = 1;
        this.occlusionFilterCutoff = f;
    }

    public void clear() {
        if (debug && debugClear) {
            System.out.println("JOALSample - clear");
        }
        this.soundData = null;
        this.soundType = -1;
        this.gain = 1.0f;
        this.loopCount = 0;
        this.duration = -1L;
        this.numberOfChannels = 0;
        this.vworldXfrm.setIdentity();
        this.vwXfrmFlag = false;
        this.position.set(0.0f, 0.0f, 0.0f);
        this.positionArray[0] = 0.0f;
        this.positionArray[1] = 0.0f;
        this.positionArray[2] = 0.0f;
        this.attenuationDistance = null;
        this.attenuationGain = null;
        this.direction.set(0.0f, 0.0f, 1.0f);
        this.directionArray[0] = 0.0f;
        this.directionArray[1] = 0.0f;
        this.directionArray[2] = 0.0f;
        this.backAttenuationDistance = null;
        this.backAttenuationGain = null;
        if (this.angularDistance != null) {
            this.angularDistance[0] = 0.0;
            this.angularDistance[1] = 1.5707963705062866;
        }
        if (this.angularGain != null) {
            this.angularGain[0] = 1.0f;
            this.angularGain[1] = 0.0f;
        }
        this.angularFilterType = -1;
        if (this.angularFilterCutoff != null) {
            this.angularFilterCutoff[0] = -1.0f;
            this.angularFilterCutoff[1] = -1.0f;
        }
        this.obstructionGain = 1.0f;
        this.obstructionFilterType = -1;
        this.obstructionFilterCutoff = -1.0f;
        this.occlusionGain = 1.0f;
        this.occlusionFilterType = -1;
        this.occlusionFilterCutoff = -1.0f;
    }

    public void render(int n, View view, AuralParameters auralParameters) {
    }

    public boolean load(AL aL, MediaContainer mediaContainer, int n) {
        Object object;
        if (debug && debugLoad) {
            if (mediaContainer.getURLObject() != null) {
                System.out.print("JOALSample - load " + mediaContainer.getURLObject() + "...");
            } else {
                System.out.print("JOALSample - load " + mediaContainer + "...");
            }
        }
        this.al = aL;
        this.soundType = n;
        InputStream inputStream = mediaContainer.getInputStream();
        if (inputStream == null) {
            object = mediaContainer.getURLObject();
            if (null == object) {
                try {
                    object = new URL(mediaContainer.getURLString());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return true;
                }
            }
            try {
                inputStream = ((URL)object).openStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return true;
            }
        }
        this.buffer = new int[1];
        this.source = new int[1];
        object = new int[1];
        int[] nArray = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        aL.alGenBuffers(1, this.buffer, 0);
        int n2 = aL.alGetError();
        if (n2 != 0) {
            System.out.print(" error generating buffer - JOAL error code: " + n2 + " - ");
        }
        ALut.alutLoadWAVFile((InputStream)inputStream, (int[])object, (ByteBuffer[])byteBufferArray, (int[])nArray, (int[])nArray2, (int[])nArray3);
        aL.alBufferData(this.buffer[0], (int)object[0], (Buffer)byteBufferArray[0], nArray[0], nArray2[0]);
        aL.alGenSources(1, this.source, 0);
        this.sampleSize = nArray[0];
        this.sampleFrequency = nArray2[0];
        this.sampleBits = (int)object[0];
        if (n == 1) {
            if (debug && debugLoad) {
                System.out.print(" BackgroundSound...");
            }
            aL.alSourcei(this.source[0], 4105, this.buffer[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            aL.alSourcei(this.source[0], 4129, 0);
            aL.alSourcei(this.source[0], 514, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (n == 2) {
            if (debug && debugLoad) {
                System.out.print(" PointSound...");
            }
            aL.alGenSources(1, this.source, 0);
            aL.alSourcei(this.source[0], 4105, this.buffer[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (n == 3) {
            if (debug && debugLoad) {
                System.out.print(" ConeSound...");
            }
            aL.alGenSources(1, this.source, 0);
            aL.alSourcei(this.source[0], 4105, this.buffer[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        }
        this.index = this.source[0];
        return false;
    }

    public boolean load(AL aL, int[] nArray, int n) {
        if (debug && debugLoad) {
            System.out.print("JOALSample - load using shared buffer...");
        }
        this.al = aL;
        this.soundType = n;
        this.buffer = nArray;
        this.source = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        aL.alBufferData(nArray[0], nArray2[0], (Buffer)byteBufferArray[0], nArray3[0], nArray4[0]);
        aL.alGenSources(1, this.source, 0);
        this.sampleSize = nArray3[0];
        this.sampleFrequency = nArray4[0];
        this.sampleBits = nArray2[0];
        if (n == 1) {
            if (debug && debugLoad) {
                System.out.print(" BackgroundSound...");
            }
            aL.alSourcei(this.source[0], 4105, nArray[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            aL.alSourcei(this.source[0], 4129, 0);
            aL.alSourcei(this.source[0], 514, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (n == 2) {
            if (debug && debugLoad) {
                System.out.print(" PointSound...");
            }
            aL.alGenSources(1, this.source, 0);
            aL.alSourcei(this.source[0], 4105, nArray[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (n == 3) {
            if (debug && debugLoad) {
                System.out.print(" ConeSound...");
            }
            aL.alGenSources(1, this.source, 0);
            aL.alSourcei(this.source[0], 4105, nArray[0]);
            aL.alSourcef(this.source[0], 4099, 1.0f);
            aL.alSourcef(this.source[0], 4106, 1.0f);
            aL.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        }
        this.index = this.source[0];
        return false;
    }

    public int startSample() {
        this.al.alGetError();
        this.al.alSourcePlay(this.index);
        int n = this.al.alGetError();
        if (n == 0) {
            return 1;
        }
        return -1;
    }

    public int stopSample() {
        this.al.alGetError();
        this.al.alSourceStop(this.index);
        int n = this.al.alGetError();
        if (n == 0) {
            return 1;
        }
        System.out.println("JOALAudioDevice3D - stopSample...error stopping sample " + this.index);
        return -1;
    }

    protected void debugPrint(String string) {
    }

    protected void debugPrintln(String string) {
    }

    private float radiansToDegrees(double d) {
        return (float)(d * 180.0 / pi);
    }

    public AL getAl() {
        return this.al;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    private void clearOpenALBuffer() {
        this.al.alDeleteBuffers(1, this.buffer, 0);
        this.al.alDeleteSources(1, this.source, 0);
    }
}

