/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Point3f;
import org.newdawn.j3d.loaders.bsp.BSPHeader;
import org.newdawn.j3d.loaders.bsp.BSPVertexLump;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;

public class BSPEdgeLump {
    private int[][] edges;
    private BSPVertexLump verts;

    public BSPEdgeLump(BSPHeader header, InputStream file, BSPVertexLump verts) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(file));
        this.verts = verts;
        int len = header.getLength(11);
        this.edges = new int[2][len / 4];
        int offset = header.getOffset(11);
        in.skip(offset);
        int i = 0;
        while (i < this.edges[0].length) {
            this.edges[0][i] = in.readUnsignedShort();
            this.edges[1][i] = in.readUnsignedShort();
            ++i;
        }
        in.close();
    }

    public Point3f getStartPoint(int i) {
        if (i < 0) {
            return this.verts.getPoint(this.edges[1][-i]);
        }
        return this.verts.getPoint(this.edges[0][i]);
    }

    public Point3f getEndPoint(int i) {
        if (i < 0) {
            return this.verts.getPoint(this.edges[0][-i]);
        }
        return this.verts.getPoint(this.edges[1][i]);
    }
}

