/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds;

import com.microcrowd.loader.java3d.max3ds.Loader3DS;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RotPosPathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;

public class Main
extends Applet {
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 3000.0);
    private Canvas3D canvas;
    private String modelLocation;
    private static final String DEFAULT_MODEL = "bounce.3DS";
    private BranchGroup universeBranch;
    static /* synthetic */ Class class$com$microcrowd$loader$java3d$max3ds$Main;

    public static void main(String[] args) {
        Main self = new Main();
        if (args.length > 0) {
            self.modelLocation = args[0];
        }
        MainFrame mainFrame = new MainFrame((Applet)self, 750, 550);
    }

    public void init() {
        try {
            URL location = null;
            location = this.modelLocation == null ? this.findAFile(DEFAULT_MODEL) : this.findAFile(this.modelLocation);
            if (location == null) {
                throw new IllegalArgumentException("No model was found when attempting to retrieve " + (this.modelLocation == null ? DEFAULT_MODEL : this.modelLocation));
            }
            GraphicsConfigTemplate3D config = new GraphicsConfigTemplate3D();
            config.setSceneAntialiasing(2);
            GraphicsDevice[] gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            this.canvas = new Canvas3D(gd[0].getBestConfiguration((GraphicsConfigTemplate)config));
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)this.canvas);
            JMenuBar menuBar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            JMenuItem menuItem = new JMenuItem("Open");
            this.add((Component)menuBar, "North");
            menuBar.add(fileMenu);
            fileMenu.add(menuItem);
            menuItem.addActionListener(new BrowseListener());
            View view = new View();
            Scene scene = this.getScene(location);
            this.universeBranch = this.createUniverse(view, scene);
            view.addCanvas3D(this.canvas);
            this.addSceneToBranch(this.universeBranch, scene);
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.usage(e.getMessage());
        }
    }

    private void addSceneToBranch(BranchGroup branch, Scene scene) {
        this.turnOnBehaviors(scene.getBehaviorNodes());
        BranchGroup modelGroup = scene.getSceneGroup();
        modelGroup.compile();
        branch.addChild((Node)modelGroup);
    }

    public void Main() {
    }

    public Scene getScene(URL location) {
        Object scene = null;
        try {
            return new Loader3DS().load(location);
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.usage(e.getMessage());
            return null;
        }
    }

    public void turnOnBehaviors(Behavior[] behaviors) {
        if (behaviors == null) {
            return;
        }
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].setEnable(true);
            if (behaviors[i] instanceof Interpolator) {
                ((Interpolator)behaviors[i]).setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3000.0));
            }
            if (!(behaviors[i] instanceof TransformInterpolator)) continue;
            ((TransformInterpolator)behaviors[i]).getTarget().setCapability(18);
        }
    }

    private void addCameraInterpolator(TransformGroup target) {
        RotPosPathInterpolator cameraInterpolator = new RotPosPathInterpolator(null, target, new Transform3D(), new float[]{0.0f, 1.0f}, new Quat4f[]{new Quat4f(), new Quat4f()}, new Point3f[]{new Point3f(), new Point3f()});
        cameraInterpolator.setSchedulingBounds((Bounds)this.bounds);
        target.addChild((Node)cameraInterpolator);
    }

    public BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        TransformGroup parentGroup = new TransformGroup();
        parentGroup.setCapability(1);
        parentGroup.setCapability(17);
        parentGroup.setCapability(18);
        parentGroup.setCapability(12);
        parentGroup.setCapability(13);
        parentGroup.setCapability(14);
        root.addChild((Node)parentGroup);
        return root;
    }

    public BranchGroup createUniverse(View view, Scene scene) {
        VirtualUniverse universe = new VirtualUniverse();
        Locale locale = new Locale(universe);
        BranchGroup sceneBranch = this.createSceneGraph();
        BranchGroup viewBranchGroup = new BranchGroup();
        sceneBranch.setCapability(14);
        viewBranchGroup.setCapability(14);
        ViewPlatform platform = new ViewPlatform();
        TransformGroup viewTransformGroup = new TransformGroup();
        viewTransformGroup.setCapability(18);
        viewTransformGroup.setCapability(17);
        viewTransformGroup.setCapability(17);
        TransformGroup[] viewGroups = scene.getViewGroups();
        Transform3D viewTransform = new Transform3D();
        if (viewGroups != null && viewGroups.length > 0) {
            viewGroups[0].getTransform(viewTransform);
        }
        this.addViewKeyBehavior(viewTransformGroup);
        viewTransformGroup.setTransform(viewTransform);
        this.addCameraInterpolator(viewTransformGroup);
        viewTransformGroup.addChild((Node)platform);
        viewBranchGroup.addChild((Node)viewTransformGroup);
        platform.setViewAttachPolicy(2);
        platform.setActivationRadius(100.0f);
        this.configureView(platform, view);
        sceneBranch.setCapability(17);
        viewBranchGroup.compile();
        sceneBranch.compile();
        locale.addBranchGraph(viewBranchGroup);
        locale.addBranchGraph(sceneBranch);
        return sceneBranch;
    }

    public void addViewKeyBehavior(TransformGroup viewTransformGroup) {
        KeyNavigatorBehavior keyBehavior = new KeyNavigatorBehavior((Component)this.canvas, viewTransformGroup);
        keyBehavior.setSchedulingBounds((Bounds)this.bounds);
        viewTransformGroup.addChild((Node)keyBehavior);
    }

    protected void configureView(ViewPlatform platform, View view) {
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        view.setPhysicalEnvironment(environment);
        view.setPhysicalBody(body);
        view.attachViewPlatform(platform);
        view.setBackClipDistance(1000.0);
        view.setFrontClipDistance(1.0);
    }

    public static void usage() {
        Main.usage("");
    }

    public static void usage(String message) {
        System.out.println(message);
        System.out.println("This is a sample program for the java3ds loader");
        System.out.println("usage java -jar Loader3DS <model> where model is the 3ds file");
        System.out.println("Textures for the file should be in the same directory as the model");
        System.out.println("If this is being run as an applet a parameter named model (a relative url) may be provided");
        System.exit(1);
    }

    private URL findAFile(String fileName) {
        URL location = null;
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    return file.toURL();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.usage(e.getMessage());
            }
        }
        if (fileName != null) {
            location = (class$com$microcrowd$loader$java3d$max3ds$Main == null ? (class$com$microcrowd$loader$java3d$max3ds$Main = Main.class$("com.microcrowd.loader.java3d.max3ds.Main")) : class$com$microcrowd$loader$java3d$max3ds$Main).getClassLoader().getResource(fileName);
        }
        if (location != null) {
            return location;
        }
        String relativeURL = this.getParameter("model");
        if (relativeURL != null) {
            try {
                URL codeBase = this.getCodeBase();
                return new URL(codeBase.toString() + relativeURL);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                Main.usage(e.getMessage());
            }
        }
        return location;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Filter3DS
    extends FileFilter {
        private Filter3DS() {
        }

        public String getDescription() {
            return "3DS Files";
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileName = file.getName();
            if (fileName.length() < 4) {
                return false;
            }
            String extension = fileName.substring(fileName.length() - 3, fileName.length());
            return extension.equalsIgnoreCase("3ds");
        }
    }

    private class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        public void actionPerformed(ActionEvent event) {
            File file = null;
            try {
                JFileChooser chooser = new JFileChooser();
                Filter3DS filter = new Filter3DS();
                chooser.setFileFilter(filter);
                chooser.showDialog(Main.this, "wee");
                file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                Scene scene = Main.this.getScene(file.toURL());
                Main.this.addSceneToBranch(Main.this.universeBranch, scene);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("file not loadable " + file);
            }
        }
    }
}

