/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import net.sf.nwn.loader.AnimationBehavior;
import net.sf.nwn.loader.EmitterBehavior;
import net.sf.nwn.loader.ManualParser;
import net.sf.nwn.loader.Model;
import net.sf.nwn.loader.NWNUserData;

public class NWNLoader
extends LoaderBase {
    private Map modelCache;

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        File file = new File(string);
        try {
            return this.load(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            this.rethrow(malformedURLException);
            return null;
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        Object object;
        if (this.getBaseUrl() == null) {
            this.setBaseUrlFromUrl(uRL);
        }
        if (this.modelCache != null && (object = (Model)this.modelCache.get(uRL)) != null) {
            return this.createScene((Model)object);
        }
        try {
            try {
                object = uRL.openStream();
            }
            catch (IOException iOException) {
                object = new GZIPInputStream(new URL(uRL + ".gz").openStream());
            }
            Scene scene = this.load((InputStream)object);
            ((InputStream)object).close();
            return scene;
        }
        catch (IOException iOException) {
            this.rethrow(iOException);
            return null;
        }
    }

    public Scene load(InputStream inputStream) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        ManualParser manualParser = new ManualParser(inputStream);
        return this.load(manualParser);
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        throw new RuntimeException("Reader interface not supported - use input stream");
    }

    private Scene load(ManualParser manualParser) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.initBase();
        try {
            Model model = manualParser.definition();
            return this.createScene(model);
        }
        catch (Exception exception) {
            ParsingErrorException parsingErrorException = new ParsingErrorException(exception.getMessage());
            parsingErrorException.initCause((Throwable)exception);
            throw parsingErrorException;
        }
    }

    public Scene createScene(Model model) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        return this.createScene(model, null);
    }

    public Scene createScene(Model model, URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        if (this.modelCache != null) {
            this.modelCache.put(model.getName(), model);
            if (uRL != null) {
                this.modelCache.put(uRL, model);
            }
        }
        model.fixupEmitters();
        TransformGroup transformGroup = model.getModelGeometry().createAllTG(this.getBaseUrl(), model.isMetallic());
        SceneBase sceneBase = new SceneBase();
        this.addNamed(sceneBase, (Group)transformGroup);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.addChild((Node)transformGroup);
        Behavior behavior = this.createAnimationBehavior(model, sceneBase.getNamedObjects());
        branchGroup.addChild((Node)behavior);
        sceneBase.addNamedObject("AnimationBehavior", (Object)behavior);
        sceneBase.setSceneGroup(branchGroup);
        return sceneBase;
    }

    private void addNamed(SceneBase sceneBase, Group group) {
        if (group.getUserData() instanceof NWNUserData) {
            sceneBase.addNamedObject(((NWNUserData)group.getUserData()).name, (Object)group);
        }
        for (int i = 0; i < group.numChildren(); ++i) {
            Node node = group.getChild(i);
            if (node instanceof Group) {
                this.addNamed(sceneBase, (Group)node);
                continue;
            }
            if (!(node.getUserData() instanceof NWNUserData)) continue;
            sceneBase.addNamedObject(((NWNUserData)node.getUserData()).name, (Object)node);
        }
    }

    public Behavior createAnimationBehavior(Model model, Map map) {
        Object object222;
        Object object3;
        HashMap hashMap = new HashMap();
        for (object3 = model; object3 != null; object3 = ((Model)object3).getSupermodel(this.getBaseUrl(), this.modelCache)) {
            ((Model)object3).getAllAnimations(hashMap);
        }
        object3 = new ArrayList();
        for (Object object222 : hashMap.keySet()) {
            if (((String)object222).indexOf("pause") < 0 && ((String)object222).indexOf("hturn") < 0) continue;
            ((ArrayList)object3).add(object222);
        }
        object222 = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (Map.Entry object4 : map.entrySet()) {
            if (object4.getValue() instanceof TransformGroup) {
                ((HashMap)object222).put(object4.getKey(), object4.getValue());
                continue;
            }
            if (!(object4.getValue() instanceof EmitterBehavior)) continue;
            hashMap2.put(object4.getKey(), object4.getValue());
        }
        AnimationBehavior animationBehavior = new AnimationBehavior((Map)object222, hashMap2, hashMap, (List)object3);
        return animationBehavior;
    }

    public void setBaseUrlFromUrl(URL uRL) throws FileNotFoundException {
        String string = uRL.toString();
        String string2 = string.lastIndexOf(47) == -1 ? uRL.getProtocol() + ":" : string.substring(0, string.lastIndexOf(47) + 1);
        try {
            this.setBaseUrl(new URL(string2));
        }
        catch (MalformedURLException malformedURLException) {
            this.rethrow(malformedURLException);
        }
    }

    private void initBase() throws FileNotFoundException {
        if (this.getBaseUrl() == null) {
            try {
                this.setBaseUrl(new File(".").toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.rethrow(malformedURLException);
            }
        }
    }

    private void rethrow(Throwable throwable) throws FileNotFoundException {
        FileNotFoundException fileNotFoundException = new FileNotFoundException(throwable.getMessage());
        fileNotFoundException.initCause(throwable);
        throw fileNotFoundException;
    }

    public void enableModelCache(boolean bl) {
        this.modelCache = bl ? new HashMap() : null;
    }

    public Map getModelCache() {
        return this.modelCache;
    }
}

