/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SensorBeamEcho
extends Shape3D {
    public SensorBeamEcho(Point3d point3d, double d, boolean bl) {
        int n;
        int n2;
        int n3;
        if (point3d.distance(new Point3d()) == 0.0) {
            throw new IllegalArgumentException("\nBeam echo can't have hotspot at origin");
        }
        Vector3f vector3f = new Vector3f((float)point3d.x, (float)point3d.y, (float)point3d.z);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.normalize(vector3f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        vector3f3.cross(vector3f2, vector3f3);
        if (vector3f3.lengthSquared() < 0.5f) {
            vector3f3.set(0.0f, 0.0f, 1.0f);
            vector3f3.cross(vector3f2, vector3f3);
        }
        vector3f3.normalize();
        int n4 = 18;
        Point3f[] point3fArray = new Point3f[n4];
        Point3f[] point3fArray2 = new Point3f[n4];
        Vector3f[] vector3fArray = new Vector3f[n4];
        Vector3f vector3f4 = new Vector3f(vector3f2);
        Vector3f vector3f5 = new Vector3f(vector3f2);
        vector3f4.negate();
        AxisAngle4f axisAngle4f = new AxisAngle4f(vector3f2, (float)(-Math.PI) / ((float)n4 / 2.0f));
        Transform3D transform3D = new Transform3D();
        transform3D.set(axisAngle4f);
        float f = (float)d / 2.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            vector3fArray[n3] = new Vector3f(vector3f3);
            point3fArray[n3] = new Point3f(vector3f3);
            point3fArray[n3].scale(f);
            point3fArray2[n3] = new Point3f(point3fArray[n3]);
            point3fArray2[n3].add(vector3f);
            transform3D.transform(vector3f3);
        }
        n3 = 2 + 4 * n4;
        Point3f[] point3fArray3 = new Point3f[n3];
        Vector3f[] vector3fArray2 = new Vector3f[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            point3fArray3[n2 * 2] = point3fArray[n2];
            point3fArray3[n2 * 2 + 1] = point3fArray2[n2];
            vector3fArray2[n2 * 2] = vector3fArray[n2];
            vector3fArray2[n2 * 2 + 1] = vector3fArray[n2];
        }
        point3fArray3[n4 * 2] = point3fArray[0];
        point3fArray3[n4 * 2 + 1] = point3fArray2[0];
        vector3fArray2[n4 * 2] = vector3fArray[0];
        vector3fArray2[n4 * 2 + 1] = vector3fArray[0];
        n2 = (n4 + 1) * 2;
        point3fArray3[n2] = point3fArray[0];
        vector3fArray2[n2++] = vector3f4;
        int n5 = 1;
        int n6 = n4 - 1;
        while (n5 <= n6) {
            point3fArray3[n2] = point3fArray[n5++];
            vector3fArray2[n2++] = vector3f4;
            if (n5 > n6) break;
            point3fArray3[n2] = point3fArray[n6--];
            vector3fArray2[n2++] = vector3f4;
        }
        point3fArray3[n2] = point3fArray2[0];
        vector3fArray2[n2++] = vector3f5;
        n5 = 1;
        n6 = n4 - 1;
        while (n5 <= n6) {
            point3fArray3[n2] = point3fArray2[n6--];
            vector3fArray2[n2++] = vector3f5;
            if (n5 > n6) break;
            point3fArray3[n2] = point3fArray2[n5++];
            vector3fArray2[n2++] = vector3f5;
        }
        Material material = new Material();
        material.setCapability(0);
        material.setCapability(1);
        if (bl) {
            n = 3;
            material.setLightingEnable(true);
        } else {
            n = 1;
            material.setLightingEnable(false);
        }
        int[] nArray = new int[]{2 + 2 * n4, n4, n4};
        TriangleStripArray triangleStripArray = new TriangleStripArray(n3, n, nArray);
        triangleStripArray.setCoordinates(0, point3fArray3);
        if (bl) {
            triangleStripArray.setNormals(0, vector3fArray2);
        }
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        appearance.setCapability(0);
        appearance.setCapability(1);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(0);
        transparencyAttributes.setCapability(1);
        transparencyAttributes.setCapability(2);
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(4);
        transparencyAttributes.setCapability(5);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setCapability(10);
        appearance.setCapability(11);
        this.setGeometry((Geometry)triangleStripArray);
        this.setAppearance(appearance);
        this.setCapability(14);
        this.setCapability(15);
    }
}

