/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.pak;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.newdawn.j3d.loaders.pak.PAKHeader;
import org.newdawn.j3d.loaders.pak.PAKListing;

public class PAKArchive {
    private PAKListing listing;
    private File file;

    public PAKArchive(File file) throws IOException {
        this.file = file;
        System.out.println("Loading PAK: " + file.getName());
        PAKHeader header = new PAKHeader(file);
        this.listing = new PAKListing(header, file);
    }

    public InputStream getFile(String filename) throws IOException {
        int offset = this.listing.getFileOffset(filename);
        int length = this.listing.getFileLength(filename);
        if (offset == -1) {
            throw new FileNotFoundException("File " + filename + " not found in PAK");
        }
        FileInputStream in = new FileInputStream(this.file);
        in.skip(offset);
        return new RestrictedLengthInputStream(in, length);
    }

    public static void main(String[] argv) {
        try {
            new PAKArchive(new File("c:\\codin\\java3dcvs\\data\\pak0.pak"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class RestrictedLengthInputStream
    extends InputStream {
        private int length;
        private InputStream in;

        public RestrictedLengthInputStream(InputStream in, int length) throws IOException {
            this.in = in;
            this.length = length > in.available() ? in.available() : length;
        }

        public int read() throws IOException {
            --this.length;
            return this.in.read();
        }

        public int available() throws IOException {
            return this.length;
        }
    }
}

