/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.audioengines.joal;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.Sample;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import net.java.games.joal.util.ALut;
import org.jdesktop.j3d.audioengines.joal.JOALSample;

public class JOALMixer
extends AudioEngine3DL2
implements AudioDevice,
AudioDevice3D,
AudioDevice3DL2 {
    private static boolean debug = true;
    private static boolean debugVersion = true;
    private static boolean debugView = false;
    private static boolean debugPrepareSound = true;
    private static boolean debugGetTotalChannels = false;
    private static boolean debugSampleDuration = false;
    private static boolean debugVelocity = false;
    private static boolean debugPosition = false;
    private static boolean debugDirection = false;
    private static boolean debugDistanceGain = false;
    private static boolean debugGain = false;
    private static boolean debugLoopCount = false;
    private static boolean debugMute = true;
    private static boolean debugUnmute = true;
    private static boolean debugStart = true;
    private static boolean debugStartTime = true;
    private static boolean debugStop = false;
    private static boolean debugClearSound = true;
    private boolean shareBuffer = true;
    private HashMap<Object, int[]> sharedBuffers = new HashMap();
    private boolean calculateDopplerEffect = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    static AL al;
    static ALC alc;
    private float[] singleArray = new float[1];
    private float[] tripleArray = new float[3];
    private View reference;
    private Transform3D transform = new Transform3D();
    private float[] position = new float[3];
    private float[] lastPosition = new float[3];
    private Vector3f positionVector = new Vector3f();
    private Vector3f viewVector = new Vector3f(0.0f, 0.0f, -1.0f);
    private Vector3f upVector = new Vector3f(0.0f, 1.0f, 0.0f);
    private float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    private float[] noVelocity = new float[]{0.0f, 0.0f, 0.0f};
    private float[] orientation = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private long timeOfThisViewUpdate = -1L;
    private long timeSinceLastViewUpdate = -1L;
    private float timeSinceLastViewUpdateInSeconds = -1.0f;
    private long timeOfLastViewUpdate = -1L;

    public JOALMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
        if (debug) {
            System.out.println("JOALMixer - constructor...");
        }
    }

    public void setGain(float f) {
        this.singleArray[0] = f;
        al.alListenerfv(4106, this.singleArray, 0);
    }

    public void resume() {
    }

    public void pause() {
    }

    public void setView(View view) {
        if (debug && debugView) {
            System.out.println("JOALMixer - setView...");
        }
        if (view.getAllCanvas3Ds().hasMoreElements()) {
            view.getUserHeadToVworld(this.transform);
            this.transform.get(this.positionVector);
            this.position[0] = this.positionVector.x;
            this.position[1] = this.positionVector.y;
            this.position[2] = this.positionVector.z;
            al.alListenerfv(4100, this.position, 0);
            if (this.timeOfLastViewUpdate == -1L) {
                this.timeOfLastViewUpdate = System.nanoTime();
                this.lastPosition[0] = this.positionVector.x;
                this.lastPosition[1] = this.positionVector.y;
                this.lastPosition[2] = this.positionVector.z;
            } else {
                this.timeOfThisViewUpdate = System.nanoTime();
                this.timeSinceLastViewUpdate = this.timeOfLastViewUpdate - this.timeOfThisViewUpdate;
                this.timeOfLastViewUpdate = this.timeOfThisViewUpdate;
                if (this.calculateDopplerEffect) {
                    this.timeSinceLastViewUpdateInSeconds = this.timeSinceLastViewUpdate / 1000000L;
                    this.velocity[0] = (this.lastPosition[0] - this.position[0]) / this.timeSinceLastViewUpdateInSeconds;
                    this.velocity[1] = (this.lastPosition[1] - this.position[1]) / this.timeSinceLastViewUpdateInSeconds;
                    this.velocity[2] = (this.lastPosition[2] - this.position[2]) / this.timeSinceLastViewUpdateInSeconds;
                    al.alListenerfv(4102, this.velocity, 0);
                    if (debug & debugVelocity) {
                        System.out.println("JOALMixer - velocity: " + this.velocity[0] + ", " + this.velocity[1] + ", " + this.velocity[2]);
                    }
                } else {
                    al.alListenerfv(4102, this.noVelocity, 0);
                }
                this.lastPosition[0] = this.positionVector.x;
                this.lastPosition[1] = this.positionVector.y;
                this.lastPosition[2] = this.positionVector.z;
            }
            this.viewVector.set(0.0f, 0.0f, -1.0f);
            this.upVector.set(0.0f, 1.0f, 0.0f);
            this.transform.transform(this.viewVector);
            this.transform.transform(this.upVector);
            this.orientation[0] = this.viewVector.x;
            this.orientation[1] = this.viewVector.y;
            this.orientation[2] = this.viewVector.z;
            this.orientation[3] = this.upVector.x;
            this.orientation[4] = this.upVector.y;
            this.orientation[5] = this.upVector.z;
            al.alListenerfv(4111, this.orientation, 0);
        }
        super.setView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareSound(int n, MediaContainer mediaContainer) {
        if (debug && debugPrepareSound) {
            if (mediaContainer.getURLObject() != null) {
                System.out.println("JOALMixer - prepareSound - " + mediaContainer + " - " + mediaContainer.getURLObject());
            } else if (mediaContainer.getURLString() != null) {
                System.out.println("JOALMixer - prepareSound - " + mediaContainer + " - " + mediaContainer.getURLString());
            } else {
                System.out.println("JOALMixer - prepareSound - " + mediaContainer + " - " + mediaContainer.getInputStream());
            }
        }
        int n2 = -1;
        int n3 = 1;
        if (mediaContainer == null) {
            return -1;
        }
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            int n4;
            n2 = n4 = this.samples.size();
            this.samples.ensureCapacity(n2 + 1);
            JOALSample jOALSample = new JOALSample();
            boolean bl = true;
            if (this.shareBuffer) {
                if (mediaContainer.getURLObject() != null) {
                    if (this.sharedBuffers.containsKey(mediaContainer.getURLObject())) {
                        bl = jOALSample.load(al, this.sharedBuffers.get(mediaContainer.getURLObject()), n);
                    } else {
                        bl = jOALSample.load(al, mediaContainer, n);
                        this.sharedBuffers.put(mediaContainer.getURLObject(), jOALSample.getBuffer());
                    }
                } else if (mediaContainer.getURLString() != null) {
                    if (this.sharedBuffers.containsKey(mediaContainer.getURLString())) {
                        bl = jOALSample.load(al, this.sharedBuffers.get(mediaContainer.getURLString()), n);
                    } else {
                        bl = jOALSample.load(al, mediaContainer, n);
                        this.sharedBuffers.put(mediaContainer.getURLString(), jOALSample.getBuffer());
                    }
                } else if (this.sharedBuffers.containsKey(mediaContainer.getInputStream())) {
                    bl = jOALSample.load(al, this.sharedBuffers.get(mediaContainer.getInputStream()), n);
                } else {
                    bl = jOALSample.load(al, mediaContainer, n);
                    this.sharedBuffers.put(mediaContainer.getInputStream(), jOALSample.getBuffer());
                }
            } else {
                bl = jOALSample.load(al, mediaContainer, n);
            }
            if (bl) {
                return -1;
            }
            if (n3 == 2) {
                this.samples.set(n2, jOALSample);
            } else {
                this.samples.add(n2, jOALSample);
            }
            if (debug) {
                System.out.println("JOALMixer - prepareSound - return: " + n2);
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSound(int n) {
        if (debug && debugClearSound) {
            System.out.println("JOALMixer - clearSound " + n);
        }
        Sample sample = null;
        sample = this.getSample(n);
        if (sample == null) {
            return;
        }
        sample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(n, null);
        }
    }

    public long getSampleDuration(int n) {
        if (debug && debugSampleDuration) {
            System.out.println("JOALMixer - getSampleDuration for " + n);
        }
        return super.getSampleDuration(n);
    }

    public int getNumberOfChannelsUsed(int n) {
        return super.getNumberOfChannelsUsed(n);
    }

    public int getNumberOfChannelsUsed(int n, boolean bl) {
        return 1;
    }

    public int startSample(int n) {
        JOALSample jOALSample;
        if (debug & debugStart) {
            System.out.println("JOALMixer - start..." + n);
        }
        if ((jOALSample = (JOALSample)this.getSample(n)) == null) {
            return -1;
        }
        return jOALSample.startSample();
    }

    public long getStartTime(int n) {
        if (debug && debugStartTime) {
            System.out.println("JOALMixer - getStartTime for " + n);
        }
        return -1L;
    }

    public int stopSample(int n) {
        JOALSample jOALSample;
        if (debug & debugStop) {
            System.out.println("JOALMixer - stopSample " + n);
        }
        if ((jOALSample = (JOALSample)this.getSample(n)) == null) {
            return -1;
        }
        return jOALSample.stopSample();
    }

    public void setSampleGain(int n, float f) {
        JOALSample jOALSample;
        if (debug & debugGain) {
            System.out.println("JOALMixer - setSampleGain for " + n + " to " + f);
        }
        if ((jOALSample = (JOALSample)this.getSample(n)) == null) {
            return;
        }
        jOALSample.setGain(f);
    }

    public void setLoop(int n, int n2) {
        if (debug & debugLoopCount) {
            System.out.println("JOALMixer - setLoop for " + n + " to " + n2);
        }
        super.setLoop(n, n2);
    }

    public void setVworldXfrm(int n, Transform3D transform3D) {
        if (debug) {
            System.out.println("JOALMixer - setVworldXfrm...");
        }
        super.setVworldXfrm(n, transform3D);
    }

    public void setPosition(int n, Point3d point3d) {
        if (debug & debugPosition) {
            System.out.println("JOALMixer - setPosition for " + n + " to " + point3d);
        }
        super.setPosition(n, point3d);
    }

    public void setDistanceGain(int n, double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        if (debug & debugDistanceGain) {
            System.out.println("JOALMixer - setDistanceGain for " + n + " with " + dArray + ", " + fArray + ", " + dArray2 + ", " + fArray2);
        }
        super.setDistanceGain(n, dArray, fArray, dArray2, fArray2);
    }

    public void setDirection(int n, Vector3d vector3d) {
        if (debug & debugDirection) {
            System.out.println("JOALMixer - setDirection for " + n + " to " + vector3d);
        }
        super.setDirection(n, vector3d);
    }

    public void setAngularAttenuation(int n, int n2, double[] dArray, float[] fArray, float[] fArray2) {
        if (debug) {
            System.out.println("JOALMixer - setAngularAttenuation...");
        }
        super.setAngularAttenuation(n, n2, dArray, fArray, fArray2);
    }

    public void setRolloff(float f) {
        if (debug) {
            System.out.println("JOALMixer - setRolloff...");
        }
    }

    public void setReflectionCoefficient(float f) {
        if (debug) {
            System.out.println("JOALMixer - setReflectionCoefficient...");
        }
    }

    public void setReverbDelay(float f) {
        if (debug) {
            System.out.println("JOALMixer - setReverbDelay...");
        }
    }

    public void setReverbOrder(int n) {
        if (debug) {
            System.out.println("JOALMixer - setReverbOrder...");
        }
    }

    public void setDistanceFilter(int n, double[] dArray, float[] fArray) {
        if (debug) {
            System.out.println("JOALMixer - setDistanceFilter...");
        }
    }

    public void setFrequencyScaleFactor(float f) {
        if (debug) {
            System.out.println("JOALMixer - setFrequencyScaleFactor to " + f);
        }
    }

    public void setVelocityScaleFactor(float f) {
        if (debug) {
            System.out.println("JOALMixer - setVelocityScaleFactor to " + f);
        }
        super.setVelocityScaleFactor(f);
    }

    public void muteSample(int n) {
        Sample sample;
        if (debug && debugMute) {
            System.out.println("JOALMixer - muteSample " + n);
        }
        if ((sample = this.getSample(n)) != null) {
            sample.setMuteFlag(true);
        }
    }

    public void unmuteSample(int n) {
        Sample sample;
        if (debug && debugUnmute) {
            System.out.println("JOALMixer - unmuteSample for " + n);
        }
        if ((sample = this.getSample(n)) != null) {
            sample.setMuteFlag(false);
        }
    }

    public void pauseSample(int n) {
        if (debug) {
            System.out.println("JOALMixer - pauseSample for " + n);
        }
        al.alSourcePause(n);
    }

    public void unpauseSample(int n) {
        if (debug) {
            System.out.println("JOALMixer - unpauseSample for " + n);
        }
        al.alSourcePlay(n);
    }

    public void updateSample(int n) {
    }

    public boolean initialize() {
        if (debug) {
            System.out.println("JOALMixer - initialize...");
        }
        try {
            ALut.alutInit();
            al = ALFactory.getAL();
            al.alDistanceModel(53249);
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL renderer: " + al.alGetString(45059));
            }
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL vendor: " + al.alGetString(45057));
            }
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL extension: " + al.alGetString(45060));
            }
        }
        catch (ALException aLException) {
            aLException.printStackTrace();
            if (debug) {
                System.out.println("JOALMixer - initialize failed - Error initializing JOALMixer, code: " + al.alGetError());
            }
            return false;
        }
        if (debug) {
            System.out.println("JOALMixer - initialize success.");
        }
        return true;
    }

    public boolean close() {
        if (debug) {
            System.out.println("JOALMixer - close...");
        }
        return false;
    }

    public void setAudioPlaybackType(int n) {
        if (debug) {
            System.out.println("JOALMixer - setAudioPlaybackType to " + n);
        }
        super.setAudioPlaybackType(n);
    }

    public int getAudioPlaybackType() {
        if (debug) {
            System.out.println("JOALMixer - getAudioPlaybackType...");
        }
        return super.getAudioPlaybackType();
    }

    public void setCenterEarToSpeaker(float f) {
        if (debug) {
            System.out.println("JOALMixer - setCenterEarToSpeaker to " + f);
        }
        super.setCenterEarToSpeaker(f);
    }

    public float getCenterEarToSpeaker() {
        if (debug) {
            System.out.println("JOALMixer - getCenterEarToSpeaker...");
        }
        return super.getCenterEarToSpeaker();
    }

    public void setAngleOffsetToSpeaker(float f) {
        if (debug) {
            System.out.println("JOALMixer - setAngleOffsetToSpeaker " + f);
        }
        super.setAngleOffsetToSpeaker(f);
    }

    public float getAngleOffsetToSpeaker() {
        if (debug) {
            System.out.println("JOALMixer - getAngleOffsetToSpeaker...");
        }
        return super.getAngleOffsetToSpeaker();
    }

    public int getTotalChannels() {
        if (debug && debugGetTotalChannels) {
            System.out.println("JOALMixer - getTotalChannels...");
        }
        return 64;
    }

    public int getChannelsAvailable() {
        if (debug) {
            System.out.println("JOALMixer - getChannelsAvailable...");
        }
        return 8;
    }

    public int getChannelsUsedForSound(Sound sound) {
        if (debug) {
            System.out.println("JOALMixer - getChannelsUsedForSound...");
        }
        return super.getChannelsUsedForSound(sound);
    }

    public void setRateScaleFactor(int n, float f) {
        JOALSample jOALSample = (JOALSample)this.getSample(n);
        if (jOALSample == null) {
            return;
        }
        jOALSample.setRateScaleFactor(f);
    }

    public void setReverbCoefficient(float f) {
    }

    public void setReflectionDelay(float f) {
    }

    public void setDecayTime(float f) {
    }

    public void setDecayFilter(float f) {
    }

    public void setDiffusion(float f) {
    }

    public void setDensity(float f) {
    }

    public void setObstructionGain(int n, float f) {
    }

    public void setObstructionFilter(int n, float f) {
    }

    public void setOcclusionGain(int n, float f) {
    }

    public void setOcclusionFilter(int n, float f) {
    }

    static int initOpenAL() {
        String string = "DirectSound3D";
        ALCdevice aLCdevice = alc.alcOpenDevice(string);
        String string2 = alc.alcGetString(aLCdevice, 4101);
        System.out.println("Using device " + string2);
        ALCcontext aLCcontext = alc.alcCreateContext(aLCdevice, null);
        alc.alcMakeContextCurrent(aLCcontext);
        if (alc.alcGetError(aLCdevice) != 0) {
            return 0;
        }
        return 1;
    }

    static void exitOpenAL() {
        ALCcontext aLCcontext = alc.alcGetCurrentContext();
        ALCdevice aLCdevice = alc.alcGetContextsDevice(aLCcontext);
        alc.alcMakeContextCurrent(null);
        alc.alcDestroyContext(aLCcontext);
        alc.alcCloseDevice(aLCdevice);
    }

    private void calculateOrientation(View view) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Transform3D transform3D = new Transform3D();
        view.getUserHeadToVworld(transform3D);
        transform3D.get(vector3f);
        transform3D.transform(vector3f2);
        transform3D.transform(vector3f3);
        System.out.println("Position: " + vector3f);
        System.out.println("viewVector: " + vector3f2);
        System.out.println("upVector: " + vector3f3);
    }
}

