/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.java.games.joal.AL;
import net.java.games.joal.util.ALut;

public class JOALSample2
extends Sample {
    private static boolean debug = true;
    private static boolean debugPosition = false;
    private static boolean debugDirection = false;
    private static boolean debugDistanceGain = false;
    private static boolean debugGain = false;
    private static boolean debugLoopCount = false;
    private static boolean debugMute = false;
    private static boolean debugLoad = true;
    private static boolean debugDuration = false;
    private static boolean debugClear = true;
    private int index;
    private int[] buffer;
    private int[] source;
    private AL al;
    private static double pi = Math.PI;
    private int sampleSize;
    private int sampleBits;
    private int sampleFrequency;
    private int sampleChannels = 1;
    public static final int NULL_SAMPLE = -1;
    protected MediaContainer soundData = null;
    protected int soundType = -1;
    protected float gain = 1.0f;
    protected float rateScaleFactor = 1.0f;
    protected int loopCount = 0;
    public static final int DURATION_UNKNOWN = -1;
    protected long duration = -1L;
    protected int numberOfChannels = 0;
    protected boolean mute = false;
    protected Transform3D vworldXfrm = new Transform3D();
    protected boolean vwXfrmFlag = false;
    protected Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    protected float[] positionArray = new float[]{0.0f, 0.0f, 0.0f};
    protected double[] attenuationDistance = null;
    protected float[] attenuationGain = null;
    protected int dirtyFlags = 65535;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected float[] directionArray = new float[]{0.0f, 0.0f, 0.0f};
    protected double[] backAttenuationDistance = null;
    protected float[] backAttenuationGain = null;
    protected double[] angularDistance = new double[]{0.0, 1.5707963267948966};
    protected float[] angularGain = new float[]{1.0f, 0.0f};
    public static final int NO_FILTERING = -1;
    public static final int LOW_PASS = 1;
    protected int angularFilterType = -1;
    protected float[] angularFilterCutoff = new float[]{-1.0f, -1.0f};
    protected float obstructionGain = 1.0f;
    protected int obstructionFilterType = -1;
    protected float obstructionFilterCutoff = -1.0f;
    protected float occlusionGain = 1.0f;
    protected int occlusionFilterType = -1;
    protected float occlusionFilterCutoff = -1.0f;
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;

    public long getDuration() {
        long duration = (long)((double)this.sampleSize / (double)this.sampleFrequency * 1000.0);
        if (debug && debugDuration) {
            System.out.println("JOALSample - getDuration of " + this.index + " is " + duration);
        }
        return duration;
    }

    public long getStartTime() {
        return 0L;
    }

    public int getNumberOfChannelsUsed() {
        int[] i = new int[1];
        this.al.alGetBufferiv(this.index, 8195, i, 0);
        this.sampleChannels = i[0];
        return this.sampleChannels;
    }

    public void setDirtyFlags(int flags) {
        this.dirtyFlags = flags;
    }

    public int getDirtyFlags() {
        return this.dirtyFlags;
    }

    public void setSoundType(int type) {
        this.soundType = type;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public void setSoundData(MediaContainer ref) {
        this.soundData = ref;
    }

    public MediaContainer getSoundData() {
        return this.soundData;
    }

    public void setMuteFlag(boolean flag) {
        if (debug & debugMute) {
            System.out.println("JOALSample - setMuteFlag " + flag);
        }
        this.mute = flag;
        if (this.mute) {
            this.al.alSourcef(this.index, 4106, 0.0f);
        } else {
            this.al.alSourcef(this.index, 4106, this.gain);
        }
    }

    public boolean getMuteFlag() {
        return this.mute;
    }

    public void setVWrldXfrmFlag(boolean flag) {
        this.vwXfrmFlag = flag;
    }

    public boolean getVWrldXfrmFlag() {
        return this.vwXfrmFlag;
    }

    public void setGain(float scaleFactor) {
        if (debug & debugGain) {
            System.out.println("JOALSample - setGain " + scaleFactor);
        }
        this.gain = scaleFactor;
        this.al.alSourcef(this.index, 4106, scaleFactor);
    }

    public float getGain() {
        return this.gain;
    }

    public void setLoopCount(int count) {
        if (debug & debugLoopCount) {
            System.out.println("JOALSample - setLoopCount " + count);
        }
        this.loopCount = count;
        if (count == 0) {
            this.al.alSourcei(this.index, 4103, 0);
        } else if (count > 0) {
            this.al.alSourcei(this.index, 4103, 1);
        } else {
            this.al.alSourcei(this.index, 4103, 1);
        }
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setPosition(Point3d position) {
        if (debug & debugPosition) {
            System.out.println("JOALSample - setPosition " + position);
        }
        this.position.set((Tuple3d)position);
        this.positionArray[0] = (float)position.x;
        this.positionArray[1] = (float)position.y;
        this.positionArray[2] = (float)position.z;
        this.al.alSourcefv(this.index, 4100, this.positionArray, 0);
    }

    public void setDistanceGain(double[] frontDistance, float[] frontAttenuationScaleFactor, double[] backDistance, float[] backAttenuationScaleFactor) {
        int i;
        if (debug & debugDistanceGain) {
            System.out.println("JOALSample - setDistanceGain " + frontDistance + ", " + frontAttenuationScaleFactor);
        }
        if (frontDistance != null) {
            double d;
            if (frontDistance.length == 1) {
                d = frontDistance[0];
                float f = frontAttenuationScaleFactor[0];
                this.al.alSourcefv(this.index, 4128, new float[]{(float)d}, 0);
                this.al.alSourcef(this.index, 4129, 1.0f);
            } else if (frontDistance.length > 1) {
                d = frontDistance[0];
                double dmax = frontDistance[frontDistance.length - 1];
                float f = frontAttenuationScaleFactor[0];
                float fmax = frontAttenuationScaleFactor[frontAttenuationScaleFactor.length - 1];
                this.al.alSourcefv(this.index, 4131, new float[]{(float)dmax}, 0);
                this.al.alSourcef(this.index, 4129, 1.0f);
            }
        }
        if (frontDistance != null) {
            int size = frontDistance.length;
            this.attenuationDistance = new double[size];
            this.attenuationGain = new float[size];
            for (i = 0; i < size; ++i) {
                this.attenuationDistance[i] = frontDistance[i];
                this.attenuationGain[i] = frontAttenuationScaleFactor[i];
            }
        } else {
            this.attenuationDistance = null;
            this.attenuationGain = null;
        }
        if (backDistance != null && frontDistance != null) {
            int size = backDistance.length;
            this.backAttenuationDistance = new double[size];
            this.backAttenuationGain = new float[size];
            for (i = 0; i < size; ++i) {
                this.backAttenuationDistance[i] = backDistance[i];
                this.backAttenuationGain[i] = backAttenuationScaleFactor[i];
            }
        } else {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        }
    }

    public void setDirection(Vector3d direction) {
        if (debug && debugDirection) {
            System.out.println("JOALSample - setDirection " + direction);
        }
        this.direction.set((Tuple3d)direction);
        this.directionArray[0] = (float)direction.x;
        this.directionArray[1] = (float)direction.y;
        this.directionArray[2] = (float)direction.z;
        this.al.alSourcefv(this.index, 4101, this.directionArray, 0);
    }

    public void setAngularAttenuation(int filterType, double[] angle, float[] attenuationScaleFactor, float[] filterCutoff) {
        if (angle != null) {
            float f2;
            float f1;
            if (angle.length == 1) {
                float f = this.radiansToDegrees(angle[0]);
                this.al.alSourcef(this.index, 4097, f / 2.0f);
                this.al.alSourcef(this.index, 4098, f);
            } else if (angle.length == 2) {
                f1 = this.radiansToDegrees(angle[0]);
                f2 = this.radiansToDegrees(angle[1]);
                this.al.alSourcef(this.index, 4097, f1);
                this.al.alSourcef(this.index, 4098, f2);
            } else {
                f1 = this.radiansToDegrees(angle[0]);
                f2 = this.radiansToDegrees(angle[angle.length - 1]);
                this.al.alSourcef(this.index, 4097, f1);
                this.al.alSourcef(this.index, 4098, f2);
            }
        }
        if (angle != null) {
            int size = angle.length;
            this.angularDistance = new double[size];
            this.angularGain = new float[size];
            this.angularFilterCutoff = (float[])(filterType != -1 && filterCutoff != null ? new float[size] : null);
            for (int i = 0; i < size; ++i) {
                this.angularDistance[i] = angle[i];
                this.angularGain[i] = attenuationScaleFactor[i];
                if (filterType == -1) continue;
                this.angularFilterCutoff[i] = filterCutoff[i];
            }
            this.angularFilterType = filterType;
        } else {
            this.angularDistance = null;
            this.angularGain = null;
            this.angularFilterCutoff = null;
            this.angularFilterType = -1;
        }
    }

    public void setRateScaleFactor(float scaleFactor) {
        this.rateScaleFactor = scaleFactor;
        this.al.alSourcef(this.index, 4099, scaleFactor);
    }

    public float getRateScaleFactor() {
        return this.rateScaleFactor;
    }

    public void setObstructionGain(float scaleFactor) {
        this.obstructionGain = scaleFactor;
    }

    public float getObstructionGain() {
        return this.obstructionGain;
    }

    public void setObstructionFilter(float cutoffFrequency) {
        this.obstructionFilterType = 1;
        this.obstructionFilterCutoff = cutoffFrequency;
    }

    public void setOcclusionGain(float scaleFactor) {
        this.occlusionGain = scaleFactor;
    }

    public float getOcclusionGain() {
        return this.occlusionGain;
    }

    public void setOcclusionFilter(float cutoffFrequency) {
        this.occlusionFilterType = 1;
        this.occlusionFilterCutoff = cutoffFrequency;
    }

    public void clear() {
        if (debug && debugClear) {
            System.out.println("JOALSample - clear");
        }
        this.soundData = null;
        this.soundType = -1;
        this.gain = 1.0f;
        this.loopCount = 0;
        this.duration = -1L;
        this.numberOfChannels = 0;
        this.vworldXfrm.setIdentity();
        this.vwXfrmFlag = false;
        this.position.set(0.0f, 0.0f, 0.0f);
        this.positionArray[0] = 0.0f;
        this.positionArray[1] = 0.0f;
        this.positionArray[2] = 0.0f;
        this.attenuationDistance = null;
        this.attenuationGain = null;
        this.direction.set(0.0f, 0.0f, 1.0f);
        this.directionArray[0] = 0.0f;
        this.directionArray[1] = 0.0f;
        this.directionArray[2] = 0.0f;
        this.backAttenuationDistance = null;
        this.backAttenuationGain = null;
        if (this.angularDistance != null) {
            this.angularDistance[0] = 0.0;
            this.angularDistance[1] = 1.5707963705062866;
        }
        if (this.angularGain != null) {
            this.angularGain[0] = 1.0f;
            this.angularGain[1] = 0.0f;
        }
        this.angularFilterType = -1;
        if (this.angularFilterCutoff != null) {
            this.angularFilterCutoff[0] = -1.0f;
            this.angularFilterCutoff[1] = -1.0f;
        }
        this.obstructionGain = 1.0f;
        this.obstructionFilterType = -1;
        this.obstructionFilterCutoff = -1.0f;
        this.occlusionGain = 1.0f;
        this.occlusionFilterType = -1;
        this.occlusionFilterCutoff = -1.0f;
    }

    public void render(int dirtyFlags, View view, AuralParameters attribs) {
    }

    public boolean load(AL al, MediaContainer soundData, int soundType) {
        if (debug && debugLoad) {
            if (soundData.getURLObject() != null) {
                System.out.print("JOALSample - load " + soundData.getURLObject() + "...");
            } else {
                System.out.print("JOALSample - load " + soundData + "...");
            }
        }
        this.al = al;
        this.soundType = soundType;
        InputStream is = soundData.getInputStream();
        if (is == null) {
            URL url = soundData.getURLObject();
            if (null == url) {
                try {
                    url = new URL(soundData.getURLString());
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                    return true;
                }
            }
            try {
                is = url.openStream();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return true;
            }
        }
        this.buffer = new int[1];
        this.source = new int[1];
        int[] format = new int[1];
        int[] size = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        al.alGenBuffers(1, this.buffer, 0);
        int errorCode = al.alGetError();
        if (errorCode != 0) {
            System.out.print(" error generating buffer - JOAL error code: " + errorCode + " - ");
        }
        ALut.alutLoadWAVFile((InputStream)is, (int[])format, (ByteBuffer[])data, (int[])size, (int[])freq, (int[])loop);
        al.alBufferData(this.buffer[0], format[0], (Buffer)data[0], size[0], freq[0]);
        al.alGenSources(1, this.source, 0);
        this.sampleSize = size[0];
        this.sampleFrequency = freq[0];
        this.sampleBits = format[0];
        if (soundType == 1) {
            if (debug && debugLoad) {
                System.out.print(" BackgroundSound...");
            }
            al.alSourcei(this.source[0], 4105, this.buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            al.alSourcei(this.source[0], 4129, 0);
            al.alSourcei(this.source[0], 514, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (soundType == 2) {
            if (debug && debugLoad) {
                System.out.print(" PointSound...");
            }
            al.alGenSources(1, this.source, 0);
            al.alSourcei(this.source[0], 4105, this.buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (soundType == 3) {
            if (debug && debugLoad) {
                System.out.print(" ConeSound...");
            }
            al.alGenSources(1, this.source, 0);
            al.alSourcei(this.source[0], 4105, this.buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        }
        this.index = this.source[0];
        return false;
    }

    public boolean load(AL al, int[] buffer, int soundType) {
        if (debug && debugLoad) {
            System.out.print("JOALSample - load using shared buffer...");
        }
        this.al = al;
        this.soundType = soundType;
        this.buffer = buffer;
        this.source = new int[1];
        int[] format = new int[1];
        int[] size = new int[1];
        ByteBuffer[] data = new ByteBuffer[1];
        int[] freq = new int[1];
        int[] loop = new int[1];
        al.alBufferData(buffer[0], format[0], (Buffer)data[0], size[0], freq[0]);
        al.alGenSources(1, this.source, 0);
        this.sampleSize = size[0];
        this.sampleFrequency = freq[0];
        this.sampleBits = format[0];
        if (soundType == 1) {
            if (debug && debugLoad) {
                System.out.print(" BackgroundSound...");
            }
            al.alSourcei(this.source[0], 4105, buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            al.alSourcei(this.source[0], 4129, 0);
            al.alSourcei(this.source[0], 514, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (soundType == 2) {
            if (debug && debugLoad) {
                System.out.print(" PointSound...");
            }
            al.alGenSources(1, this.source, 0);
            al.alSourcei(this.source[0], 4105, buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        } else if (soundType == 3) {
            if (debug && debugLoad) {
                System.out.print(" ConeSound...");
            }
            al.alGenSources(1, this.source, 0);
            al.alSourcei(this.source[0], 4105, buffer[0]);
            al.alSourcef(this.source[0], 4099, 1.0f);
            al.alSourcef(this.source[0], 4106, 1.0f);
            al.alSourcei(this.source[0], 4103, 1);
            if (debug && debugLoad) {
                System.out.println(" success, sourceID: " + this.source[0]);
            }
        }
        this.index = this.source[0];
        return false;
    }

    public int startSample() {
        this.al.alGetError();
        this.al.alSourcePlay(this.index);
        int errorCode = this.al.alGetError();
        if (errorCode == 0) {
            return 1;
        }
        return -1;
    }

    public int stopSample() {
        this.al.alGetError();
        this.al.alSourceStop(this.index);
        int errorCode = this.al.alGetError();
        if (errorCode == 0) {
            return 1;
        }
        System.out.println("JOALAudioDevice3D - stopSample...error stopping sample " + this.index);
        return -1;
    }

    protected void debugPrint(String message) {
    }

    protected void debugPrintln(String message) {
    }

    private float radiansToDegrees(double radians) {
        return (float)(radians * 180.0 / pi);
    }

    public AL getAl() {
        return this.al;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    private void clearOpenALBuffer() {
        this.al.alDeleteBuffers(1, this.buffer, 0);
        this.al.alDeleteSources(1, this.source, 0);
    }

    private boolean checkForErrors() {
        int i = this.al.alGetError();
        if (i != 0) {
            if (debug) {
                System.out.println("JOALSample - openAL error - " + i);
            }
            return true;
        }
        return false;
    }
}

