/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.chunks;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.ChunkMap;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;

public class MaterialChunk
extends Chunk {
    public void initialize(ChunkChopper chopper) {
        Float transparency;
        Boolean twoSided;
        Texture texture;
        Color3f color;
        Appearance appearance = new Appearance();
        Material material = new Material();
        Color3f ambientColor = (Color3f)chopper.popData(ChunkMap.AMBIENT_COLOR);
        if (ambientColor != null) {
            material.setAmbientColor(ambientColor);
        }
        if ((color = (Color3f)chopper.popData(ChunkMap.DIFFUSE_COLOR)) != null) {
            material.setDiffuseColor(color);
        }
        if ((color = (Color3f)chopper.popData(ChunkMap.SPECULAR_COLOR)) != null) {
            material.setSpecularColor(color);
        }
        if ((texture = (Texture)chopper.popData(ChunkMap.TEXTURE)) != null) {
            appearance.setTexture(texture);
        }
        if ((twoSided = (Boolean)chopper.popData(ChunkMap.TWO_SIDED)) != null) {
            PolygonAttributes polyAttributes = appearance.getPolygonAttributes();
            if (polyAttributes == null) {
                polyAttributes = new PolygonAttributes();
            }
            polyAttributes.setCullFace(0);
            appearance.setPolygonAttributes(polyAttributes);
        }
        if ((transparency = (Float)chopper.popData(ChunkMap.TRANSPARENCY)) != null && transparency.floatValue() > 0.01f) {
            TransparencyAttributes transparencyAttributes = new TransparencyAttributes(0, transparency.floatValue());
            appearance.setTransparencyAttributes(transparencyAttributes);
        }
        String name = (String)chopper.popData(ChunkMap.MATERIAL_NAME);
        Float shininess = (Float)chopper.popData(ChunkMap.SHININESS);
        if (shininess != null) {
            float shine = shininess.floatValue() * 1024.0f;
            material.setShininess(shine);
        }
        appearance.setMaterial(material);
        chopper.setNamedObject(name, appearance);
    }
}

