/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.apng;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import javax.imageio.stream.ImageInputStream;

class Chunk {
    int length;
    byte[] type = new byte[4];
    String typeStr;
    byte[] data;
    long crc;

    public Chunk(ImageInputStream iis) throws IOException {
        this.length = iis.readInt();
        iis.readFully(this.type);
        this.typeStr = String.format("%c%c%c%c", Character.valueOf((char)this.type[0]), Character.valueOf((char)this.type[1]), Character.valueOf((char)this.type[2]), Character.valueOf((char)this.type[3]));
        this.data = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = iis.readByte();
        }
        this.crc = 0xFFFFFFFFL & (long)iis.readInt();
        this.crcCheck();
    }

    void crcCheck() {
        CRC32 c = new CRC32();
        c.update(this.type);
        c.update(this.data);
        if (this.crc != c.getValue()) {
            System.out.println("CRC32:ERROR!");
        }
    }

    public DataInputStream getDataInputStream() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        BufferedInputStream bis = new BufferedInputStream(bais);
        DataInputStream dis = new DataInputStream(bis);
        return dis;
    }

    public String toString() {
        return "Chunk(type=" + this.typeStr + ",len=" + this.length + ")";
    }
}

