/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.apng;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import jp.sourceforge.acerola3d.apng.APNGMetadataFormat;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class APNGMetadata
extends IIOMetadata {
    static final boolean standardMetadataFormatSupported = false;
    static final String nativeMetadataFormatName = "jp.sourceforge.acerola3d.apng.APNGMetadata_0.01";
    static final String nativeMetadataFormatClassName = "jp.sourceforge.acerola3d.apng.APNGMetadata";
    static final String[] extraMetadataFormatNames = null;
    static final String[] extraMetadataFormatClassNames = null;
    List<String> keywords = new ArrayList<String>();
    List<String> values = new ArrayList<String>();

    public APNGMetadata() {
        super(false, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
    }

    @Override
    public IIOMetadataFormat getMetadataFormat(String formatName) {
        if (!formatName.equals(nativeMetadataFormatName)) {
            throw new IllegalArgumentException("Bad format name!");
        }
        return APNGMetadataFormat.getDefaultInstance();
    }

    @Override
    public Node getAsTree(String formatName) {
        if (!formatName.equals(nativeMetadataFormatName)) {
            throw new IllegalArgumentException("Bad format name!");
        }
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        Iterator<String> keywordIter = this.keywords.iterator();
        Iterator<String> valueIter = this.values.iterator();
        while (keywordIter.hasNext()) {
            IIOMetadataNode node = new IIOMetadataNode("KeywordValuePair");
            node.setAttribute("keyword", keywordIter.next());
            node.setAttribute("value", valueIter.next());
            root.appendChild(node);
        }
        return root;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void reset() {
        this.keywords = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (!formatName.equals(nativeMetadataFormatName)) {
            throw new IllegalArgumentException("Bad format name!");
        }
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node, "Root must be jp.sourceforge.acerola3d.apng.APNGMetadata_0.01");
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals("KeywordValuePair")) {
                this.fatal(node, "Node name not KeywordValuePair!");
            }
            NamedNodeMap attributes = node.getAttributes();
            Node keywordNode = attributes.getNamedItem("keyword");
            Node valueNode = attributes.getNamedItem("value");
            if (keywordNode == null || valueNode == null) {
                this.fatal(node, "Keyword or value missing!");
            }
            this.keywords.add(keywordNode.getNodeValue());
            this.values.add(valueNode.getNodeValue());
        }
    }

    private void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }
}

