/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.ManualParser;
import net.sf.nwn.loader.ModelAnimation;

public class Model {
    private String name;
    private String supermodelName;
    private float animationScale;
    private String classification;
    private GeomNode modelGeometry;
    private LinkedHashMap animations = new LinkedHashMap();

    public Model(String string) {
        this.name = string.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.toLowerCase();
    }

    public float getAnimationScale() {
        return this.animationScale;
    }

    public void setAnimationScale(float f) {
        this.animationScale = f;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String string) {
        this.classification = string;
    }

    public String getSupermodelName() {
        return this.supermodelName;
    }

    public void setSupermodelName(String string) {
        this.supermodelName = string;
    }

    public Model getSupermodel(URL uRL, Map map) {
        Object object;
        if (this.getSupermodelName() == null || this.getSupermodelName().equalsIgnoreCase("null")) {
            return null;
        }
        if (map != null && (object = (Model)map.get(this.getSupermodelName())) != null) {
            return object;
        }
        try {
            try {
                object = new URL(uRL, this.getSupermodelName() + ".mdl").openStream();
            }
            catch (IOException iOException) {
                object = new GZIPInputStream(new URL(uRL, this.getSupermodelName() + ".mdl.gz").openStream());
            }
            Model model = ManualParser.sharedParser.reinit((InputStream)object).definition();
            ((InputStream)object).close();
            if (map != null) {
                map.put(this.getSupermodelName(), model);
            }
            return model;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public GeomNode getModelGeometry() {
        return this.modelGeometry;
    }

    public void setModelGeometry(GeomNode geomNode) {
        this.modelGeometry = geomNode;
    }

    public void addModelAnimation(ModelAnimation modelAnimation) {
        this.animations.put(modelAnimation.getName(), modelAnimation);
    }

    public String toString() {
        return "Model(" + this.getName() + ") \n" + this.modelGeometry + "\n" + this.animations.values();
    }

    public void addNamed(Map map, Group group) {
        if (group.getUserData() instanceof String) {
            map.put((String)group.getUserData(), group);
        }
        for (int i = 0; i < group.numChildren(); ++i) {
            Node node = group.getChild(i);
            if (!(node instanceof Group)) continue;
            this.addNamed(map, (Group)node);
        }
    }

    public boolean isMetallic() {
        return false;
    }

    public boolean isMetallic_ORG() {
        return this.getSupermodelName() != null && !this.getSupermodelName().equalsIgnoreCase("null") || this.animations.size() > 0;
    }

    public ModelAnimation findAnimation(String string) {
        return (ModelAnimation)this.animations.get(string);
    }

    public void getAllAnimations(Map map) {
        for (Map.Entry entry : this.animations.entrySet()) {
            map.put(this.getName() + ":" + entry.getKey(), entry.getValue());
        }
    }

    public void dump(StringBuffer stringBuffer) {
        stringBuffer.append("#Dumped by java\n");
        stringBuffer.append("newmodel ").append(this.getName()).append("\n");
        stringBuffer.append("setsupermodel ").append(this.getName()).append(" ").append(this.getSupermodelName()).append("\n");
        stringBuffer.append("classification ").append(this.getClassification()).append("\n");
        stringBuffer.append("setanimationscale ").append(this.getAnimationScale()).append("\n\n");
        stringBuffer.append("beginmodelgeom ").append(this.getName()).append("\n");
        this.modelGeometry.dump(stringBuffer);
        stringBuffer.append("endmodelgeom ").append(this.getName()).append("\n\n");
        Iterator iterator = this.animations.values().iterator();
        while (iterator.hasNext()) {
            ((ModelAnimation)iterator.next()).dump(stringBuffer);
        }
        stringBuffer.append("donemodel ").append(this.getName()).append("\n");
    }

    public void fixupEmitters() {
        for (ModelAnimation modelAnimation : this.animations.values()) {
            modelAnimation.fixupEmitters(this.modelGeometry);
        }
    }
}

