/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.bif;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.nwn.bif.BifFile;
import net.sf.nwn.bif.CommonFile;

public class KeyFile
extends CommonFile {
    int bifCount;
    int resCount;
    int bifOffset;
    int resOffset;
    ArrayList bifEntries = new ArrayList();
    ArrayList resEntries = new ArrayList();

    public KeyFile(File file) throws IOException {
        super(file);
        int n;
        this.bb.getInt();
        this.bb.getInt();
        this.bifCount = this.bb.getInt();
        this.resCount = this.bb.getInt();
        this.bifOffset = this.bb.getInt();
        this.resOffset = this.bb.getInt();
        this.bb.position(this.bifOffset);
        for (n = 0; n < this.bifCount; ++n) {
            this.bifEntries.add(new BifEntry(this.bb.getInt(), this.getString(this.bb.getInt(), this.bb.getShort())));
            this.bb.getShort();
        }
        this.bb.position(this.resOffset);
        for (n = 0; n < this.resCount; ++n) {
            this.resEntries.add(new ResEntry(this.getString(16), this.bb.getShort(), this.bb.getInt()));
        }
        this.fc.close();
        this.fis.close();
    }

    public void dump() {
        int n;
        System.out.println("BIF count: " + this.bifCount + " at offset " + KeyFile.hex(this.bifOffset));
        System.out.println("Res count: " + this.resCount + " at offset " + KeyFile.hex(this.resOffset));
        System.out.println("BIFLIST");
        for (n = 0; n < this.bifEntries.size(); ++n) {
            System.out.println(this.bifEntries.get(n));
        }
        System.out.println("RESLIST");
        for (n = 0; n < this.resEntries.size(); ++n) {
            System.out.println(this.resEntries.get(n));
        }
    }

    public void unpack(File file, File file2) throws IOException {
        int n;
        BifFile[] bifFileArray = new BifFile[this.bifCount];
        File[] fileArray = new File[this.bifCount];
        for (n = 0; n < this.bifCount; ++n) {
            bifFileArray[n] = new BifFile(new File(file, ((BifEntry)this.bifEntries.get((int)n)).name));
            fileArray[n] = new File(file2, ((BifEntry)this.bifEntries.get((int)n)).name + ".dir");
            fileArray[n].mkdirs();
        }
        for (n = 0; n < this.resCount; ++n) {
            ResEntry resEntry = (ResEntry)this.resEntries.get(n);
            BifFile bifFile = bifFileArray[resEntry.getSourceIndex()];
            File file3 = new File(fileArray[resEntry.getSourceIndex()], resEntry.name + "." + this.ext(resEntry.type));
            bifFile.dumpResource(resEntry.getFileIndex(), file3);
        }
        for (n = 0; n < this.bifCount; ++n) {
            bifFileArray[n].close();
        }
    }

    public String ext(int n) {
        switch (n) {
            case 1: {
                return "bmp";
            }
            case 3: {
                return "tga";
            }
            case 6: {
                return "plt";
            }
            case 7: {
                return "ini";
            }
            case 2002: {
                return "mdl";
            }
            case 2009: {
                return "scr";
            }
            case 2010: {
                return "ncs";
            }
            case 2013: {
                return "tileset";
            }
            case 2015: {
                return "bic";
            }
            case 2016: {
                return "walkmesh";
            }
            case 2017: {
                return "2da";
            }
            case 2025: {
                return "uti";
            }
            case 2027: {
                return "utc";
            }
            case 2030: {
                return "itp";
            }
            case 2032: {
                return "utt";
            }
            case 2036: {
                return "ltr";
            }
            case 2037: {
                return "gff";
            }
            case 2042: {
                return "utd";
            }
            case 2044: {
                return "utp";
            }
            case 2058: {
                return "utw";
            }
        }
        return KeyFile.hex(n);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0 || stringArray.length > 2) {
            System.out.println("Usage: keyfile - if you want a contents list");
            System.out.println("Usage: keyfile outdir - if you want unpack");
            System.exit(1);
        }
        File file = new File(stringArray[0]).getAbsoluteFile();
        if (stringArray.length == 1) {
            KeyFile keyFile = new KeyFile(file);
            keyFile.close();
            keyFile.dump();
            return;
        }
        File file2 = file.getParentFile();
        File file3 = new File(stringArray[1]);
        KeyFile keyFile = new KeyFile(file);
        keyFile.close();
        keyFile.unpack(file2, file3);
    }

    static class ResEntry {
        String name;
        int type;
        int code;

        public ResEntry(String string, int n, int n2) {
            this.name = string;
            this.type = n;
            this.code = n2;
        }

        public int getSourceIndex() {
            return this.code >> 20 & 0xFFF;
        }

        public int getTilesetIndex() {
            return this.code >> 14 & 0x1F;
        }

        public int getFileIndex() {
            return this.code & 0x1FFF;
        }

        public String toString() {
            return "RES: " + this.name + " type:" + CommonFile.hex(this.type) + " code:" + this.getSourceIndex() + "/" + this.getTilesetIndex() + "/" + this.getFileIndex();
        }
    }

    static class BifEntry {
        int length;
        String name;

        public BifEntry(int n, String string) {
            this.length = n;
            this.name = string;
        }

        public String toString() {
            return "BIF: " + this.name + " " + this.length;
        }
    }
}

