/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AIgnoredAlt;
import org.sablecc.sablecc.node.AParsedAlt;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.Start;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenAnalyses
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private List altList;
    private List tokenList;
    private String mainProduction;
    ElemInfo info;

    public void inAProd(AProd aProd) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ids.names.get(aProd);
        }
    }

    public void inATokenDef(ATokenDef aTokenDef) {
        this.tokenList.add(this.ids.names.get(aTokenDef));
    }

    public void inAParsedAlt(AParsedAlt aParsedAlt) {
        this.inPAlt(aParsedAlt);
    }

    public void inAIgnoredAlt(AIgnoredAlt aIgnoredAlt) {
        this.inPAlt(aIgnoredAlt);
    }

    public void inPAlt(PAlt pAlt) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    public void inAElem(AElem aElem) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ids.names.get(aElem);
        this.info.type = (String)this.ids.elemTypes.get(aElem);
        this.info.operator = 0;
        if (aElem.getUnOp() != null) {
            aElem.getUnOp().apply(new DepthFirstAdapter(this){
                final /* synthetic */ GenAnalyses this$0;

                public final void caseAStarUnOp(AStarUnOp aStarUnOp) {
                    this.this$0.info.operator = 1;
                }

                public final void caseAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
                    this.this$0.info.operator = 2;
                }

                public final void caseAPlusUnOp(APlusUnOp aPlusUnOp) {
                    this.this$0.info.operator = 3;
                }
                {
                    this.this$0 = genAnalyses;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    public void outAParsedAlt(AParsedAlt aParsedAlt) {
        this.outPAlt(aParsedAlt);
    }

    public void outAIgnoredAlt(AIgnoredAlt aIgnoredAlt) {
        this.outPAlt(aIgnoredAlt);
    }

    public void outPAlt(PAlt pAlt) {
        AltInfo altInfo = new AltInfo();
        altInfo.name = (String)this.ids.names.get(pAlt);
        altInfo.elems.addAll(this.elemList);
        this.elemList = null;
        this.altList.add(altInfo);
    }

    public void outStart(Start start) {
        this.createAnalysis();
        this.createAnalysisAdapter();
        if (this.mainProduction != null) {
            this.createDepthFirstAdapter();
            this.createReversedDepthFirstAdapter();
        }
    }

    public void createAnalysis() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Analysis.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            Iterator iterator;
            this.macros.apply(bufferedWriter, "AnalysisHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisStart", null);
                iterator = this.altList.iterator();
                while (iterator.hasNext()) {
                    AltInfo altInfo = (AltInfo)iterator.next();
                    this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{altInfo.name});
                }
                bufferedWriter.newLine();
            }
            iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createAnalysisAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "AnalysisAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            Iterator iterator;
            this.macros.apply(bufferedWriter, "AnalysisAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterStart", null);
                iterator = this.altList.iterator();
                while (iterator.hasNext()) {
                    AltInfo altInfo = (AltInfo)iterator.next();
                    this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{altInfo.name});
                }
            }
            iterator = this.tokenList.iterator();
            while (iterator.hasNext()) {
                this.macros.apply(bufferedWriter, "AnalysisAdapterBody", new String[]{(String)iterator.next()});
            }
            this.macros.apply(bufferedWriter, "AnalysisAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "DepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "DepthFirstAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", this.mainProduction});
            Iterator iterator = this.altList.iterator();
            while (iterator.hasNext()) {
                AltInfo altInfo = (AltInfo)iterator.next();
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                Iterator iterator2 = altInfo.elems.iterator();
                while (iterator2.hasNext()) {
                    ElemInfo elemInfo = (ElemInfo)iterator2.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createReversedDepthFirstAdapter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "ReversedDepthFirstAdapter.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", this.mainProduction});
            Iterator iterator = this.altList.iterator();
            while (iterator.hasNext()) {
                AltInfo altInfo = (AltInfo)iterator.next();
                this.macros.apply(bufferedWriter, "DepthFirstAdapterInOut", new String[]{altInfo.name});
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseHeader", new String[]{altInfo.name});
                ListIterator listIterator = altInfo.elems.listIterator(altInfo.elems.size());
                while (listIterator.hasPrevious()) {
                    ElemInfo elemInfo = (ElemInfo)listIterator.previous();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseBodyNode", new String[]{elemInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ReversedDepthFirstAdapterCaseBodyList", new String[]{elemInfo.name, elemInfo.type});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "DepthFirstAdapterCaseTail", new String[]{altInfo.name});
            }
            this.macros.apply(bufferedWriter, "DepthFirstAdapterTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final /* synthetic */ void this() {
        this.altList = new TypedLinkedList(AltInfoCast.instance);
        this.tokenList = new TypedLinkedList(StringCast.instance);
    }

    public GenAnalyses(ResolveIds resolveIds) {
        this.this();
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("analyses.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open analyses.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "analysis");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "analysis" : resolveIds.pkgName + ".analysis";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }

    private static class ElemInfoCast
    implements Cast {
        static final ElemInfoCast instance = new ElemInfoCast();

        public Object cast(Object object) {
            return (ElemInfo)object;
        }

        private ElemInfoCast() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class AltInfo {
        String name;
        final List elems;

        private final /* synthetic */ void this() {
            this.elems = new TypedLinkedList(ElemInfoCast.instance);
        }

        private AltInfo() {
            this.this();
        }
    }

    private static class AltInfoCast
    implements Cast {
        static final AltInfoCast instance = new AltInfoCast();

        public Object cast(Object object) {
            return (AltInfo)object;
        }

        private AltInfoCast() {
        }
    }
}

