/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.VRML;
import jp.sourceforge.acerola3d.a3panels.MyExamController;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

public class VrmlPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JLabel statusBarLabel;
    Action3D measure;
    VRML vrml;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public VrmlPanel(final String urlString) {
        this.setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.add((Component)baseBox, "Center");
        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.a3canvas.setPreferredSize(new Dimension(300, 300));
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        try {
            Action3D.clearCash((String)"x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (urlString != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VrmlPanel.this.loadVRML(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();
        this.menuBar = new JMenuBar();
        controlBox.myAdd(this.menuBar, 0.0);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.measureMenu = new JMenu("measure");
        this.configMenu.add(this.measureMenu);
        this.measureXZMenuItem = new JMenuItem("measure XZ");
        this.measureXZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXZMenuItem);
        this.measureXYMenuItem = new JMenuItem("measure XY");
        this.measureXYMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXYMenuItem);
        this.measureYZMenuItem = new JMenuItem("measure YZ");
        this.measureYZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureYZMenuItem);
        this.measureNoneMenuItem = new JMenuItem("measure None");
        this.measureNoneMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureNoneMenuItem);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(Box.createVerticalGlue(), 1.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.resetViewButton) {
            this.controller.adjust((A3Object)this.vrml);
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.controller.adjust((A3Object)this.vrml);
        } else if (ae.getSource() == this.measureXZMenuItem) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureXYMenuItem) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureYZMenuItem) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureNoneMenuItem) {
            this.a3canvas.del((A3Object)this.measure);
        } else {
            System.out.append("gaha???");
        }
    }

    void loadVRML(String urlString) {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.vrml != null) {
            this.a3canvas.del((A3Object)this.vrml);
        }
        try {
            A23.initA23();
            VRML.clearCash((String)urlString);
            this.vrml = VRML.load((String)urlString);
            this.controller.adjust((A3Object)this.vrml);
        }
        catch (Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        this.a3canvas.add((A3Object)this.vrml);
        this.vrml.setLocImmediately(0.0, 0.0, 0.0);
        this.vrml.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.vrml.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                VrmlPanel.this.controller.adjust((A3Object)VrmlPanel.this.vrml);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    public void loadVRML(File f) {
        try {
            final String urlString = f.toURI().toURL().toString();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VrmlPanel.this.loadVRML(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    void setBackground(String bgUrlString) {
        URL url = null;
        try {
            url = new URL(bgUrlString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
    }
}

