/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;
import jp.sourceforge.acerola3d.sound.A3SoundType;

public class SoundPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3Sound sound;
    JButton playPauseB;

    public SoundPanel(String urlString) {
        this.setLayout(new BorderLayout());
        this.playPauseB = new JButton("play");
        this.playPauseB.addActionListener(this);
        this.add((Component)this.playPauseB, "Center");
        if (urlString != null) {
            try {
                A3SoundSystem ss = A3SoundSystem.getDefaultSoundSystem();
                this.sound = ss.load(urlString, 0.0f, A3SoundType.BackgroundSound, 1.0f, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSound(String urlString) {
        A3SoundSystem ss = A3SoundSystem.getDefaultSoundSystem();
        try {
            this.sound = ss.load(urlString, 0.0f, A3SoundType.BackgroundSound, 1.0f, true);
            this.playPauseB.setText("play");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSound(File f) {
        try {
            String urlString = f.toURI().toURL().toString();
            this.loadSound(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.playPauseB.getText().equals("play")) {
            this.sound.start();
            this.playPauseB.setText("stop");
        } else {
            this.sound.stop();
            this.playPauseB.setText("play");
        }
    }

    public void clear() {
        if (this.sound != null) {
            this.sound.stop();
        }
    }
}

