/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Skeleton;
import jp.sourceforge.acerola3d.a3panels.MyExamController;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

public class BVHPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JCheckBox defaultPoseCheckBox;
    JComboBox boneComboBox;
    JLabel statusBarLabel;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength = 100;
    double motionLength;
    Action3D measure;
    Skeleton skeleton;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public BVHPanel(final String urlString) {
        this.setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.add((Component)baseBox, "Center");
        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.a3canvas.setPreferredSize(new Dimension(300, 300));
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        Box box3 = Box.createHorizontalBox();
        baseBox.myAdd(box3, 0.0);
        this.pauseCheckBox = new JCheckBox("puase");
        this.pauseCheckBox.setSelected(false);
        this.pauseCheckBox.addActionListener(this);
        box3.add(this.pauseCheckBox);
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.sliderLength);
        this.slider.addChangeListener(this);
        box3.add(this.slider);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        try {
            Action3D.clearCash((String)"x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (urlString != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BVHPanel.this.loadBVH(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();
        this.menuBar = new JMenuBar();
        controlBox.myAdd(this.menuBar, 0.0);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.measureMenu = new JMenu("measure");
        this.configMenu.add(this.measureMenu);
        this.measureXZMenuItem = new JMenuItem("measure XZ");
        this.measureXZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXZMenuItem);
        this.measureXYMenuItem = new JMenuItem("measure XY");
        this.measureXYMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXYMenuItem);
        this.measureYZMenuItem = new JMenuItem("measure YZ");
        this.measureYZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureYZMenuItem);
        this.measureNoneMenuItem = new JMenuItem("measure None");
        this.measureNoneMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureNoneMenuItem);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        this.defaultPoseCheckBox = new JCheckBox("default pose");
        this.defaultPoseCheckBox.setSelected(false);
        this.defaultPoseCheckBox.addActionListener(this);
        controlBox.myAdd(this.defaultPoseCheckBox, 0.0);
        this.boneComboBox = new JComboBox();
        this.boneComboBox.addActionListener(this);
        this.boneComboBox.addItem("[none]");
        controlBox.myAdd(this.boneComboBox, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(Box.createVerticalGlue(), 1.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.resetViewButton) {
            this.controller.adjust((A3Object)this.skeleton);
        } else if (ae.getSource() == this.defaultPoseCheckBox) {
            if (this.defaultPoseCheckBox.isSelected()) {
                this.skeleton.defaultPose();
            } else {
                this.skeleton.start();
            }
        } else if (ae.getSource() == this.measureXZMenuItem) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureXYMenuItem) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureYZMenuItem) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureNoneMenuItem) {
            this.a3canvas.del((A3Object)this.measure);
        } else if (ae.getSource() == this.pauseCheckBox) {
            if (this.skeleton == null) {
                return;
            }
            if (this.pauseCheckBox.isSelected()) {
                this.skeleton.pause();
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.skeleton.setPauseTime(t);
            } else {
                this.skeleton.start();
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.skeleton.setPauseTime(t);
            }
        } else if (ae.getSource() == this.boneComboBox) {
            this.selectBone();
        } else {
            System.out.append("gaha???");
        }
    }

    void selectBone() {
        String bn = (String)this.boneComboBox.getSelectedItem();
        if (bn == null) {
            System.out.println("gaha1");
            return;
        }
        if (bn.equals("[none]")) {
            this.resetBone();
        } else {
            this.resetBone();
            this.skeleton.setBoneSelected(bn, true);
        }
    }

    void resetBone() {
        if (this.skeleton == null) {
            return;
        }
        this.skeleton.resetSelected();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.slider) {
            if (this.skeleton == null) {
                return;
            }
            double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
            this.skeleton.setPauseTime(t);
        }
    }

    void loadBVH(String urlString) {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.skeleton != null) {
            this.a3canvas.del((A3Object)this.skeleton);
        }
        try {
            A23.initA23();
            this.skeleton = new Skeleton(urlString);
            this.controller.adjust((A3Object)this.skeleton);
        }
        catch (Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        this.a3canvas.add((A3Object)this.skeleton);
        this.boneComboBox.removeAllItems();
        this.boneComboBox.addItem("[none]");
        for (String bn : this.skeleton.getBones()) {
            this.boneComboBox.addItem(bn);
        }
        if (this.pauseCheckBox.isSelected()) {
            this.skeleton.pause();
        } else {
            this.skeleton.start();
        }
        this.slider.setValue(0);
        this.motionLength = this.skeleton.getMotionLength();
        this.skeleton.setLocImmediately(0.0, 0.0, 0.0);
        this.skeleton.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.skeleton.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BVHPanel.this.controller.adjust((A3Object)BVHPanel.this.skeleton);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    public void loadBVH(File f) {
        try {
            final String urlString = f.toURI().toURL().toString();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BVHPanel.this.loadBVH(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

