/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;
import jp.sourceforge.acerola3d.a3editor.Catalog;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

public class A3eMetadataGUI
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    Catalog catalog;
    A3eFileManager fileManager;
    GeneralMDPanel generalMDPanel;
    RdfMDPanel rdfMDPanel;

    public A3eMetadataGUI(Catalog c, A3eFileManager fm) {
        this.catalog = c;
        this.fileManager = fm;
        this.generalMDPanel = new GeneralMDPanel();
        this.addTab("\u4e00\u822c\u7684\u306a\u30e1\u30bf\u30c7\u30fc\u30bf", this.generalMDPanel);
        this.rdfMDPanel = new RdfMDPanel();
        this.addTab("RDF\u30e1\u30bf\u30c7\u30fc\u30bf", this.rdfMDPanel);
    }

    void init() {
        this.generalMDPanel.init();
        this.rdfMDPanel.init();
    }

    void clear() {
        this.generalMDPanel.clear();
        this.rdfMDPanel.clear();
        try {
            this.catalog.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class RdfMDPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        RdfMDPanel() {
            this.add(new JLabel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }

        void init() {
        }

        void clear() {
        }
    }

    class GeneralMDPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JTextField profile1TF;
        JTextField profile2TF;
        JTextField profile3TF;
        JTextArea commentTA;
        JTextField tag1TF;
        JTextField tag2TF;
        JTextField tag3TF;
        JTextField tag4TF;
        JTextField tag5TF;
        JTextField tag6TF;
        JComboBox thumbnailCB;
        JComboBox htmlCB;
        JComboBox haltActionCB;
        JComboBox walkActionCB;
        JComboBox runActionCB;
        JTextField minWalkSpeedTF;
        JButton minWalkSpeedB;
        JTextField minRunSpeedTF;
        JButton minRunSpeedB;
        JCheckBox billboardCB;

        GeneralMDPanel() {
            this.setLayout(new BorderLayout());
            MyVBox baseBox = new MyVBox();
            this.add((Component)baseBox, "Center");
            MyVBox profileBox = new MyVBox();
            baseBox.myAdd(profileBox, 0.0);
            MyHBox profileBox1 = new MyHBox();
            profileBox.myAdd(profileBox1, 0.0);
            profileBox1.myAdd(new JLabel("Profile1:"), 0.0);
            this.profile1TF = new JTextField();
            profileBox1.myAdd(this.profile1TF, 1.0);
            MyHBox profileBox2 = new MyHBox();
            profileBox.myAdd(profileBox2, 0.0);
            profileBox2.myAdd(new JLabel("Profile2:"), 0.0);
            this.profile2TF = new JTextField();
            profileBox2.myAdd(this.profile2TF, 1.0);
            MyHBox profileBox3 = new MyHBox();
            profileBox.myAdd(profileBox3, 0.0);
            profileBox3.myAdd(new JLabel("Profile3:"), 0.0);
            this.profile3TF = new JTextField();
            profileBox3.myAdd(this.profile3TF, 1.0);
            MyHBox mainBox = new MyHBox();
            baseBox.myAdd(mainBox, 1.0);
            MyVBox commentBox = new MyVBox();
            mainBox.myAdd(commentBox, 1.0);
            commentBox.myAdd(new JLabel("Comment:"), 0.0);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(400, 400));
            commentBox.myAdd(scrollPane, 1.0);
            this.commentTA = new JTextArea();
            scrollPane.getViewport().setView(this.commentTA);
            MyVBox otherBox = new MyVBox();
            mainBox.myAdd(otherBox, 1.0);
            MyVBox tagBox0 = new MyVBox();
            otherBox.myAdd(tagBox0, 0.0);
            tagBox0.myAdd(new JLabel("Tags:"), 0.0);
            MyHBox tagBox1 = new MyHBox();
            tagBox0.myAdd(tagBox1, 0.0);
            MyHBox tagBox2 = new MyHBox();
            tagBox0.myAdd(tagBox2, 0.0);
            this.tag1TF = new JTextField();
            this.tag2TF = new JTextField();
            this.tag3TF = new JTextField();
            this.tag4TF = new JTextField();
            this.tag5TF = new JTextField();
            this.tag6TF = new JTextField();
            tagBox1.myAdd(this.tag1TF, 1.0);
            tagBox1.myAdd(this.tag2TF, 1.0);
            tagBox1.myAdd(this.tag3TF, 1.0);
            tagBox2.myAdd(this.tag4TF, 1.0);
            tagBox2.myAdd(this.tag5TF, 1.0);
            tagBox2.myAdd(this.tag6TF, 1.0);
            MyHBox thumbnailBox = new MyHBox();
            otherBox.myAdd(thumbnailBox, 0.0);
            thumbnailBox.myAdd(new JLabel("Thumbnail:"), 0.0);
            this.thumbnailCB = new JComboBox();
            this.thumbnailCB.addItem(A3eFile.noneFile);
            thumbnailBox.myAdd(this.thumbnailCB, 1.0);
            MyHBox htmlBox = new MyHBox();
            otherBox.myAdd(htmlBox, 0.0);
            htmlBox.myAdd(new JLabel("htmlfile:"), 0.0);
            this.htmlCB = new JComboBox();
            this.htmlCB.addItem(A3eFile.noneFile);
            htmlBox.myAdd(this.htmlCB, 1.0);
            MyHBox haltActionBox = new MyHBox();
            otherBox.myAdd(haltActionBox, 0.0);
            haltActionBox.myAdd(new JLabel("Halt Action:"), 0.0);
            this.haltActionCB = new JComboBox();
            this.haltActionCB.addItem("[none]");
            haltActionBox.myAdd(this.haltActionCB, 1.0);
            MyHBox walkActionBox = new MyHBox();
            otherBox.myAdd(walkActionBox, 0.0);
            walkActionBox.myAdd(new JLabel("Walk Action:"), 0.0);
            this.walkActionCB = new JComboBox();
            this.walkActionCB.addItem("[none]");
            walkActionBox.myAdd(this.walkActionCB, 1.0);
            MyHBox runActionBox = new MyHBox();
            otherBox.myAdd(runActionBox, 0.0);
            runActionBox.myAdd(new JLabel("Run Action:"), 0.0);
            this.runActionCB = new JComboBox();
            this.runActionCB.addItem("[none]");
            runActionBox.myAdd(this.runActionCB, 1.0);
            MyHBox minWalkSpeedBox = new MyHBox();
            otherBox.myAdd(minWalkSpeedBox, 0.0);
            minWalkSpeedBox.myAdd(new JLabel("MinWalkSpeed:"), 0.0);
            this.minWalkSpeedTF = new JTextField("0.1");
            this.minWalkSpeedTF.setEditable(false);
            minWalkSpeedBox.myAdd(this.minWalkSpeedTF, 1.0);
            this.minWalkSpeedB = new JButton("\u5909\u66f4");
            this.minWalkSpeedB.addActionListener(this);
            minWalkSpeedBox.myAdd(this.minWalkSpeedB, 0.0);
            MyHBox minRunSpeedBox = new MyHBox();
            otherBox.myAdd(minRunSpeedBox, 0.0);
            minRunSpeedBox.myAdd(new JLabel("MinRunSpeed:"), 0.0);
            this.minRunSpeedTF = new JTextField("1.0");
            this.minRunSpeedTF.setEditable(false);
            minRunSpeedBox.myAdd(this.minRunSpeedTF, 1.0);
            this.minRunSpeedB = new JButton("\u5909\u66f4");
            this.minRunSpeedB.addActionListener(this);
            minRunSpeedBox.myAdd(this.minRunSpeedB, 0.0);
            this.billboardCB = new JCheckBox("Billboard");
            otherBox.myAdd(this.billboardCB, 0.0);
            otherBox.myAdd(Box.createVerticalGlue(), 1.0);
        }

        void init() {
            String[] profiles = A3eMetadataGUI.this.catalog.getProfiles();
            if (profiles.length >= 1) {
                this.profile1TF.setText(profiles[0]);
            }
            if (profiles.length >= 2) {
                this.profile2TF.setText(profiles[1]);
            }
            if (profiles.length >= 3) {
                this.profile3TF.setText(profiles[2]);
            }
            this.commentTA.setText(A3eMetadataGUI.this.catalog.a3.getC());
            String[] tags = A3eMetadataGUI.this.catalog.getTags();
            if (tags.length >= 1) {
                this.tag1TF.setText(tags[0]);
            }
            if (tags.length >= 2) {
                this.tag2TF.setText(tags[1]);
            }
            if (tags.length >= 3) {
                this.tag3TF.setText(tags[2]);
            }
            if (tags.length >= 4) {
                this.tag4TF.setText(tags[3]);
            }
            if (tags.length >= 5) {
                this.tag5TF.setText(tags[4]);
            }
            if (tags.length >= 6) {
                this.tag6TF.setText(tags[5]);
            }
            this.thumbnailCB.removeAllItems();
            this.thumbnailCB.addItem(A3eFile.noneFile);
            for (A3eFile f : A3eMetadataGUI.this.fileManager.listA3eFile(A3eFileType.IMAGE)) {
                this.thumbnailCB.addItem(f);
            }
            A3eFile thumbnail = A3eMetadataGUI.this.catalog.getThumbnails()[0];
            this.thumbnailCB.setSelectedItem(thumbnail);
            this.htmlCB.removeAllItems();
            this.htmlCB.addItem(A3eFile.noneFile);
            for (A3eFile f : A3eMetadataGUI.this.fileManager.listA3eFile(A3eFileType.HTML)) {
                this.htmlCB.addItem(f);
            }
            A3eFile html = A3eMetadataGUI.this.catalog.getHtml();
            this.htmlCB.setSelectedItem(html);
            this.haltActionCB.removeAllItems();
            this.walkActionCB.removeAllItems();
            this.runActionCB.removeAllItems();
            this.haltActionCB.addItem("[none]");
            this.walkActionCB.addItem("[none]");
            this.runActionCB.addItem("[none]");
            for (String an : A3eMetadataGUI.this.catalog.getActionNames()) {
                this.haltActionCB.addItem(an);
                this.walkActionCB.addItem(an);
                this.runActionCB.addItem(an);
            }
            this.haltActionCB.setSelectedItem(A3eMetadataGUI.this.catalog.getHaltActionName());
            this.walkActionCB.setSelectedItem(A3eMetadataGUI.this.catalog.getWalkActionName());
            this.runActionCB.setSelectedItem(A3eMetadataGUI.this.catalog.getRunActionName());
            this.minWalkSpeedTF.setText("" + A3eMetadataGUI.this.catalog.getMinWalkSpeed());
            this.minRunSpeedTF.setText("" + A3eMetadataGUI.this.catalog.getMinRunSpeed());
            this.billboardCB.setSelected(A3eMetadataGUI.this.catalog.isBillboard());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.minWalkSpeedB) {
                try {
                    String input = JOptionPane.showInputDialog(this, "Input MinWalkSpeed(m/s).", this.minWalkSpeedTF.getText());
                    double d = Double.parseDouble(input);
                    this.minWalkSpeedTF.setText("" + d);
                }
                catch (NumberFormatException ee) {}
            } else if (e.getSource() == this.minRunSpeedB) {
                try {
                    String input = JOptionPane.showInputDialog(this, "Input MinRunSpeed(m/s).", this.minRunSpeedTF.getText());
                    double d = Double.parseDouble(input);
                    this.minRunSpeedTF.setText("" + d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void clear() {
            ArrayList<String> al = new ArrayList<String>();
            if (!this.profile1TF.getText().trim().equals("")) {
                al.add(this.profile1TF.getText().trim());
            }
            if (!this.profile2TF.getText().trim().equals("")) {
                al.add(this.profile2TF.getText().trim());
            }
            if (!this.profile3TF.getText().trim().equals("")) {
                al.add(this.profile3TF.getText().trim());
            }
            A3eMetadataGUI.this.catalog.setProfiles(al.toArray(new String[0]));
            A3eMetadataGUI.this.catalog.setComment(this.commentTA.getText());
            al.clear();
            if (!this.tag1TF.getText().trim().equals("")) {
                al.add(this.tag1TF.getText().trim());
            }
            if (!this.tag2TF.getText().trim().equals("")) {
                al.add(this.tag2TF.getText().trim());
            }
            if (!this.tag3TF.getText().trim().equals("")) {
                al.add(this.tag3TF.getText().trim());
            }
            if (!this.tag4TF.getText().trim().equals("")) {
                al.add(this.tag4TF.getText().trim());
            }
            if (!this.tag5TF.getText().trim().equals("")) {
                al.add(this.tag5TF.getText().trim());
            }
            if (!this.tag6TF.getText().trim().equals("")) {
                al.add(this.tag6TF.getText().trim());
            }
            A3eMetadataGUI.this.catalog.setTags(al.toArray(new String[0]));
            A3eMetadataGUI.this.catalog.setThumbnail((A3eFile)this.thumbnailCB.getSelectedItem());
            A3eMetadataGUI.this.catalog.setHtmlfile((A3eFile)this.htmlCB.getSelectedItem());
            A3eMetadataGUI.this.catalog.setHaltAction((String)this.haltActionCB.getSelectedItem());
            A3eMetadataGUI.this.catalog.setWalkAction((String)this.haltActionCB.getSelectedItem());
            A3eMetadataGUI.this.catalog.setRunAction((String)this.haltActionCB.getSelectedItem());
            double d = Double.parseDouble(this.minWalkSpeedTF.getText());
            A3eMetadataGUI.this.catalog.setMinWalkSpeed(d);
            d = Double.parseDouble(this.minRunSpeedTF.getText());
            A3eMetadataGUI.this.catalog.setMinRunSpeed(d);
            A3eMetadataGUI.this.catalog.setBillboard(this.billboardCB.isSelected());
        }
    }
}

