/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3editor.A3EditorGUI;
import jp.sourceforge.acerola3d.a3editor.A3eActionEditor;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;
import jp.sourceforge.acerola3d.a3editor.Catalog;
import jp.sourceforge.acerola3d.sound.A3SoundSystem;

public class A3Editor {
    static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    static A3SoundSystem soundSystem;
    A3EditorGUI gui;
    A3eFileManager fileManager = null;
    Catalog catalog = null;
    A3eActionEditor actionEditor = null;

    public A3Editor(String[] args) {
        A23.initA23();
        File f = null;
        if (args.length == 0) {
            JOptionPane.showMessageDialog(null, "\u4f5c\u696d\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002");
            JFileChooser fc = new JFileChooser(".");
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
        } else if (args.length == 1) {
            f = new File(args[0]);
        } else if (args.length == 2 && args[0].equals("-open")) {
            f = new File(args[1]);
        }
        this.setWorkingDir(f);
        this.gui = new A3EditorGUI(this);
        soundSystem = A3SoundSystem.getDefaultSoundSystem();
    }

    public static void main(String[] args) {
        new A3Editor(args);
    }

    public void setWorkingDir(File f) {
        try {
            this.fileManager = new A3eFileManager(f);
        }
        catch (IOException e) {
            this.fileManager = null;
            e.printStackTrace();
            int ret = JOptionPane.showConfirmDialog(this.gui, "\u4f5c\u696d\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u3082\u3046\u4e00\u5ea6\u9078\u629e\u3057\u307e\u3059\u304b?");
            if (ret == 1) {
                return;
            }
            JFileChooser fc = new JFileChooser(".");
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
            this.setWorkingDir(f);
            return;
        }
        A3eFile file = null;
        try {
            file = this.fileManager.listA3eFile(A3eFileType.CATALOG)[0];
            this.catalog = new Catalog(file.toFile(), this.fileManager);
            this.catalogBackup();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.gui, "CATALOG.XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u3066\u65b0\u898f\u4f5c\u6210\u3057\u307e\u3059\u3002", "ERROR", 0);
            try {
                this.catalogBackup();
                this.catalog = new Catalog(this.fileManager);
                this.catalog.file = file.toFile();
                this.catalog.save();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.actionEditor = new A3eActionEditor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void catalogBackup() throws IOException {
        A3eFile orgA3eFile = this.fileManager.listA3eFile(A3eFileType.CATALOG)[0];
        File orgFile = orgA3eFile.toFile();
        File bakFile = new File(orgFile.getParentFile(), orgFile.getName() + ".bak");
        FileInputStream fis = new FileInputStream(orgFile);
        FileOutputStream fos = new FileOutputStream(bakFile);
        FileChannel orgChannel = fis.getChannel();
        FileChannel bakChannel = fos.getChannel();
        try {
            orgChannel.transferTo(0L, orgChannel.size(), bakChannel);
        }
        finally {
            orgChannel.close();
            bakChannel.close();
        }
    }
}

