/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.j3dvrml;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.acerola3d.j3dvrml.J3DVrml;

public class VrmlTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private FileNameExtensionFilter filter = new FileNameExtensionFilter("", "wrl");
    private J3DVrml j3dvrml;

    public VrmlTransferHandler(J3DVrml j3dvrml) {
        this.j3dvrml = j3dvrml;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        support.setShowDropLocation(true);
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            Object obj = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            File file = (File)((List)obj).get(0);
            if (file != null && this.filter.accept(file)) {
                this.j3dvrml.loadVRML(file);
            }
            return true;
        }
        catch (UnsupportedFlavorException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

