/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.j3dvrml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.VRML;
import jp.sourceforge.acerola3d.j3dvrml.A3PHtmlViewer;
import jp.sourceforge.acerola3d.j3dvrml.JTextAreaOutputStream;
import jp.sourceforge.acerola3d.j3dvrml.MyExamController;
import jp.sourceforge.acerola3d.j3dvrml.MyHBox;
import jp.sourceforge.acerola3d.j3dvrml.MyVBox;
import jp.sourceforge.acerola3d.j3dvrml.VrmlTransferHandler;

public class J3DVrml
implements ActionListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    JMenuItem backgroundMenuItem;
    JMenuItem helpMenuItem;
    JMenuItem aboutMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    A3PHtmlViewer htmlViewer;
    A3PHtmlViewer helpViewer;
    Action3D measure;
    VRML vrml;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public J3DVrml(String[] args) {
        this.frame = new JFrame("J3DVrml");
        this.frame.getContentPane().setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.frame.getContentPane().add((Component)baseBox, "Center");
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.configMenu.add(this.snapshotMenuItem);
        this.measureMenu = new JMenu("measure");
        this.configMenu.add(this.measureMenu);
        this.measureXZMenuItem = new JMenuItem("measure XZ");
        this.measureXZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXZMenuItem);
        this.measureXYMenuItem = new JMenuItem("measure XY");
        this.measureXYMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXYMenuItem);
        this.measureYZMenuItem = new JMenuItem("measure YZ");
        this.measureYZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureYZMenuItem);
        this.measureNoneMenuItem = new JMenuItem("measure None");
        this.measureNoneMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureNoneMenuItem);
        this.backgroundMenuItem = new JMenuItem("Background");
        this.backgroundMenuItem.addActionListener(this);
        this.configMenu.add(this.backgroundMenuItem);
        this.helpMenuItem = new JMenuItem("help");
        this.helpMenuItem.addActionListener(this);
        this.configMenu.add(this.helpMenuItem);
        this.aboutMenuItem = new JMenuItem("about");
        this.aboutMenuItem.addActionListener(this);
        this.configMenu.add(this.aboutMenuItem);
        this.consoleFrame = new JFrame("Console");
        this.consoleFrame.getContentPane().setLayout(new BorderLayout());
        MyVBox b = new MyVBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.myAdd(sp, 1.0);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.myAdd(this.clearConsoleButton, 0.0);
        this.consoleFrame.getContentPane().add((Component)b, "Center");
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                J3DVrml.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        MyHBox addressBox = new MyHBox();
        baseBox.myAdd(addressBox, 0.0);
        addressBox.myAdd(new JLabel("URL:"), 0.0);
        this.urlTextField = new JTextField();
        try {
            File f = null;
            f = args != null && args.length == 2 && args[0].equals("-open") ? new File(args[1]) : new File(args[0]);
            this.urlTextField.setText(f.toURI().toString());
        }
        catch (Exception e) {
            this.urlTextField.setText("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/Acerola3D.wrl");
        }
        this.urlTextField.addActionListener(this);
        this.urlTextField.setMaximumSize(new Dimension(3000, 30));
        addressBox.myAdd(this.urlTextField, 1.0);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        addressBox.myAdd(this.refButton, 0.0);
        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        try {
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/measure.a3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frame.setTransferHandler(new VrmlTransferHandler(this));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                J3DVrml.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.setSize(700, 500);
        this.frame.setVisible(true);
        this.htmlViewer = new A3PHtmlViewer(this.frame);
        this.helpViewer = new A3PHtmlViewer(null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DVrml.this.loadVRML();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(Box.createVerticalGlue(), 1.0);
        String buildDate = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildDate.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildDate = br.readLine();
        }
        catch (Exception e) {
            buildDate = "???";
        }
        controlBox.myAdd(new JLabel("build date:"), 0.0);
        controlBox.myAdd(new JLabel("   " + buildDate), 0.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.urlTextField) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    J3DVrml.this.loadVRML();
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        } else if (ae.getSource() == this.resetViewButton) {
            this.controller.reset((A3Object)this.vrml);
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.controller.reset((A3Object)this.vrml);
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a3canvas.saveImage(f);
            }
            catch (Exception e) {
                System.out.println("A3Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.measureXZMenuItem) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureXYMenuItem) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureYZMenuItem) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureNoneMenuItem) {
            this.a3canvas.del((A3Object)this.measure);
        } else if (ae.getSource() == this.backgroundMenuItem) {
            this.setBackground();
        } else if (ae.getSource() == this.helpMenuItem) {
            this.openHelp();
        } else if (ae.getSource() == this.aboutMenuItem) {
            this.openAbout();
        } else {
            System.out.append("gaha???");
        }
    }

    void loadVRML() {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.vrml != null) {
            this.a3canvas.del((A3Object)this.vrml);
        }
        String urlString = this.urlTextField.getText();
        try {
            A23.initA23();
            this.vrml = VRML.load((String)urlString);
            this.controller.reset((A3Object)this.vrml);
        }
        catch (Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        this.a3canvas.add((A3Object)this.vrml);
        this.vrml.setLocImmediately(0.0, 0.0, 0.0);
        this.vrml.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.vrml.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DVrml.this.controller.reset((A3Object)J3DVrml.this.vrml);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    void loadVRML(File f) throws Exception {
        this.urlTextField.setText(f.toURI().toURL().toString());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DVrml.this.loadVRML();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DVrml.this.loadVRML();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    void setBackground() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
    }

    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/ja/help.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.helpViewer.open(url);
    }

    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/ja/about.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.htmlViewer.open(url);
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        final String[] argsCopy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new J3DVrml(argsCopy);
            }
        });
    }
}

