package jp.sourceforge.acerola3d.a3panels;

import jp.sourceforge.acerola3d.*;
import jp.sourceforge.acerola3d.a3.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import javax.swing.*;

public class VrmlPanel extends JPanel implements ActionListener {
    private static final long serialVersionUID = 1L;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JLabel statusBarLabel;
    Action3D measure;

    VRML vrml;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public VrmlPanel(final String urlString) {
        this.setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.add(baseBox,BorderLayout.CENTER);

        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox,1.0);
        a3canvas = A3Canvas.createA3Canvas(300,300);
        a3canvas.setPreferredSize(new Dimension(300,300));
        controller = new MyExamController();
        a3canvas.setA3Controller(controller);
        mainBox.myAdd(a3canvas,1.0);

        MyVBox controlBox = makeControlBox();
        mainBox.myAdd(controlBox,0.0);

        statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(statusBarLabel,0.0);

        try {
            Action3D.clearCash("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
            measure = new Action3D("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (urlString!=null) {
            Runnable r = new Runnable() {
                public void run() {
                    loadVRML(urlString);
                }
            };
            executor.schedule(r,100,TimeUnit.MILLISECONDS);
        }
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();

        menuBar = new JMenuBar();
        controlBox.myAdd(menuBar,0.0);
        menuBar.add(Box.createHorizontalGlue());
        configMenu = new JMenu("Config");
        menuBar.add(configMenu);
        consoleMenuItem = new JMenuItem("Console");
        consoleMenuItem.addActionListener(this);
        configMenu.add(consoleMenuItem);
        resetViewMenuItem = new JMenuItem("ResetView");
        resetViewMenuItem.addActionListener(this);
        configMenu.add(resetViewMenuItem);
        measureMenu = new JMenu("measure");
        configMenu.add(measureMenu);
        measureXZMenuItem = new JMenuItem("measure XZ");
        measureXZMenuItem.addActionListener(this);
        measureMenu.add(measureXZMenuItem);
        measureXYMenuItem = new JMenuItem("measure XY");
        measureXYMenuItem.addActionListener(this);
        measureMenu.add(measureXYMenuItem);
        measureYZMenuItem = new JMenuItem("measure YZ");
        measureYZMenuItem.addActionListener(this);
        measureMenu.add(measureYZMenuItem);
        measureNoneMenuItem = new JMenuItem("measure None");
        measureNoneMenuItem.addActionListener(this);
        measureMenu.add(measureNoneMenuItem);

        resetViewButton = new JButton("Reset View");
        resetViewButton.addActionListener(this);
        controlBox.myAdd(resetViewButton,0.0);

        controlBox.myAdd(new JLabel("Left drag: rotation"),0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"),0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"),0.0);

        controlBox.myAdd(Box.createVerticalGlue(),1.0);

        return controlBox;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == resetViewButton) {
        	controller.adjust(vrml);
        } else if (ae.getSource() == resetViewMenuItem) {
        	controller.adjust(vrml);
        } else if (ae.getSource() == measureXZMenuItem) {
            measure.setRot(-Math.PI/2.0,0.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureXYMenuItem) {
            measure.setRot(0.0,0.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureYZMenuItem) {
            measure.setRot(0.0,Math.PI/2.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureNoneMenuItem) {
            a3canvas.del(measure);
        } else {
            System.out.append("gaha???");
        }
    }

    void loadVRML(String urlString) {
        statusBarLabel.setText("Status: Loading ... ");
        statusBarLabel.repaint();
        if (vrml!=null)
            a3canvas.del(vrml);
        try {
            A23.initA23();
            VRML.clearCash(urlString);
            vrml = VRML.load(urlString);
            controller.adjust(vrml);
        } catch(Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        a3canvas.add(vrml);

        vrml.setLocImmediately(0.0,0.0,0.0);
        vrml.setQuatImmediately(0.0,0.0,0.0,1.0);
        vrml.setScaleImmediately(1.0);

        Runnable r = new Runnable() {
            public void run() {
                controller.adjust(vrml);
            }
        };
        executor.schedule(r,100,TimeUnit.MILLISECONDS);

        statusBarLabel.setText("Status: Loading ... done.");
    }
    public void loadVRML(File f) {
        try {
            final String urlString = f.toURI().toURL().toString();
            Runnable r = new Runnable() {
                public void run() {
                    loadVRML(urlString);
                }
            };
            executor.schedule(r,100,TimeUnit.MILLISECONDS);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    void setBackground(String bgUrlString) {
        URL url = null;
        try{url=new URL(bgUrlString);}catch(Exception e){;}
        if (url == null)
            return;
        Action3D a = null;
        try{
            a = Action3D.load(url);
        } catch(Exception e) {
            e.printStackTrace();
        }
        if (a!=null)
            a3canvas.setBackground(a);
    }
}
