package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.*;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

public class A3eMetadataGUI extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    Catalog catalog;
    A3eFileManager fileManager;
    GeneralMDPanel generalMDPanel;
    RdfMDPanel rdfMDPanel;
    public A3eMetadataGUI(Catalog c,A3eFileManager fm) {
        catalog = c;
        fileManager = fm;
        generalMDPanel = new GeneralMDPanel();
        addTab("一般的なメタデータ",generalMDPanel);

        rdfMDPanel = new RdfMDPanel();
        addTab("RDFメタデータ",rdfMDPanel);
    }
    void init() {
        generalMDPanel.init();
        rdfMDPanel.init();
    }
    class GeneralMDPanel extends JPanel implements ActionListener {
        private static final long serialVersionUID = 1L;
        JTextField profile1TF;
        JTextField profile2TF;
        JTextField profile3TF;
        JTextArea commentTA;
        JTextField tag1TF;
        JTextField tag2TF;
        JTextField tag3TF;
        JTextField tag4TF;
        JTextField tag5TF;
        JTextField tag6TF;
        JComboBox thumbnailCB;
        JComboBox htmlCB;
        JComboBox haltActionCB;
        JComboBox walkActionCB;
        JComboBox runActionCB;
        JTextField minWalkSpeedTF;
        JButton minWalkSpeedB;
        JTextField minRunSpeedTF;
        JButton minRunSpeedB;
        JCheckBox billboardCB;
        GeneralMDPanel() {
            setLayout(new BorderLayout());
            MyVBox baseBox = new MyVBox();
            add(baseBox,BorderLayout.CENTER);
            MyVBox profileBox = new MyVBox();
            baseBox.myAdd(profileBox,0);
            MyHBox profileBox1 = new MyHBox();
            profileBox.myAdd(profileBox1,0);
            profileBox1.myAdd(new JLabel("Profile1:"),0);
            profile1TF = new JTextField();
            profileBox1.myAdd(profile1TF,1);
            MyHBox profileBox2 = new MyHBox();
            profileBox.myAdd(profileBox2,0);
            profileBox2.myAdd(new JLabel("Profile2:"),0);
            profile2TF = new JTextField();
            profileBox2.myAdd(profile2TF,1);
            MyHBox profileBox3 = new MyHBox();
            profileBox.myAdd(profileBox3,0);
            profileBox3.myAdd(new JLabel("Profile3:"),0);
            profile3TF = new JTextField();
            profileBox3.myAdd(profile3TF,1);
            MyHBox mainBox = new MyHBox();
            baseBox.myAdd(mainBox,1);
            MyVBox commentBox = new MyVBox();
            mainBox.myAdd(commentBox,1);
            commentBox.myAdd(new JLabel("Comment:"),0);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(400,400));
            commentBox.myAdd(scrollPane,1);
            commentTA = new JTextArea();
            scrollPane.getViewport().setView(commentTA);
            MyVBox otherBox = new MyVBox();
            mainBox.myAdd(otherBox,1);
            MyVBox tagBox0 = new MyVBox();
            otherBox.myAdd(tagBox0,0);
            tagBox0.myAdd(new JLabel("Tags:"),0);
            MyHBox tagBox1 = new MyHBox();
            tagBox0.myAdd(tagBox1,0);
            MyHBox tagBox2 = new MyHBox();
            tagBox0.myAdd(tagBox2,0);
            tag1TF = new JTextField();
            tag2TF = new JTextField();
            tag3TF = new JTextField();
            tag4TF = new JTextField();
            tag5TF = new JTextField();
            tag6TF = new JTextField();
            tagBox1.myAdd(tag1TF,1);
            tagBox1.myAdd(tag2TF,1);
            tagBox1.myAdd(tag3TF,1);
            tagBox2.myAdd(tag4TF,1);
            tagBox2.myAdd(tag5TF,1);
            tagBox2.myAdd(tag6TF,1);
            MyHBox thumbnailBox = new MyHBox();
            otherBox.myAdd(thumbnailBox,0);
            thumbnailBox.myAdd(new JLabel("Thumbnail:"),0);
            thumbnailCB = new JComboBox();
            thumbnailCB.addItem(A3eFile.noneFile);
            thumbnailBox.myAdd(thumbnailCB,1);
            MyHBox htmlBox = new MyHBox();
            otherBox.myAdd(htmlBox,0);
            htmlBox.myAdd(new JLabel("htmlfile:"),0);
            htmlCB = new JComboBox();
            htmlCB.addItem(A3eFile.noneFile);
            htmlBox.myAdd(htmlCB,1);
            MyHBox haltActionBox = new MyHBox();
            otherBox.myAdd(haltActionBox,0);
            haltActionBox.myAdd(new JLabel("Halt Action:"),0);
            haltActionCB = new JComboBox();
            haltActionCB.addItem("[none]");
            haltActionBox.myAdd(haltActionCB,1);
            MyHBox walkActionBox = new MyHBox();
            otherBox.myAdd(walkActionBox,0);
            walkActionBox.myAdd(new JLabel("Walk Action:"),0);
            walkActionCB = new JComboBox();
            walkActionCB.addItem("[none]");
            walkActionBox.myAdd(walkActionCB,1);
            MyHBox runActionBox = new MyHBox();
            otherBox.myAdd(runActionBox,0);
            runActionBox.myAdd(new JLabel("Run Action:"),0);
            runActionCB = new JComboBox();
            runActionCB.addItem("[none]");
            runActionBox.myAdd(runActionCB,1);
            MyHBox minWalkSpeedBox = new MyHBox();
            otherBox.myAdd(minWalkSpeedBox,0);
            minWalkSpeedBox.myAdd(new JLabel("MinWalkSpeed:"),0);
            minWalkSpeedTF = new JTextField("0.1");
            minWalkSpeedTF.setEditable(false);
            minWalkSpeedBox.myAdd(minWalkSpeedTF,1);
            minWalkSpeedB = new JButton("変更");
            minWalkSpeedB.addActionListener(this);
            minWalkSpeedBox.myAdd(minWalkSpeedB,0);
            MyHBox minRunSpeedBox = new MyHBox();
            otherBox.myAdd(minRunSpeedBox,0);
            minRunSpeedBox.myAdd(new JLabel("MinRunSpeed:"),0);
            minRunSpeedTF = new JTextField("1.0");
            minRunSpeedTF.setEditable(false);
            minRunSpeedBox.myAdd(minRunSpeedTF,1);
            minRunSpeedB = new JButton("変更");
            minRunSpeedB.addActionListener(this);
            minRunSpeedBox.myAdd(minRunSpeedB,0);
            billboardCB = new JCheckBox("Billboard");
            otherBox.myAdd(billboardCB,0);

            otherBox.myAdd(Box.createVerticalGlue(),1);
        }
        void init() {
            String profiles[] = catalog.getProfiles();
            if (profiles.length>=1) profile1TF.setText(profiles[0]);
            if (profiles.length>=2) profile2TF.setText(profiles[1]);
            if (profiles.length>=3) profile3TF.setText(profiles[2]);
            commentTA.setText(catalog.a3.getC());
            String tags[] = catalog.getTags();
            if (tags.length>=1) tag1TF.setText(tags[0]);
            if (tags.length>=2) tag2TF.setText(tags[1]);
            if (tags.length>=3) tag3TF.setText(tags[2]);
            if (tags.length>=4) tag4TF.setText(tags[3]);
            if (tags.length>=5) tag5TF.setText(tags[4]);
            if (tags.length>=6) tag6TF.setText(tags[5]);
            thumbnailCB.removeAllItems();
            thumbnailCB.addItem(A3eFile.noneFile);
            for (A3eFile f:fileManager.listA3eFile(A3eFileType.IMAGE)) {
                thumbnailCB.addItem(f);
            }
            A3eFile thumbnail = catalog.getThumbnails()[0];
            thumbnailCB.setSelectedItem(thumbnail);
            htmlCB.removeAllItems();
            htmlCB.addItem(A3eFile.noneFile);
            for (A3eFile f:fileManager.listA3eFile(A3eFileType.HTML)) {
                htmlCB.addItem(f);
            }
            A3eFile html = catalog.getHtml();
            htmlCB.setSelectedItem(html);
            haltActionCB.removeAllItems();
            walkActionCB.removeAllItems();
            runActionCB.removeAllItems();
            haltActionCB.addItem("[none]");
            walkActionCB.addItem("[none]");
            runActionCB.addItem("[none]");
            for (String an:catalog.getActionNames()) {
                haltActionCB.addItem(an);
                walkActionCB.addItem(an);
                runActionCB.addItem(an);
            }
            haltActionCB.setSelectedItem(catalog.getHaltActionName());
            walkActionCB.setSelectedItem(catalog.getWalkActionName());
            runActionCB.setSelectedItem(catalog.getRunActionName());
            minWalkSpeedTF.setText(""+catalog.getMinWalkSpeed());
            minRunSpeedTF.setText(""+catalog.getMinRunSpeed());
            billboardCB.setSelected(catalog.isBillboard());
        }
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource()==minWalkSpeedB) {
                try {
                    String input = JOptionPane.showInputDialog(this,"Input MinWalkSpeed(m/s).",minWalkSpeedTF.getText());
                    double d = Double.parseDouble(input);
                    minWalkSpeedTF.setText(""+d);
                } catch (NumberFormatException ee) {
                    ;
                }
            } else if (e.getSource()==minRunSpeedB) {
                try {
                    String input = JOptionPane.showInputDialog(this,"Input MinRunSpeed(m/s).",minRunSpeedTF.getText());
                    double d = Double.parseDouble(input);
                    minRunSpeedTF.setText(""+d);
                } catch (NumberFormatException ee) {
                    ;
                }
            }
        }
        void clear() {
            ArrayList<String> al = new ArrayList<String>();
            if (!profile1TF.getText().trim().equals(""))
                al.add(profile1TF.getText().trim());
            if (!profile2TF.getText().trim().equals(""))
                al.add(profile2TF.getText().trim());
            if (!profile3TF.getText().trim().equals(""))
                al.add(profile3TF.getText().trim());
            catalog.setProfiles(al.toArray(new String[0]));
            catalog.setComment(commentTA.getText());
            al.clear();
            if (!tag1TF.getText().trim().equals(""))
                al.add(tag1TF.getText().trim());
            if (!tag2TF.getText().trim().equals(""))
                al.add(tag2TF.getText().trim());
            if (!tag3TF.getText().trim().equals(""))
                al.add(tag3TF.getText().trim());
            if (!tag4TF.getText().trim().equals(""))
                al.add(tag4TF.getText().trim());
            if (!tag5TF.getText().trim().equals(""))
                al.add(tag5TF.getText().trim());
            if (!tag6TF.getText().trim().equals(""))
                al.add(tag6TF.getText().trim());
            catalog.setTags(al.toArray(new String[0]));
            catalog.setThumbnail((A3eFile)thumbnailCB.getSelectedItem());
            catalog.setHtmlfile((A3eFile)htmlCB.getSelectedItem());
            catalog.setHaltAction((String)haltActionCB.getSelectedItem());
            catalog.setWalkAction((String)haltActionCB.getSelectedItem());
            catalog.setRunAction((String)haltActionCB.getSelectedItem());
            double d = Double.parseDouble(minWalkSpeedTF.getText());
            catalog.setMinWalkSpeed(d);
            d = Double.parseDouble(minRunSpeedTF.getText());
            catalog.setMinRunSpeed(d);
            catalog.setBillboard(billboardCB.isSelected());
        }
    }
    class RdfMDPanel extends JPanel {
        private static final long serialVersionUID = 1L;
        RdfMDPanel() {
            add(new JLabel("まだ実装されていません。"));
        }
        void init() {
            ;
        }
        void clear() {
            ;
        }
    }
    void clear() {
        generalMDPanel.clear();
        rdfMDPanel.clear();
        try {
            catalog.save();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        //TODO
    }
}
