/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3panels.HtmlPanel;
import jp.sourceforge.acerola3d.a3panels.MyExamController;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

public class A3Panel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem headLightMenuItem;
    JMenu balloonMenu;
    JMenuItem balloonRightMenuItem;
    JMenuItem balloonLeftMenuItem;
    JMenuItem balloonTopMenuItem;
    JMenuItem balloonBottomMenuItem;
    JMenuItem balloonDelMenuItem;
    JMenu labelMenu;
    JMenuItem labelMenuItem;
    JMenuItem labelDelMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    JMenuItem htmlMenuItem;
    JMenuItem metadataMenuItem;
    A3Canvas a3canvas;
    JComboBox actionNameCB;
    JCheckBox immediatelyCheckBox;
    JButton resetViewButton;
    JTextArea commentTextArea;
    JSlider volumeSlider;
    JLabel statusBarLabel;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength = 100;
    double motionLength;
    boolean headLight = true;
    HtmlPanel htmlViewer;
    Action3D measure;
    Action3D a3;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public A3Panel(final String urlString) {
        this.setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        this.add((Component)baseBox, "Center");
        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.a3canvas.setPreferredSize(new Dimension(300, 300));
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        MyHBox pauseBox = new MyHBox();
        baseBox.myAdd(pauseBox, 0.0);
        this.pauseCheckBox = new JCheckBox("pause");
        this.pauseCheckBox.setSelected(false);
        this.pauseCheckBox.addActionListener(this);
        pauseBox.myAdd(this.pauseCheckBox, 0.0);
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.sliderLength);
        this.slider.addChangeListener(this);
        pauseBox.myAdd(this.slider, 1.0);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        this.htmlViewer = new HtmlPanel(null);
        try {
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (urlString != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    A3Panel.this.loadAction3D(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();
        this.menuBar = new JMenuBar();
        controlBox.myAdd(this.menuBar, 0.0);
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.headLightMenuItem = new JMenuItem("HeadLight");
        this.headLightMenuItem.addActionListener(this);
        this.configMenu.add(this.headLightMenuItem);
        this.balloonMenu = new JMenu("Balloon");
        this.configMenu.add(this.balloonMenu);
        this.balloonRightMenuItem = new JMenuItem("Balloon on (right)");
        this.balloonRightMenuItem.addActionListener(this);
        this.balloonMenu.add(this.balloonRightMenuItem);
        this.balloonLeftMenuItem = new JMenuItem("Balloon on (left)");
        this.balloonLeftMenuItem.addActionListener(this);
        this.balloonMenu.add(this.balloonLeftMenuItem);
        this.balloonTopMenuItem = new JMenuItem("Balloon on (top)");
        this.balloonTopMenuItem.addActionListener(this);
        this.balloonMenu.add(this.balloonTopMenuItem);
        this.balloonBottomMenuItem = new JMenuItem("Balloon on (bottom)");
        this.balloonBottomMenuItem.addActionListener(this);
        this.balloonMenu.add(this.balloonBottomMenuItem);
        this.balloonDelMenuItem = new JMenuItem("Balloon off");
        this.balloonDelMenuItem.addActionListener(this);
        this.balloonMenu.add(this.balloonDelMenuItem);
        this.labelMenu = new JMenu("Label");
        this.configMenu.add(this.labelMenu);
        this.labelMenuItem = new JMenuItem("Label on");
        this.labelMenuItem.addActionListener(this);
        this.labelMenu.add(this.labelMenuItem);
        this.labelDelMenuItem = new JMenuItem("Label off");
        this.labelDelMenuItem.addActionListener(this);
        this.labelMenu.add(this.labelDelMenuItem);
        this.measureMenu = new JMenu("measure");
        this.configMenu.add(this.measureMenu);
        this.measureXZMenuItem = new JMenuItem("measure XZ");
        this.measureXZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXZMenuItem);
        this.measureXYMenuItem = new JMenuItem("measure XY");
        this.measureXYMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureXYMenuItem);
        this.measureYZMenuItem = new JMenuItem("measure YZ");
        this.measureYZMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureYZMenuItem);
        this.measureNoneMenuItem = new JMenuItem("measure None");
        this.measureNoneMenuItem.addActionListener(this);
        this.measureMenu.add(this.measureNoneMenuItem);
        this.htmlMenuItem = new JMenuItem("Html");
        this.htmlMenuItem.addActionListener(this);
        this.configMenu.add(this.htmlMenuItem);
        this.metadataMenuItem = new JMenuItem("Metadata");
        this.metadataMenuItem.addActionListener(this);
        this.configMenu.add(this.metadataMenuItem);
        MyHBox actionBox = new MyHBox();
        controlBox.myAdd(actionBox, 0.0);
        actionBox.myAdd(new JLabel("ActionName:"), 0.0);
        this.actionNameCB = new JComboBox();
        this.actionNameCB.addActionListener(this);
        actionBox.myAdd(this.actionNameCB, 1.0);
        this.immediatelyCheckBox = new JCheckBox("immediatelyChange");
        this.immediatelyCheckBox.setSelected(true);
        controlBox.myAdd(this.immediatelyCheckBox, 0.0);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(new JLabel("***Comment***"), 0.0);
        this.commentTextArea = new JTextArea(10, 30);
        this.commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.commentTextArea);
        sp.setPreferredSize(new Dimension(50, 150));
        controlBox.myAdd(sp, 1.0);
        MyHBox volBox = new MyHBox();
        controlBox.myAdd(volBox, 0.0);
        volBox.myAdd(new JLabel("SoundVol"), 0.0);
        this.volumeSlider = new JSlider();
        this.volumeSlider.setMinimum(0);
        this.volumeSlider.setMaximum(this.sliderLength);
        this.volumeSlider.addChangeListener(this);
        volBox.myAdd(this.volumeSlider, 1.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.actionNameCB) {
            this.actionName = (String)this.actionNameCB.getSelectedItem();
            if (this.actionName == null) {
                System.out.println("gaha1");
                return;
            }
            System.out.println("actionName:" + this.actionName);
            this.repaint();
        } else if (ae.getSource() == this.resetViewButton) {
            this.controller.adjust((A3Object)this.a3);
        } else if (ae.getSource() == this.headLightMenuItem) {
            this.headLight = !this.headLight;
            this.a3canvas.setHeadLightEnable(this.headLight);
        } else if (ae.getSource() == this.balloonRightMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.RIGHT);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonLeftMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.LEFT);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonTopMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.TOP);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonBottomMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.BOTTOM);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonDelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloon(null);
        } else if (ae.getSource() == this.labelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setLabel("\u30e9\u30d9\u30eb");
        } else if (ae.getSource() == this.labelDelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setLabel(null);
        } else if (ae.getSource() == this.measureXZMenuItem) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureXYMenuItem) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureYZMenuItem) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.a3canvas.add((A3Object)this.measure);
        } else if (ae.getSource() == this.measureNoneMenuItem) {
            this.a3canvas.del((A3Object)this.measure);
        } else if (ae.getSource() == this.htmlMenuItem) {
            this.openHtml();
        } else if (ae.getSource() == this.metadataMenuItem) {
            this.openMetadata();
        } else if (ae.getSource() == this.pauseCheckBox) {
            if (this.a3 == null) {
                return;
            }
            if (this.pauseCheckBox.isSelected()) {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PAUSE);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            } else {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PLAY);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            }
        } else {
            System.out.append("gaha???");
        }
    }

    void openHtml() {
        if (this.a3 == null) {
            return;
        }
        URL url = this.a3.getHTML();
        if (url == null) {
            JOptionPane.showMessageDialog(this, "No html file.", "ERROR", 0);
            return;
        }
        this.htmlViewer.open(url);
    }

    void openMetadata() {
        if (this.a3 == null) {
            return;
        }
        String s = "";
        s = String.valueOf(s) + "<html><body><h1>Not implemented yet!</h1><p><a href=\"http://www.google.co.jp/\">test</a></p>";
        s = String.valueOf(s) + "<pre>" + this.a3.getComment() + "</pre>";
        s = String.valueOf(s) + "</body></html>";
        this.htmlViewer.open(s);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.volumeSlider) {
            double g = 2.0 * ((double)this.volumeSlider.getValue() / (double)this.sliderLength);
            this.a3canvas.setSoundGain(g);
        } else if (ce.getSource() == this.slider) {
            if (this.a3 == null) {
                return;
            }
            double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
            this.a3.setPauseTime(t);
        }
    }

    public void loadAction3D(String urlString) {
        Action3D.clearCash();
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.a3 != null) {
            this.a3canvas.del((A3Object)this.a3);
        }
        try {
            A23.initA23();
            this.a3 = Action3D.load((String)urlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.actionNameCB.removeAllItems();
        String[] sss = this.a3.getActionNames();
        int i = 0;
        while (i < sss.length) {
            this.actionNameCB.addItem(sss[i]);
            ++i;
        }
        this.a3canvas.add((A3Object)this.a3);
        this.commentTextArea.setText(this.a3.getComment());
        if (this.pauseCheckBox.isSelected()) {
            this.a3.setMode(Motion.Mode.PAUSE);
        } else {
            this.a3.setMode(Motion.Mode.PLAY);
        }
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
        this.a3.setLocImmediately(0.0, 0.0, 0.0);
        this.a3.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.a3.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                A3Panel.this.controller.adjust((A3Object)A3Panel.this.a3);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    public void loadAction3D(File f) throws Exception {
        try {
            final String urlString = f.toURI().toURL().toString();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    A3Panel.this.loadAction3D(urlString);
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void repaint() {
        if (this.a3 == null) {
            return;
        }
        if (this.immediatelyCheckBox.isSelected()) {
            this.a3.changeImmediately((Serializable)((Object)this.actionName));
        } else {
            this.a3.change((Serializable)((Object)this.actionName));
        }
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
    }

    void setBackground(String bgUrlString) {
        URL url = null;
        try {
            url = new URL(bgUrlString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
        Box.createVerticalBox();
    }

    public BufferedImage snapshot() {
        return this.a3canvas.snapshot();
    }

    public void clear() {
        if (this.a3 != null) {
            this.a3canvas.del((A3Object)this.a3);
        }
    }
}

