/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import jp.sourceforge.acerola3d.a3.catalog.A;
import jp.sourceforge.acerola3d.a3.catalog.A3;
import jp.sourceforge.acerola3d.a3.catalog.Htmlfile;
import jp.sourceforge.acerola3d.a3.catalog.Profile;
import jp.sourceforge.acerola3d.a3.catalog.Tag;
import jp.sourceforge.acerola3d.a3.catalog.Thumbnail;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.A3eMetadataGUI;

class Catalog {
    A3eFileManager fileManager;
    File file;
    A3 a3;

    Catalog(File f, A3eFileManager fm) throws Exception {
        this.file = f;
        this.fileManager = fm;
        JAXBContext jc = JAXBContext.newInstance((String)"jp.sourceforge.acerola3d.a3.catalog");
        Unmarshaller u = jc.createUnmarshaller();
        FileInputStream fis = new FileInputStream(this.file);
        this.a3 = (A3)u.unmarshal((InputStream)fis);
        fis.close();
    }

    Catalog(A3eFileManager fm) {
        this.fileManager = fm;
        this.a3 = new A3();
        Profile profile = new Profile();
        profile.setUri("http://acerola3d.sourceforge.jp/a3profile/RootProfile");
        this.a3.getProfile().add(profile);
        A a = new A();
        a.setAn("enter action name");
        this.a3.getA().add(a);
    }

    void save() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"jp.sourceforge.acerola3d.a3.catalog");
        Marshaller m = jc.createMarshaller();
        FileOutputStream fos = new FileOutputStream(this.file);
        m.marshal((Object)this.a3, (OutputStream)fos);
        fos.close();
    }

    A3eMetadataGUI getMetadataGUI() {
        return new A3eMetadataGUI(this, this.fileManager);
    }

    String[] getProfiles() {
        ArrayList<String> al = new ArrayList<String>();
        for (Profile p : this.a3.getProfile()) {
            al.add(p.getUri());
        }
        return al.toArray(new String[0]);
    }

    String[] getTags() {
        ArrayList<String> al = new ArrayList<String>();
        for (Tag t : this.a3.getTag()) {
            al.add(t.getName());
        }
        return al.toArray(new String[0]);
    }

    A3eFile[] getThumbnails() {
        ArrayList<A3eFile> al = new ArrayList<A3eFile>();
        for (Thumbnail t : this.a3.getThumbnail()) {
            A3eFile f = this.fileManager.getA3eFileFromPath(t.getSrc());
            if (f == null) continue;
            al.add(f);
        }
        if (al.size() == 0) {
            al.add(A3eFile.noneFile);
        }
        return al.toArray(new A3eFile[0]);
    }

    A3eFile getHtml() {
        Htmlfile hf = this.a3.getHtmlfile();
        if (hf == null) {
            return A3eFile.noneFile;
        }
        A3eFile f = this.fileManager.getA3eFileFromPath(hf.getSrc());
        if (f == null) {
            return A3eFile.noneFile;
        }
        return f;
    }

    String[] getActionNames() {
        ArrayList<String> al = new ArrayList<String>();
        for (A a : this.a3.getA()) {
            al.add(a.getAn());
        }
        return al.toArray(new String[0]);
    }

    String getHaltActionName() {
        BigInteger abi = this.a3.getHaltActionNo();
        int ai = abi.intValue();
        try {
            A a = this.a3.getA().get(ai);
            return a.getAn();
        }
        catch (IndexOutOfBoundsException e) {
            return "[none]";
        }
    }

    String getWalkActionName() {
        BigInteger abi = this.a3.getWalkActionNo();
        int ai = abi.intValue();
        try {
            A a = this.a3.getA().get(ai);
            return a.getAn();
        }
        catch (IndexOutOfBoundsException e) {
            return "[none]";
        }
    }

    String getRunActionName() {
        BigInteger abi = this.a3.getRunActionNo();
        int ai = abi.intValue();
        try {
            A a = this.a3.getA().get(ai);
            return a.getAn();
        }
        catch (IndexOutOfBoundsException e) {
            return "[none]";
        }
    }

    double getMinWalkSpeed() {
        return this.a3.getMinWalkSpeed();
    }

    double getMinRunSpeed() {
        return this.a3.getMinRunSpeed();
    }

    boolean isBillboard() {
        return this.a3.isBillboard();
    }

    void setProfiles(String[] uris) {
        this.a3.getProfile().clear();
        String[] stringArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            Profile p = new Profile();
            p.setUri(uri);
            this.a3.getProfile().add(p);
            ++n2;
        }
    }

    void setComment(String s) {
        this.a3.setC(s);
    }

    void setTags(String[] tags) {
        this.a3.getTag().clear();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            Tag t = new Tag();
            t.setName(tag);
            this.a3.getTag().add(t);
            ++n2;
        }
    }

    void setThumbnail(A3eFile file) {
        this.a3.getThumbnail().clear();
        if (file != A3eFile.noneFile) {
            Thumbnail t = new Thumbnail();
            t.setSrc(file.getPath());
        }
    }

    void setHtmlfile(A3eFile file) {
        if (file == A3eFile.noneFile) {
            this.a3.setHtmlfile(null);
        } else {
            Htmlfile h = new Htmlfile();
            h.setSrc(file.getPath());
            this.a3.setHtmlfile(h);
        }
    }

    void setHaltAction(String an) {
        int i = 0;
        for (A a : this.a3.getA()) {
            if (a.getAn().equals(an)) {
                this.a3.setHaltActionNo(new BigInteger("" + i));
                return;
            }
            ++i;
        }
        this.a3.setHaltActionNo(new BigInteger("0"));
    }

    void setWalkAction(String an) {
        int i = 0;
        for (A a : this.a3.getA()) {
            if (a.getAn().equals(an)) {
                this.a3.setWalkActionNo(new BigInteger("" + i));
                return;
            }
            ++i;
        }
        this.a3.setHaltActionNo(new BigInteger("0"));
    }

    void setRunAction(String an) {
        int i = 0;
        for (A a : this.a3.getA()) {
            if (a.getAn().equals(an)) {
                this.a3.setRunActionNo(new BigInteger("" + i));
                return;
            }
            ++i;
        }
        this.a3.setHaltActionNo(new BigInteger("0"));
    }

    void setMinWalkSpeed(double d) {
        this.a3.setMinWalkSpeed(d);
    }

    void setMinRunSpeed(double d) {
        this.a3.setMinRunSpeed(d);
    }

    void setBillboard(boolean b) {
        this.a3.setBillboard(b);
    }
}

