/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManagerGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;

class A3eFileManager {
    File rootDir;
    A3eFile a3eRootDir;
    A3eFile[] files;
    A3eFileManagerGUI fileManagerGUI;

    A3eFileManager(File rootDir) throws IOException {
        this.rootDir = rootDir;
        this.refresh();
        this.fileManagerGUI = new A3eFileManagerGUI(this);
    }

    void setRootDir(File rootDir) throws IOException {
        this.rootDir = rootDir;
        this.refresh();
    }

    void refresh() throws IOException {
        ArrayList<A3eFile> filesAL = new ArrayList<A3eFile>();
        this.a3eRootDir = new A3eFile(this, null, "");
        File[] fileArray = this.rootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.refreshR(this.a3eRootDir, f, filesAL);
            ++n2;
        }
        A3eFile[] oldFiles = this.files;
        this.files = filesAL.toArray(new A3eFile[0]);
        if (oldFiles != null) {
            A3eFile[] a3eFileArray = this.files;
            int n3 = this.files.length;
            n = 0;
            while (n < n3) {
                A3eFile newF = a3eFileArray[n];
                A3eFile[] a3eFileArray2 = oldFiles;
                int n4 = oldFiles.length;
                int n5 = 0;
                while (n5 < n4) {
                    A3eFile oldF = a3eFileArray2[n5];
                    if (newF.getPath().equals(oldF.getPath())) {
                        newF.isIgnored = oldF.isIgnored;
                        newF.type = oldF.type;
                    }
                    ++n5;
                }
                ++n;
            }
        }
        int catalogCount = 0;
        A3eFile[] a3eFileArray = this.files;
        int n6 = this.files.length;
        int n7 = 0;
        while (n7 < n6) {
            A3eFile f = a3eFileArray[n7];
            if (f.type == A3eFileType.CATALOG) {
                ++catalogCount;
            }
            ++n7;
        }
        if (catalogCount == 0) {
            File f = new File(this.rootDir, "CATALOG.XML");
            f.createNewFile();
            this.refresh();
        } else if (catalogCount >= 2) {
            System.out.println("\u8b66\u544a\uff1a2\u4ee5\u4e0a\u306eCATALOG.XML\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u3059\uff0e");
        }
    }

    void refreshR(A3eFile parent, File f, ArrayList<A3eFile> filesAL) {
        if (!f.isDirectory()) {
            A3eFile af = new A3eFile(this, parent, f.getName());
            filesAL.add(af);
            parent.children.add(af);
        } else {
            A3eFile af = new A3eFile(this, parent, f.getName());
            filesAL.add(af);
            parent.children.add(af);
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File ff = fileArray[n2];
                this.refreshR(af, ff, filesAL);
                ++n2;
            }
        }
    }

    String[] list() {
        ArrayList<String> ret = new ArrayList<String>();
        A3eFile[] a3eFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (!f.isIgnored) {
                ret.add(f.getPath());
            }
            ++n2;
        }
        return ret.toArray(new String[0]);
    }

    String[] list(A3eFileType t) {
        ArrayList<String> ret = new ArrayList<String>();
        A3eFile[] a3eFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (f.type == t && !f.isIgnored) {
                ret.add(f.getPath());
            }
            ++n2;
        }
        return ret.toArray(new String[0]);
    }

    A3eFile[] listA3eFile() {
        return (A3eFile[])this.files.clone();
    }

    A3eFile[] listA3eFile(A3eFileType t) {
        ArrayList<A3eFile> ret = new ArrayList<A3eFile>();
        A3eFile[] a3eFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (f.type == t && !f.isIgnored) {
                ret.add(f);
            }
            ++n2;
        }
        return ret.toArray(new A3eFile[0]);
    }

    A3eFileManagerGUI getGUI() {
        return this.fileManagerGUI;
    }

    A3eFile getRefreshedFile(A3eFile oldFile) {
        A3eFile ret = null;
        A3eFile[] a3eFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (oldFile.getPath().equals(f.getPath())) {
                ret = f;
                break;
            }
            ++n2;
        }
        return ret;
    }

    A3eFile getA3eFileFromPath(String path) {
        A3eFile ret = null;
        A3eFile[] a3eFileArray = this.listA3eFile();
        int n = a3eFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (f.getPath().equals(path)) {
                ret = f;
                break;
            }
            ++n2;
        }
        return ret;
    }

    String path2FileName(String filePath) {
        A3eFile f = this.getA3eFileFromPath(filePath);
        if (f != null) {
            return f.getPath();
        }
        return null;
    }

    String[] fileName2Path(String fileName, A3eFileType t) {
        A3eFile[] files = null;
        files = t == null ? this.listA3eFile() : this.listA3eFile(t);
        ArrayList<String> al = new ArrayList<String>();
        A3eFile[] a3eFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            A3eFile f = a3eFileArray[n2];
            if (f.name.equals(fileName)) {
                al.add(f.getPath());
            }
            ++n2;
        }
        return al.toArray(new String[0]);
    }

    String path2UrlString(String path) {
        A3eFile f = this.getA3eFileFromPath(path);
        if (f == null) {
            return null;
        }
        try {
            return f.toFile().toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

