/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.Skeleton;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.a3.bvh.BVH;
import jp.sourceforge.acerola3d.a3.catalog.A;
import jp.sourceforge.acerola3d.a3.catalog.P;
import jp.sourceforge.acerola3d.a3.catalog.S;
import jp.sourceforge.acerola3d.a3.catalog.SoundType;
import jp.sourceforge.acerola3d.a3editor.A3Editor;
import jp.sourceforge.acerola3d.a3editor.A3eActionEditorGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.Catalog;
import jp.sourceforge.acerola3d.a3editor.CenteredVRML;

class A3eActionEditor {
    A3Editor editor;
    A3eFileManager fileManager;
    Catalog catalog;
    A3eActionEditorGUI gui;
    A currentAction;
    Skeleton currentSkeleton;
    HashMap<String, CenteredVRML> vrmls = new HashMap();

    A3eActionEditor(A3Editor e) {
        this.editor = e;
        this.fileManager = e.fileManager;
        this.catalog = e.catalog;
        this.setCurrent(this.catalog.a3.getA().get(0));
        this.gui = new A3eActionEditorGUI(this, this.editor);
    }

    void setCurrent(A a) {
        this.currentAction = a;
        String bvhPath = this.currentAction.getBvh();
        String bvhUrl = this.fileManager.path2UrlString(bvhPath);
        if (bvhUrl != null && !bvhPath.equals("none")) {
            try {
                this.currentSkeleton = new Skeleton(bvhUrl);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.currentSkeleton = null;
        }
        String s = this.currentAction.getOffset();
        double x = Double.parseDouble(s.split("\\s")[0]);
        double y = Double.parseDouble(s.split("\\s")[1]);
        double z = Double.parseDouble(s.split("\\s")[2]);
        Vector3d actionOffset = new Vector3d(x, y, z);
        s = this.currentAction.getRot();
        x = Double.parseDouble(s.split("\\s")[0]) / 180.0 * Math.PI;
        y = Double.parseDouble(s.split("\\s")[1]) / 180.0 * Math.PI;
        z = Double.parseDouble(s.split("\\s")[2]) / 180.0 * Math.PI;
        Quat4d actionQuat = Util.euler2quat((double)x, (double)y, (double)z);
        double actionScale = this.currentAction.getScale();
        if (this.currentSkeleton != null) {
            this.currentSkeleton.setLoc(actionOffset);
            this.currentSkeleton.setQuat(actionQuat);
            this.currentSkeleton.setScale(actionScale);
        }
        this.vrmls.clear();
        for (P p : this.currentAction.getP()) {
            String path = p.getWrl();
            String urlString = this.fileManager.path2UrlString(path);
            try {
                CenteredVRML vrml = new CenteredVRML(urlString);
                Vector3d loc = new Vector3d();
                Vector3d boneOffset1 = null;
                if (this.currentSkeleton != null) {
                    boneOffset1 = this.currentSkeleton.getOffset(p.getName());
                }
                if (boneOffset1 != null) {
                    loc.add(boneOffset1);
                }
                s = p.getOffset();
                x = Double.parseDouble(s.split("\\s")[0]);
                y = Double.parseDouble(s.split("\\s")[1]);
                z = Double.parseDouble(s.split("\\s")[2]);
                Vector3d boneOffset2 = new Vector3d(x, y, z);
                loc.add((Tuple3d)boneOffset2);
                loc.scale(actionScale);
                loc.add((Tuple3d)actionOffset);
                loc = Util.trans((Quat4d)actionQuat, (Vector3d)loc);
                s = p.getRot();
                x = Double.parseDouble(s.split("\\s")[0]) / 180.0 * Math.PI;
                y = Double.parseDouble(s.split("\\s")[1]) / 180.0 * Math.PI;
                z = Double.parseDouble(s.split("\\s")[2]) / 180.0 * Math.PI;
                Quat4d boneQuat = Util.euler2quat((double)x, (double)y, (double)z);
                boneQuat.mul(actionQuat);
                double boneScale = actionScale * p.getScale();
                vrml.setQuat(boneQuat);
                vrml.setScale(boneScale);
                vrml.setLoc2(loc);
                this.vrmls.put(p.getName(), vrml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void changeCurrentAction(String an) {
        A ca = null;
        for (A a : this.catalog.a3.getA()) {
            if (!a.getAn().equals(an)) continue;
            ca = a;
            break;
        }
        if (ca != null) {
            this.setCurrent(ca);
        }
    }

    A3eActionEditorGUI getGUI() {
        return this.gui;
    }

    String[] getActionNames() {
        ArrayList<String> al = new ArrayList<String>();
        for (A a : this.catalog.a3.getA()) {
            al.add(a.getAn());
        }
        return al.toArray(new String[0]);
    }

    void deleteAction(String an) {
        List<A> actions = this.catalog.a3.getA();
        if (actions.size() <= 1) {
            return;
        }
        A a = null;
        for (A aa : actions) {
            if (!aa.getAn().equals(an)) continue;
            a = aa;
            break;
        }
        if (a != null) {
            actions.remove(a);
        }
        this.setCurrent(actions.get(0));
    }

    void createNewAction(String an) {
        A a = new A();
        a.setAn(an);
        this.catalog.a3.getA().add(a);
        this.setCurrent(a);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkCompatibility(String an, A3eFile bvh) {
        if (an.equals("[none]")) {
            return true;
        }
        try {
            A baseAction = null;
            for (A a : this.catalog.a3.getA()) {
                if (!a.getAn().equals(an)) continue;
                baseAction = a;
                break;
            }
            if (baseAction == null) {
                return false;
            }
            A3eFile f = this.editor.fileManager.getA3eFileFromPath(baseAction.getBvh());
            BVH baseBvh = new BVH(f.toFile().toURI().toURL().toString());
            BVH targetBVH = new BVH(bvh.toFile().toURI().toURL().toString());
            String[] stringArray = baseBvh.getAllBones();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String b = stringArray[n2];
                boolean check = false;
                String[] stringArray2 = targetBVH.getAllBones();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String bb = stringArray2[n4];
                    if (b.equals(bb)) {
                        check = true;
                        break;
                    }
                    ++n4;
                }
                if (!check) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    void createNewAction2(String newActionName, String baseActionName, A3eFile bvh) {
        A a2;
        A baseAction = null;
        if (!baseActionName.equals("[none]")) {
            for (A a2 : this.catalog.a3.getA()) {
                if (!a2.getAn().equals(baseActionName)) continue;
                baseAction = a2;
                break;
            }
        }
        if (baseAction == null) {
            a2 = new A();
            a2.setAn(newActionName);
            if (bvh != A3eFile.noneFile) {
                a2.setBvh(bvh.getPath());
            }
            this.catalog.a3.getA().add(a2);
            this.setCurrent(a2);
        } else {
            a2 = new A();
            a2.setAn(newActionName);
            if (bvh != A3eFile.noneFile) {
                a2.setBvh(bvh.getPath());
            }
            for (P p : baseAction.getP()) {
                P pp = new P();
                pp.setName(p.getName());
                pp.setWrl(p.getWrl());
                pp.setScale(p.getScale());
                pp.setOffset(p.getOffset());
                pp.setRot(p.getRot());
                a2.getP().add(pp);
            }
            if (baseAction.getS() != null) {
                S s = new S();
                s.setFile(baseAction.getS().getFile());
                s.setType(baseAction.getS().getType());
                s.setLoop(baseAction.getS().isLoop());
                s.setGain(baseAction.getS().getGain());
                s.setOffset(baseAction.getS().getOffset());
                s.setDirection(baseAction.getS().getDirection());
                s.setContinue(baseAction.getS().isContinue());
                a2.setS(s);
            }
            a2.setLoop(baseAction.isLoop());
            a2.setScale(baseAction.getScale());
            a2.setOffset(baseAction.getOffset());
            a2.setRot(baseAction.getRot());
            a2.setRightBalloonOffset(baseAction.getRightBalloonOffset());
            a2.setLeftBalloonOffset(baseAction.getLeftBalloonOffset());
            a2.setTopBalloonOffset(baseAction.getTopBalloonOffset());
            a2.setBottomBalloonOffset(baseAction.getBottomBalloonOffset());
            a2.setLabelOffset(baseAction.getLabelOffset());
            a2.setSegno(baseAction.getSegno());
            a2.setDalsegno(baseAction.getDalsegno());
            this.catalog.a3.getA().add(a2);
            this.setCurrent(a2);
        }
    }

    void setActionName(String an) {
        this.currentAction.setAn(an);
    }

    String getCurrentActionName() {
        return this.currentAction.getAn();
    }

    Skeleton getCurrentSkeleton() {
        return this.currentSkeleton;
    }

    CenteredVRML[] getCurrentVRMLs() {
        return this.vrmls.values().toArray(new CenteredVRML[0]);
    }

    boolean checkActionNameDuplication(String an) {
        for (A a : this.catalog.a3.getA()) {
            if (!a.getAn().equals(an)) continue;
            return true;
        }
        return false;
    }

    String getBVH() {
        String bvhFilePath = this.currentAction.getBvh();
        String fileName = this.fileManager.path2FileName(bvhFilePath);
        return fileName;
    }

    void setBVH(A3eFile file) {
        String an = this.currentAction.getAn();
        int i = this.catalog.a3.getA().indexOf(this.currentAction);
        this.catalog.a3.getA().remove(this.currentAction);
        A a = new A();
        a.setAn(an);
        this.catalog.a3.getA().add(i, a);
        if (file == A3eFile.noneFile) {
            a.setBvh("[none]");
        } else {
            a.setBvh(file.getPath());
        }
        this.setCurrent(a);
    }

    boolean getLoop() {
        return this.currentAction.isLoop();
    }

    void setLoop(boolean b) {
        this.currentAction.setLoop(b);
    }

    double getSegno() {
        return this.currentAction.getSegno();
    }

    void setSegno(double d) {
        this.currentAction.setSegno(d);
    }

    double getDalsegno() {
        return this.currentAction.getDalsegno();
    }

    void setDalsegno(double d) {
        this.currentAction.setDalsegno(d);
    }

    double getRBX() {
        String s = this.currentAction.getRightBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }

    void setRBX(double x) {
        String s = this.currentAction.getRightBalloonOffset();
        this.currentAction.setRightBalloonOffset(x + " " + s.split("\\s")[1]);
    }

    double getRBY() {
        String s = this.currentAction.getRightBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }

    void setRBY(double y) {
        String s = this.currentAction.getRightBalloonOffset();
        this.currentAction.setRightBalloonOffset(String.valueOf(s.split("\\s")[0]) + " " + y);
    }

    double getLBX() {
        String s = this.currentAction.getLeftBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }

    void setLBX(double x) {
        String s = this.currentAction.getLeftBalloonOffset();
        this.currentAction.setLeftBalloonOffset(x + " " + s.split("\\s")[1]);
    }

    double getLBY() {
        String s = this.currentAction.getLeftBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }

    void setLBY(double y) {
        String s = this.currentAction.getLeftBalloonOffset();
        this.currentAction.setLeftBalloonOffset(String.valueOf(s.split("\\s")[0]) + " " + y);
    }

    double getTBX() {
        String s = this.currentAction.getTopBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }

    void setTBX(double x) {
        String s = this.currentAction.getTopBalloonOffset();
        this.currentAction.setTopBalloonOffset(x + " " + s.split("\\s")[1]);
    }

    double getTBY() {
        String s = this.currentAction.getTopBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }

    void setTBY(double y) {
        String s = this.currentAction.getTopBalloonOffset();
        this.currentAction.setTopBalloonOffset(String.valueOf(s.split("\\s")[0]) + " " + y);
    }

    double getBBX() {
        String s = this.currentAction.getBottomBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }

    void setBBX(double x) {
        String s = this.currentAction.getBottomBalloonOffset();
        this.currentAction.setBottomBalloonOffset(x + " " + s.split("\\s")[1]);
    }

    double getBBY() {
        String s = this.currentAction.getBottomBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }

    void setBBY(double y) {
        String s = this.currentAction.getBottomBalloonOffset();
        this.currentAction.setBottomBalloonOffset(String.valueOf(s.split("\\s")[0]) + " " + y);
    }

    double getLX() {
        String s = this.currentAction.getLabelOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }

    void setLX(double x) {
        String s = this.currentAction.getLabelOffset();
        this.currentAction.setLabelOffset(x + " " + s.split("\\s")[1]);
    }

    double getLY() {
        String s = this.currentAction.getLabelOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }

    void setLY(double y) {
        String s = this.currentAction.getLabelOffset();
        this.currentAction.setLabelOffset(String.valueOf(s.split("\\s")[0]) + " " + y);
    }

    String[] getAllBones() {
        if (this.currentSkeleton == null) {
            return new String[0];
        }
        return this.currentSkeleton.getBones();
    }

    String[] getUsedBones() {
        ArrayList<String> al = new ArrayList<String>();
        for (P p : this.currentAction.getP()) {
            al.add(p.getName());
        }
        return al.toArray(new String[0]);
    }

    A3eFile getVRMLFile(String bn) {
        String wrl = null;
        for (P p : this.currentAction.getP()) {
            if (!p.getName().equals(bn)) continue;
            wrl = p.getWrl();
        }
        if (wrl != null) {
            return this.fileManager.getA3eFileFromPath(wrl);
        }
        return A3eFile.noneFile;
    }

    CenteredVRML getVRML(String bn) {
        return this.vrmls.get(bn);
    }

    void setVRML(String bn, A3eFile file) {
        P p = null;
        for (P pp : this.currentAction.getP()) {
            if (!pp.getName().equals(bn)) continue;
            p = pp;
            break;
        }
        if (p != null) {
            if (file == A3eFile.noneFile) {
                this.currentAction.getP().remove(p);
            } else {
                p.setWrl(file.getPath());
            }
        } else if (file != A3eFile.noneFile) {
            p = new P();
            p.setName(bn);
            p.setWrl(file.getPath());
            this.currentAction.getP().add(p);
        }
        this.setCurrent(this.currentAction);
    }

    void removeSoundDate() {
        this.currentAction.setS(null);
    }

    String getSoundFile() {
        S s = this.currentAction.getS();
        if (s == null) {
            return null;
        }
        return this.currentAction.getS().getFile();
    }

    void setSoundFile(A3eFile file) {
        S s = this.currentAction.getS();
        if (s == null) {
            s = new S();
            s.setFile(file.getPath());
            this.currentAction.setS(s);
        }
        s.setFile(file.getPath());
    }

    String getSoundType() {
        SoundType st = this.currentAction.getS().getType();
        if (st == SoundType.POINT_SOUND) {
            return "PointSound";
        }
        if (st == SoundType.BACKGROUND_SOUND) {
            return "Background";
        }
        if (st == SoundType.CONE_SOUND) {
            return "ConeSound";
        }
        return null;
    }

    void setSoundType(String st) {
        if (st.equals("PointSound")) {
            this.currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("Background")) {
            this.currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("ConeSound")) {
            this.currentAction.getS().setType(SoundType.CONE_SOUND);
        }
    }

    boolean getSoundLoop() {
        return this.currentAction.getS().isLoop();
    }

    void setSoundLoop(boolean b) {
        this.currentAction.getS().setLoop(b);
    }

    double getSoundGain() {
        return this.currentAction.getS().getGain();
    }

    void setSoundGain(double d) {
        this.currentAction.getS().setGain(d);
    }

    boolean getSoundContinue() {
        return this.currentAction.getS().isContinue();
    }

    void setSoundContinue(boolean b) {
        this.currentAction.getS().setContinue(b);
    }

    Vector3d getSoundOffset() {
        String so = this.currentAction.getS().getOffset();
        double x = Double.parseDouble(so.split("\\s")[0]);
        double y = Double.parseDouble(so.split("\\s")[1]);
        double z = Double.parseDouble(so.split("\\s")[2]);
        return new Vector3d(x, y, z);
    }

    void setSoundOffset(double x, double y, double z) {
        S s = this.currentAction.getS();
        if (s == null) {
            return;
        }
        String so = x + " " + y + " " + z;
        s.setOffset(so);
    }

    Vector3d getSoundDirection() {
        String sd = this.currentAction.getS().getDirection();
        double x = Double.parseDouble(sd.split("\\s")[0]);
        double y = Double.parseDouble(sd.split("\\s")[1]);
        double z = Double.parseDouble(sd.split("\\s")[2]);
        return new Vector3d(x, y, z);
    }

    void setSoundDirection(double x, double y, double z) {
        S s = this.currentAction.getS();
        if (s == null) {
            return;
        }
        String sd = x + " " + y + " " + z;
        s.setDirection(sd);
    }

    Vector3d getOffset() {
        String o = this.currentAction.getOffset();
        double x = Double.parseDouble(o.split("\\s")[0]);
        double y = Double.parseDouble(o.split("\\s")[1]);
        double z = Double.parseDouble(o.split("\\s")[2]);
        return new Vector3d(x, y, z);
    }

    void setOffset(Vector3d v) {
        String o = v.x + " " + v.y + " " + v.z;
        this.currentAction.setOffset(o);
    }

    Vector3d getRot() {
        String r = this.currentAction.getRot();
        double x = Double.parseDouble(r.split("\\s")[0]) / 180.0 * Math.PI;
        double y = Double.parseDouble(r.split("\\s")[1]) / 180.0 * Math.PI;
        double z = Double.parseDouble(r.split("\\s")[2]) / 180.0 * Math.PI;
        return new Vector3d(x, y, z);
    }

    void setRot(Vector3d v) {
        String r = 180.0 * v.x / Math.PI + " " + 180.0 * v.y / Math.PI + " " + 180.0 * v.z / Math.PI;
        this.currentAction.setRot(r);
    }

    double getScale() {
        return this.currentAction.getScale();
    }

    void setScale(double s) {
        this.currentAction.setScale(s);
    }

    void updateActionOffsetRotScale() {
        if (this.currentSkeleton == null) {
            return;
        }
        this.setOffset(this.currentSkeleton.getLoc());
        this.setRot(this.currentSkeleton.getRot());
        this.setScale(this.currentSkeleton.getScale());
    }

    void updatePartsOffsetRotScale() {
        Set<String> keys = this.vrmls.keySet();
        for (String k : keys) {
            this.updatePartOffsetRotScale(k);
        }
    }

    void updatePartOffsetRotScale(String bn) {
        Vector3d boneOffset1;
        double actionScale;
        Quat4d actionQuatRev;
        Vector3d actionLoc;
        if (this.currentSkeleton != null) {
            actionLoc = this.currentSkeleton.getLoc();
            actionQuatRev = this.currentSkeleton.getQuat();
            actionQuatRev.conjugate();
            actionScale = this.currentSkeleton.getScale();
            boneOffset1 = this.currentSkeleton.getOffset(bn);
        } else {
            actionLoc = new Vector3d();
            actionQuatRev = new Quat4d(0.0, 0.0, 0.0, 1.0);
            actionScale = 1.0;
            boneOffset1 = new Vector3d();
        }
        for (P p : this.currentAction.getP()) {
            if (!p.getName().equals(bn)) continue;
            CenteredVRML vrml = this.vrmls.get(bn);
            Vector3d v = vrml.getLoc2();
            v = Util.trans((Quat4d)actionQuatRev, (Vector3d)v);
            v.sub((Tuple3d)actionLoc);
            v.scale(1.0 / actionScale);
            if (boneOffset1 != null) {
                v.sub((Tuple3d)boneOffset1);
            }
            String s = v.x + " " + v.y + " " + v.z;
            p.setOffset(s);
            Quat4d boneQuat = vrml.getQuat();
            boneQuat.mul(actionQuatRev);
            v = Util.quat2euler((Quat4d)boneQuat);
            s = 180.0 * v.x / Math.PI + " " + 180.0 * v.y / Math.PI + " " + 180.0 * v.z / Math.PI;
            p.setRot(s);
            p.setScale(vrml.getScale() / actionScale);
        }
    }

    void saveCatalog() {
        try {
            this.editor.catalog.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

