package jp.sourceforge.acerola3d.a3editor;

import jp.sourceforge.acerola3d.a3.*;
import java.net.URL;
import javax.media.j3d.*;
import javax.vecmath.*;

public class CenteredVRML extends A3Object {
    Vector3d offset;
    public CenteredVRML(String url) throws Exception {
        super(new A3InitData("jp.sourceforge.acerola3d.a3editor.CenteredVRML"));

        offset = new Vector3d();
        URL u = new URL(url);
        Node n = Util.loadVRML_B(u);
        Bounds b = n.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            offset.set(p);
            offset.scale(-1.0);
        } else {
            offset.set(0.0,0.0,0.0);
        }

        Transform3D t = new Transform3D();
        t.set(offset);
        TransformGroup tg = new TransformGroup(t);
        tg.addChild(n);

        setNode(tg);
    }
    public void setLoc2(double x,double y,double z) {
        setLoc2(new Vector3d(x,y,z));
    }
    public void setLoc2(Vector3d v) {
        Vector3d vv = new Vector3d(offset);
        vv.scale(-1.0*getScale());
        vv.add(v);
        setLoc(vv);
    }
    public Vector3d getLoc2() {
        Vector3d v = new Vector3d(offset);
        v.scale(getScale());
        v.add(getLoc());
        return v;
    }
}
