package jp.sourceforge.acerola3d.a3editor;

import java.util.*;
import javax.vecmath.*;

import jp.sourceforge.acerola3d.a3.*;
import jp.sourceforge.acerola3d.a3.bvh.BVH;
import jp.sourceforge.acerola3d.a3.catalog.*;

class A3eActionEditor {
    A3Editor editor;
    A3eFileManager fileManager;
    Catalog catalog;
    A3eActionEditorGUI gui;
    A currentAction;
    Skeleton currentSkeleton;
    HashMap<String,CenteredVRML> vrmls = new HashMap<String,CenteredVRML>();

    A3eActionEditor(A3Editor e) {
        editor = e;
        fileManager = e.fileManager;
        catalog = e.catalog;
        setCurrent(catalog.a3.getA().get(0));
        gui = new A3eActionEditorGUI(this,editor);
    }
    void setCurrent(A a) {
        currentAction = a;
        String bvhPath = currentAction.getBvh();
        String bvhUrl = fileManager.path2UrlString(bvhPath);
        if (bvhUrl!=null && !bvhPath.equals("none")) {
            try {
                currentSkeleton = new Skeleton(bvhUrl);
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            currentSkeleton = null;
        }
        String s = currentAction.getOffset();
        double x = Double.parseDouble(s.split("\\s")[0]);
        double y = Double.parseDouble(s.split("\\s")[1]);
        double z = Double.parseDouble(s.split("\\s")[2]);
        Vector3d actionOffset = new Vector3d(x,y,z);
        s = currentAction.getRot();
        x = Double.parseDouble(s.split("\\s")[0])/180.0*Math.PI;
        y = Double.parseDouble(s.split("\\s")[1])/180.0*Math.PI;
        z = Double.parseDouble(s.split("\\s")[2])/180.0*Math.PI;
        Quat4d actionQuat = Util.euler2quat(x,y,z);
        double actionScale = currentAction.getScale();
        if (currentSkeleton!=null) {
            currentSkeleton.setLoc(actionOffset);
            currentSkeleton.setQuat(actionQuat);
            currentSkeleton.setScale(actionScale);
        }
        //VRML.clearCash();
        vrmls.clear();
        for (P p : currentAction.getP()) {
            String path = p.getWrl();
            String urlString = fileManager.path2UrlString(path);
            try {
                CenteredVRML vrml = new CenteredVRML(urlString);
                Vector3d loc = new Vector3d();
                Vector3d boneOffset1 = null;
                if (currentSkeleton!=null)
                    boneOffset1 = currentSkeleton.getOffset(p.getName());
                if (boneOffset1!=null)
                    loc.add(boneOffset1);
                s = p.getOffset();
                x = Double.parseDouble(s.split("\\s")[0]);
                y = Double.parseDouble(s.split("\\s")[1]);
                z = Double.parseDouble(s.split("\\s")[2]);
                Vector3d boneOffset2 = new Vector3d(x,y,z);
                loc.add(boneOffset2);
                loc.scale(actionScale);
                loc.add(actionOffset);
                loc = Util.trans(actionQuat,loc);
                s = p.getRot();
                x = Double.parseDouble(s.split("\\s")[0])/180.0*Math.PI;
                y = Double.parseDouble(s.split("\\s")[1])/180.0*Math.PI;
                z = Double.parseDouble(s.split("\\s")[2])/180.0*Math.PI;
                Quat4d boneQuat = Util.euler2quat(x,y,z);
                boneQuat.mul(actionQuat);
                double boneScale = actionScale*p.getScale();
                vrml.setQuat(boneQuat);
                vrml.setScale(boneScale);
                vrml.setLoc2(loc);
                vrmls.put(p.getName(),vrml);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    void changeCurrentAction(String an) {
        A ca = null;
        for (A a : catalog.a3.getA()) {
            if (a.getAn().equals(an)) {
                ca = a;
                break;
            }
        }
        if (ca!=null) {
            setCurrent(ca);
        }
    }
    A3eActionEditorGUI getGUI() {
        return gui;
    }
    String[] getActionNames() {
        ArrayList<String> al = new ArrayList<String>();
        for (A a : catalog.a3.getA()) {
            al.add(a.getAn());
        }
        return al.toArray(new String[0]);
    }
    void deleteAction(String an) {
        List<A> actions = catalog.a3.getA();
        if (actions.size()<=1)
            return;
        A a = null;
        for (A aa : actions) {
            if (aa.getAn().equals(an)) {
                a = aa;
                break;
            }
        }
        if (a!=null)
            actions.remove(a);
        setCurrent(actions.get(0));
    }
    void createNewAction(String an) {
        A a = new A();
        a.setAn(an);
        catalog.a3.getA().add(a);
        setCurrent(a);
    }
    boolean checkCompatibility(String an,A3eFile bvh) {
        if (an.equals("[none]"))
            return true;
        try {
            A baseAction=null;
            for (A a:catalog.a3.getA()) {
                if (a.getAn().equals(an)) {
                    baseAction = a;
                    break;
                }
            }
            if (baseAction==null)
                return false;
            A3eFile f = editor.fileManager.getA3eFileFromPath(baseAction.getBvh());
            BVH baseBvh = new BVH(f.toFile().toURI().toURL().toString());
            BVH targetBVH = new BVH(bvh.toFile().toURI().toURL().toString());
            for (String b:baseBvh.getAllBones()) {
                boolean check = false;
                for (String bb:targetBVH.getAllBones()) {
                    if (b.equals(bb)) {
                        check=true;
                        break;
                    }
                }
                if (check==false)
                    return false;
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }
    void createNewAction2(String newActionName,String baseActionName,A3eFile bvh) {
        A baseAction=null;
        if (!baseActionName.equals("[none]")) {
            for (A a:catalog.a3.getA()) {
                if (a.getAn().equals(baseActionName)) {
                    baseAction = a;
                    break;
                }
            }
        }
        if (baseAction==null) {
            A a = new A();
            a.setAn(newActionName);
            if (bvh!=A3eFile.noneFile)
                a.setBvh(bvh.getPath());
            catalog.a3.getA().add(a);
            setCurrent(a);
        } else {
            A a = new A();
            a.setAn(newActionName);
            if (bvh!=A3eFile.noneFile)
                a.setBvh(bvh.getPath());
            //-----
            for (P p:baseAction.getP()) {
                P pp = new P();
                pp.setName(p.getName());
                pp.setWrl(p.getWrl());
                pp.setScale(p.getScale());
                pp.setOffset(p.getOffset());
                pp.setRot(p.getRot());
                a.getP().add(pp);
            }
            if (baseAction.getS()!=null) {
                S s = new S();
                s.setFile(baseAction.getS().getFile());
                s.setType(baseAction.getS().getType());
                s.setLoop(baseAction.getS().isLoop());
                s.setGain(baseAction.getS().getGain());
                s.setOffset(baseAction.getS().getOffset());
                s.setDirection(baseAction.getS().getDirection());
                s.setContinue(baseAction.getS().isContinue());
                a.setS(s);
            }
            a.setLoop(baseAction.isLoop());
            a.setScale(baseAction.getScale());
            a.setOffset(baseAction.getOffset());
            a.setRot(baseAction.getRot());
            a.setRightBalloonOffset(baseAction.getRightBalloonOffset());
            a.setLeftBalloonOffset(baseAction.getLeftBalloonOffset());
            a.setTopBalloonOffset(baseAction.getTopBalloonOffset());
            a.setBottomBalloonOffset(baseAction.getBottomBalloonOffset());
            a.setLabelOffset(baseAction.getLabelOffset());
            a.setSegno(baseAction.getSegno());
            a.setDalsegno(baseAction.getDalsegno());
            //-----
            catalog.a3.getA().add(a);
            setCurrent(a);
        }
    }
    void setActionName(String an) {
        currentAction.setAn(an);
    }
    String getCurrentActionName() {
        return currentAction.getAn();
    }
    Skeleton getCurrentSkeleton() {
        return currentSkeleton;
    }
    CenteredVRML[] getCurrentVRMLs() {
        return vrmls.values().toArray(new CenteredVRML[0]);
    }
    boolean checkActionNameDuplication(String an) {
        for (A a : catalog.a3.getA()) {
            if (a.getAn().equals(an))
                return true;
        }
        return false;
    }
    //以下のメソッドは全てcurrentActionに対する情報のgetter,setter
    String getBVH() {
        String bvhFilePath = currentAction.getBvh();
        String fileName = fileManager.path2FileName(bvhFilePath);
        return fileName;
    }
    void setBVH(A3eFile file) {
        String an = currentAction.getAn();
        int i = catalog.a3.getA().indexOf(currentAction);
        catalog.a3.getA().remove(currentAction);
        A a = new A();
        a.setAn(an);
        catalog.a3.getA().add(i,a);
        if (file==A3eFile.noneFile)
            a.setBvh("[none]");
        else
            a.setBvh(file.getPath());
        setCurrent(a);
    }
    boolean getLoop() {
        return currentAction.isLoop();
    }
    void setLoop(boolean b) {
        currentAction.setLoop(b);
    }
    double getSegno() {
        return currentAction.getSegno();
    }
    void setSegno(double d) {
        currentAction.setSegno(d);
    }
    double getDalsegno() {
        return currentAction.getDalsegno();
    }
    void setDalsegno(double d) {
        currentAction.setDalsegno(d);
    }
    double getRBX() {//右の吹き出しのX座標
        String s = currentAction.getRightBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }
    void setRBX(double x) {//右の吹き出しのX座標
        String s = currentAction.getRightBalloonOffset();
        currentAction.setRightBalloonOffset(""+x+" "+s.split("\\s")[1]);
    }
    double getRBY() {//右の吹き出しのY座標
        String s = currentAction.getRightBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }
    void setRBY(double y) {//右の吹き出しのY座標
        String s = currentAction.getRightBalloonOffset();
        currentAction.setRightBalloonOffset(s.split("\\s")[0]+" "+y);
    }
    double getLBX() {//左の吹き出しのX座標
        String s = currentAction.getLeftBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }
    void setLBX(double x) {//左の吹き出しのX座標
        String s = currentAction.getLeftBalloonOffset();
        currentAction.setLeftBalloonOffset(""+x+" "+s.split("\\s")[1]);
    }
    double getLBY() {//左の吹き出しのY座標
        String s = currentAction.getLeftBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }
    void setLBY(double y) {//左の吹き出しのY座標
        String s = currentAction.getLeftBalloonOffset();
        currentAction.setLeftBalloonOffset(s.split("\\s")[0]+" "+y);
    }
    double getTBX() {//上の吹き出しのX座標
        String s = currentAction.getTopBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }
    void setTBX(double x) {//上の吹き出しのX座標
        String s = currentAction.getTopBalloonOffset();
        currentAction.setTopBalloonOffset(""+x+" "+s.split("\\s")[1]);
    }
    double getTBY() {//上の吹き出しのY座標
        String s = currentAction.getTopBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }
    void setTBY(double y) {//上の吹き出しのY座標
        String s = currentAction.getTopBalloonOffset();
        currentAction.setTopBalloonOffset(s.split("\\s")[0]+" "+y);
    }
    double getBBX() {//下の吹き出しのX座標
        String s = currentAction.getBottomBalloonOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }
    void setBBX(double x) {//下の吹き出しのX座標
        String s = currentAction.getBottomBalloonOffset();
        currentAction.setBottomBalloonOffset(""+x+" "+s.split("\\s")[1]);
    }
    double getBBY() {//下の吹き出しのY座標
        String s = currentAction.getBottomBalloonOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }
    void setBBY(double y) {//上の吹き出しのY座標
        String s = currentAction.getBottomBalloonOffset();
        currentAction.setBottomBalloonOffset(s.split("\\s")[0]+" "+y);
    }
    double getLX() {//ラベルのX座標
        String s = currentAction.getLabelOffset();
        return Double.parseDouble(s.split("\\s")[0]);
    }
    void setLX(double x) {//ラベルのX座標
        String s = currentAction.getLabelOffset();
        currentAction.setLabelOffset(""+x+" "+s.split("\\s")[1]);
    }
    double getLY() {//ラベルのY座標
        String s = currentAction.getLabelOffset();
        return Double.parseDouble(s.split("\\s")[1]);
    }
    void setLY(double y) {//ラベルのY座標
        String s = currentAction.getLabelOffset();
        currentAction.setLabelOffset(s.split("\\s")[0]+" "+y);
    }
    String[] getAllBones() {
        if (currentSkeleton==null)
            return new String[0];
        else
            return currentSkeleton.getBones();
    }
    String[] getUsedBones() {
        ArrayList<String> al = new ArrayList<String>();
        for (P p : currentAction.getP()) {
            al.add(p.getName());
        }
        return al.toArray(new String[0]);
    }
    A3eFile getVRMLFile(String bn) {
        String wrl = null;
        for (P p : currentAction.getP()) {
            if (p.getName().equals(bn)) {
                wrl = p.getWrl();
            }
        }
        if (wrl!=null)
            return fileManager.getA3eFileFromPath(wrl);
        return A3eFile.noneFile;
    }
    CenteredVRML getVRML(String bn) {
        return vrmls.get(bn);
    }
    void setVRML(String bn,A3eFile file) {
        P p = null;
        for (P pp : currentAction.getP()) {
            if (pp.getName().equals(bn)) {
                p = pp;
                break;
            }
        }
        if (p!=null) {
            if (file==A3eFile.noneFile) {
                currentAction.getP().remove(p);
            } else {
                p.setWrl(file.getPath());
            }
        } else {
            if (file!=A3eFile.noneFile) {
                p = new P();
                p.setName(bn);
                p.setWrl(file.getPath());
                currentAction.getP().add(p);
            }
        }
        setCurrent(currentAction);
    }
    void removeSoundDate() {
        currentAction.setS(null);
    }
    String getSoundFile() {
        S s = currentAction.getS();
        if (s==null)
            return null;
        else
            return currentAction.getS().getFile();
    }
    void setSoundFile(A3eFile file) {
        S s = currentAction.getS();
        if (s==null) {
            s = new S();
            s.setFile(file.getPath());
            currentAction.setS(s);
        }
        s.setFile(file.getPath());
    }
    String getSoundType() {
        SoundType st = currentAction.getS().getType();
        if (st == SoundType.POINT_SOUND){
            return "PointSound";
        } else if (st == SoundType.BACKGROUND_SOUND) {
            return "Background";
        } else if (st == SoundType.CONE_SOUND) {
            return "ConeSound";
        } else {
            return null;
        }
    }
    void setSoundType(String st) {
        if (st.equals("PointSound")) {
            currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("Background")) {
            currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("ConeSound")) {
            currentAction.getS().setType(SoundType.CONE_SOUND);
        }
    }
    boolean getSoundLoop() {
        return currentAction.getS().isLoop();
    }
    void setSoundLoop(boolean b) {
        currentAction.getS().setLoop(b);
    }
    double getSoundGain() {
        return currentAction.getS().getGain();
    }
    void setSoundGain(double d) {
        currentAction.getS().setGain(d);
    }
    boolean getSoundContinue() {
        return currentAction.getS().isContinue();
    }
    void setSoundContinue(boolean b) {
        currentAction.getS().setContinue(b);
    }
    Vector3d getSoundOffset() {
        String so = currentAction.getS().getOffset();
        double x = Double.parseDouble(so.split("\\s")[0]);
        double y = Double.parseDouble(so.split("\\s")[1]);
        double z = Double.parseDouble(so.split("\\s")[2]);
        return new Vector3d(x,y,z);
    }
    void setSoundOffset(double x,double y,double z) {
        S s = currentAction.getS();
        if (s==null)
            return;
        String so = ""+x+" "+y+" "+z;
        s.setOffset(so);
    }
    Vector3d getSoundDirection() {
        String sd = currentAction.getS().getDirection();
        double x = Double.parseDouble(sd.split("\\s")[0]);
        double y = Double.parseDouble(sd.split("\\s")[1]);
        double z = Double.parseDouble(sd.split("\\s")[2]);
        return new Vector3d(x,y,z);
    }
    void setSoundDirection(double x,double y,double z) {
        S s = currentAction.getS();
        if (s==null)
            return;
        String sd = ""+x+" "+y+" "+z;
        s.setDirection(sd);
    }
    Vector3d getOffset() {
        String o = currentAction.getOffset();
        double x = Double.parseDouble(o.split("\\s")[0]);
        double y = Double.parseDouble(o.split("\\s")[1]);
        double z = Double.parseDouble(o.split("\\s")[2]);
        return new Vector3d(x,y,z);
    }
    void setOffset(Vector3d v) {
        String o = ""+v.x+" "+v.y+" "+v.z;
        currentAction.setOffset(o);
    }
    Vector3d getRot() {
        String r = currentAction.getRot();
        double x = Double.parseDouble(r.split("\\s")[0])/180.0*Math.PI;
        double y = Double.parseDouble(r.split("\\s")[1])/180.0*Math.PI;
        double z = Double.parseDouble(r.split("\\s")[2])/180.0*Math.PI;
        return new Vector3d(x,y,z);
    }
    void setRot(Vector3d v) {
        String r = ""+180.0*v.x/Math.PI+" "+180.0*v.y/Math.PI+" "+180.0*v.z/Math.PI;
        currentAction.setRot(r);
    }
    double getScale() {
        return currentAction.getScale();
    }
    void setScale(double s) {
        currentAction.setScale(s);
    }
    void updateActionOffsetRotScale() {
        if (currentSkeleton==null)
            return;
        setOffset(currentSkeleton.getLoc());
        setRot(currentSkeleton.getRot());
        setScale(currentSkeleton.getScale());
    }
    void updatePartsOffsetRotScale() {
        Set<String> keys = vrmls.keySet();
        for (String k: keys) {
            updatePartOffsetRotScale(k);
        }
    }
    void updatePartOffsetRotScale(String bn) {
        Vector3d actionLoc;
        Quat4d actionQuatRev;
        double actionScale;
        Vector3d boneOffset1;
        if (currentSkeleton!=null) {
            actionLoc = currentSkeleton.getLoc();
            actionQuatRev = currentSkeleton.getQuat();
            actionQuatRev.conjugate();
            actionScale = currentSkeleton.getScale();
            boneOffset1 = currentSkeleton.getOffset(bn);
        } else {
            actionLoc = new Vector3d();
            actionQuatRev = new Quat4d(0.0,0.0,0.0,1.0);
            actionScale = 1.0;
            boneOffset1 = new Vector3d();
        }
        for (P p:currentAction.getP()) {
            if (p.getName().equals(bn)) {
                CenteredVRML vrml = vrmls.get(bn);
                Vector3d v = vrml.getLoc2();
                v = Util.trans(actionQuatRev,v);
                v.sub(actionLoc);
                v.scale(1.0/actionScale);
                if (boneOffset1!=null)
                    v.sub(boneOffset1);
                String s = ""+v.x+" "+v.y+" "+v.z;
                p.setOffset(s);
                Quat4d boneQuat = vrml.getQuat();
                boneQuat.mul(actionQuatRev);
                v = Util.quat2euler(boneQuat);
                s = ""+180.0*v.x/Math.PI+" "+180.0*v.y/Math.PI+" "+180.0*v.z/Math.PI;
                p.setRot(s);
                p.setScale(vrml.getScale()/actionScale);
            }
        }
    }
    void saveCatalog() {
        try {
            editor.catalog.save();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
