package jp.sourceforge.acerola3d.a3applet;

import java.awt.datatransfer.*;
import java.io.*;
import java.util.List;
import javax.swing.*;

public class A3TransferHandler extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private A3Panel panel;

    public A3TransferHandler(A3Panel panel) {
        this.panel = panel;
    }

    public boolean canImport(TransferSupport support) {
        // クリップボード経由のデータ転送は扱わない
        if (!support.isDrop()) {
            return false;
        }

        // ファイル以外のフレーバーは受け入れない
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }

        // ドロップする位置を常に表示する
        support.setShowDropLocation(true);

        return true;
    }

    public int getSourceActions(JComponent c) {
        return COPY_OR_MOVE;
    }

    @SuppressWarnings("unchecked")
    public boolean importData(TransferSupport support) {
        if (!canImport(support)) {
            return false;
        }

        try {
            Object obj = support.getTransferable()
                .getTransferData(DataFlavor.javaFileListFlavor);
            File file = ((List<File>)obj).get(0);

            if (file!=null) {
                panel.loadAction3D(file);
            }

            return true;
        } catch (UnsupportedFlavorException ex) {
            // 失敗したら false を返すだけ
        } catch (Exception ex) {
            // 失敗したら false を返すだけ
        }

        return false;
    }
}
