/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

class SubCameraBehavior
extends Behavior {
    TransformGroup tg;
    Transform3D t = new Transform3D();
    Vector3d cameraNowV = new Vector3d();
    Vector3d cameraNextV = new Vector3d();
    Quat4d cameraNowQ = new Quat4d();
    Quat4d cameraNextQ = new Quat4d();
    double cameraNowS = 1.0;
    double cameraNextS = 1.0;
    Vector3d cameraDefaultV = new Vector3d();
    Quat4d cameraDefaultQ = new Quat4d();
    double cameraDefaultS = 1.0;

    SubCameraBehavior(TransformGroup tg) {
        this.tg = tg;
    }

    public void initialize() {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(null, 1);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        WakeupOnBehaviorPost w = new WakeupOnBehaviorPost(null, 1);
        this.wakeupOn((WakeupCondition)w);
        this.cameraNowS += 0.2 * (this.cameraNextS - this.cameraNowS);
        this.cameraNowQ.normalize();
        this.cameraNowQ.interpolate(this.cameraNextQ, 0.2);
        this.cameraNowQ.normalize();
        this.cameraNowV.interpolate((Tuple3d)this.cameraNextV, 0.2);
        this.t.set(this.cameraNowQ, this.cameraNowV, this.cameraNowS);
        this.tg.setTransform(this.t);
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.cameraDefaultV.set(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.cameraDefaultV.set((Tuple3d)loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.cameraDefaultQ.set(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.cameraDefaultQ.set((Tuple4d)quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.cameraDefaultQ.set((Tuple4d)this.rot2quat(x, y, z));
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.cameraDefaultQ.set((Tuple4d)this.rot2quat(rot));
    }

    public void setDefaultCameraScale(double s) {
        this.cameraDefaultS = s;
    }

    public void resetCamera() {
        this.cameraNowV.set((Tuple3d)this.cameraDefaultV);
        this.cameraNextV.set((Tuple3d)this.cameraDefaultV);
        this.cameraNowQ.set((Tuple4d)this.cameraDefaultQ);
        this.cameraNextQ.set((Tuple4d)this.cameraDefaultQ);
        this.cameraNowS = this.cameraDefaultS;
        this.cameraNextS = this.cameraDefaultS;
    }

    public void setCameraLoc(double x, double y, double z) {
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.cameraNowV.set(x, y, z);
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.cameraNowV.set((Tuple3d)loc);
        this.cameraNextV.set((Tuple3d)loc);
    }

    public Vector3d getCameraLoc() {
        return new Vector3d(this.cameraNowV);
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNowQ.set(x, y, z, w);
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.cameraNowQ.set((Tuple4d)quat);
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public Quat4d getCameraQuat() {
        return new Quat4d(this.cameraNowQ);
    }

    public void setCameraRot(double x, double y, double z) {
        this.cameraNextQ.set((Tuple4d)this.rot2quat(x, y, z));
    }

    public void setCameraRot(Vector3d rot) {
        this.cameraNextQ.set((Tuple4d)this.rot2quat(rot));
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.cameraNowQ.set((Tuple4d)this.rot2quat(x, y, z));
        this.cameraNextQ.set((Tuple4d)this.rot2quat(x, y, z));
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.cameraNowQ.set((Tuple4d)this.rot2quat(rot));
        this.cameraNextQ.set((Tuple4d)this.rot2quat(rot));
    }

    public void setCameraScale(double s) {
        this.cameraNextS = s;
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraNowS = s;
        this.cameraNextS = s;
    }

    public double getCameraScale() {
        return this.cameraNowS;
    }

    public void setCameraLookAtPoint(Vector3d lookAt, Vector3d up) {
        Vector3d newFront = new Vector3d(this.cameraNowV);
        newFront.sub((Tuple3d)lookAt);
        newFront.normalize();
        if (Math.abs(newFront.x) < 1.0E-4 && newFront.z < 0.0) {
            newFront.x = 1.0E-4;
            newFront.normalize();
        }
        double d = newFront.dot(up);
        Vector3d vTmp = new Vector3d(newFront);
        vTmp.scale(d);
        Vector3d newTop = new Vector3d(up);
        newTop.sub((Tuple3d)vTmp);
        if (newTop.lengthSquared() < 1.0E-5) {
            newFront.set(0.0, 0.0, 1.0);
            newTop.set(0.0, 1.0, 0.0);
        } else {
            newTop.normalize();
        }
        Vector3d newRight = new Vector3d();
        newRight.cross(newFront, newTop);
        Matrix4d m = new Matrix4d();
        m.m00 = -newRight.x;
        m.m01 = newTop.x;
        m.m02 = newFront.x;
        m.m10 = -newRight.y;
        m.m11 = newTop.y;
        m.m12 = newFront.y;
        m.m20 = -newRight.z;
        m.m21 = newTop.z;
        m.m22 = newFront.z;
        m.get(this.cameraNextQ);
    }

    public void setCameraLookAtPointImmediately(Vector3d lookAt, Vector3d up) {
        this.setCameraLookAtPoint(lookAt, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    public void setCameraLookAtPoint(double x, double y, double z, Vector3d up) {
        Vector3d lookAt = new Vector3d(x, y, z);
        this.setCameraLookAtPoint(lookAt, up);
    }

    public void setCameraLookAtPointImmediately(double x, double y, double z, Vector3d up) {
        this.setCameraLookAtPoint(x, y, z, up);
        this.cameraNowQ.set((Tuple4d)this.cameraNextQ);
    }

    Quat4d rot2quat(double x, double y, double z) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotY(y);
        t0.mul(t1);
        t1.rotX(x);
        t0.mul(t1);
        t1.rotZ(z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    Quat4d rot2quat(Vector3d rot) {
        return this.rot2quat(rot.x, rot.y, rot.z);
    }
}

