package jp.sourceforge.acerola3d.a3;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.media.j3d.*;
import org.jdesktop.j3d.loaders.vrml97.VrmlLoader;
import javax.vecmath.*;


import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
//import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import com.sun.j3d.loaders.Scene;

import javax.xml.xpath.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import jp.sourceforge.acerola3d.a3.bvh.*;

import jp.sourceforge.acerola3d.a3.catalog.*;
import javax.xml.bind.*;

/**
 * ファイルから読み込んだデータを再利用可能な形で保存しておく
 * ためのデータ構造。さらに、このデータはコピー可能であり、
 * 編集可能なようにする。(現在まだ、未整理)
 */
class Action3DData {
    static VrmlLoader loader = null;
    static boolean isInitialized = false;

    static void initAction3DData() {
        if (isInitialized==true)
            return;
        try {
            loader = new VrmlLoader();
            //j3d-vrml97-0.1.0のAPIによればVrmlLoaderのコンストラクタの引数は
            //さしあたり無視されるということらしい．
            //loader = new VrmlLoader(VrmlLoader.LOAD_VIEW_GROUPS|
            //                        VrmlLoader.LOAD_SOUND_NODES|
            //                        VrmlLoader.LOAD_LIGHT_NODES|
            //                        VrmlLoader.LOAD_FOG_NODES);
        } catch(Exception e) {
            System.out.println("Action3DData.initAction3DData(). gaha!");
            e.printStackTrace();
        }
        isInitialized = true;
    }

    URL url;
    String comment;
    int haltActionNo = 0;
    int walkActionNo = 0;
    int runActionNo = 0;
    double minWalkSpeed = 0.1;
    double minRunSpeed = 1.0;
    boolean autoActionControl = false;

    Action actions[];
    String actionNames[];
    HashMap<String,SharedGroup> shapes;
    HashMap<String,Motion> motions;
    HashMap<String,MediaContainer> sounds;
    BranchGroup allActionBranchGroup;
    //Switch allActionSwitch;

    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0,0.0,0.0),Double.MAX_VALUE);
    //アクションの中のパーツのデータを保存しておくためのクラス
    class Part {
        String fileName;
        double scale = 1.0;
        double[] offsetXYZ;
        double[] rotationXYZ;
    }
    //アクションデータを保存しておくためのクラス
    class Action {
        int actionNo;
        String actionName;
        boolean loopFlag;
        String bvhFile;
        String soundFile;
        boolean soundLoop;
        String soundType = "PointSound";
        float soundGain = 1.0f;
        float soundOffsetXYZ[] = {0.0f,0.0f,0.0f};
        Sound sound;
        double scale;
        double[] offsetXYZ;
        double[] rotationXYZ;
        HashMap<String,Part> pHash;

        Group rootGroup;
        ActionBehavior behavior;
        Motion motion;
        HashMap<String,TransformGroup> tgMap;


        Action copy() {
            Action ret = new Action();
            ret.actionNo = actionNo;
            ret.actionName = actionName;
            ret.loopFlag = loopFlag;
            ret.bvhFile = bvhFile;
            ret.soundFile = soundFile;
            ret.soundLoop = soundLoop;
            ret.soundType = soundType;
            ret.soundGain = soundGain;
            ret.soundOffsetXYZ = soundOffsetXYZ.clone();
            ret.scale = scale;
            ret.rotationXYZ = (rotationXYZ==null)?null:rotationXYZ.clone();
            ret.offsetXYZ = (offsetXYZ==null)?null:offsetXYZ.clone();
            ret.pHash = new HashMap<String,Part>(pHash);
            ret.motion = motion;

            return ret;
        }

        void construct3DNode(Action3D a3) {
            tgMap = new HashMap<String,TransformGroup>();

            rootGroup = new BranchGroup();
            rootGroup.setCapability(BranchGroup.ALLOW_DETACH);
            TransformGroup tg = new TransformGroup();
            tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            tg.setCapability(BranchGroup.ALLOW_DETACH);
            TransformGroup tg0 = null;
            if ((rotationXYZ==null)&&(offsetXYZ==null)&&(scale==1.0)) {
                tg0=null;
            } else {
                Transform3D t0a = new Transform3D();
                Transform3D t0b = new Transform3D();
                if (rotationXYZ!=null) {
                    t0a.rotX(rotationXYZ[0]/180.0*2.0*Math.PI);
                    t0b.rotY(rotationXYZ[1]/180.0*2.0*Math.PI);
                    t0a.mul(t0b);
                    t0b.rotZ(rotationXYZ[2]/180.0*2.0*Math.PI);
                    t0a.mul(t0b);
                }
                t0b.set(Transform3D.IDENTITY);
                t0b.setScale(scale);//gaha
                if (offsetXYZ!=null)
                    t0b.setTranslation(new Vector3d(offsetXYZ[0],offsetXYZ[1],offsetXYZ[2]));
                t0a.mul(t0b);
                tg0 = new TransformGroup(t0a);
                tg0.addChild(tg);
            }
            if (tg0!=null)
                rootGroup.addChild(tg0);
            else
                rootGroup.addChild(tg);
            motion = motions.get(bvhFile);
            String rootBoneName = motion.getRootBone();
            Part p = pHash.get(rootBoneName);
            if (p!=null) {
                Node n = null;
                if ((p.rotationXYZ==null)&&(p.offsetXYZ==null)&&(p.scale==1.0)) {
                    n = new Link(shapes.get(p.fileName));
                } else {
                    Transform3D t9a = new Transform3D();
                    Transform3D t9b = new Transform3D();
                    t9a.set(Transform3D.IDENTITY);
                    t9b.set(Transform3D.IDENTITY);
                    if (p.rotationXYZ!=null) {
                        t9a.rotX(p.rotationXYZ[0]/180.0*Math.PI);
                        t9b.rotY(p.rotationXYZ[1]/180.0*Math.PI);
                        t9a.mul(t9b);
                        t9b.rotZ(p.rotationXYZ[2]/180.0*Math.PI);
                        t9a.mul(t9b);
                    }
                    t9b.set(Transform3D.IDENTITY);
                    t9b.setScale(p.scale);
                    t9a.mul(t9b);
                    if (p.offsetXYZ!=null) {
                        t9b.set(Transform3D.IDENTITY);
                        t9b.setTranslation(new Vector3d(p.offsetXYZ[0],p.offsetXYZ[1],p.offsetXYZ[2]));
                        t9a.mul(t9b);
                    }
                    TransformGroup tg9 = new TransformGroup(t9a);
                    tg9.addChild(new Link(shapes.get(p.fileName)));
                    n = tg9;
                }
                tg.addChild(n);
            }
            tgMap.put(rootBoneName,tg);
            construct(tg,rootBoneName,tgMap);

            if (soundFile!=null) {
                MediaContainer mc = sounds.get(soundFile);
                if (soundType.equals("BackgroundSound")) {
                    sound = new BackgroundSound(mc,soundGain);
                } else {
                    sound = new PointSound(mc,soundGain,
                                           soundOffsetXYZ[0],
                                           soundOffsetXYZ[1],
                                           soundOffsetXYZ[2]);
                }
                sound.setEnable(false);
                sound.setPause(false);
                if (soundLoop)
                    sound.setLoop(-1);
                else
                    sound.setLoop(0);
                //sound.setContinuousEnable(true);
                sound.setSchedulingBounds(bounding);
                sound.setCapability(Sound.ALLOW_ENABLE_WRITE);
                //sound.setCapability(Sound.ALLOW_PAUSE_WRITE);
                SharedGroup sg = new SharedGroup();
                sg.addChild(sound);
                Link ll = new Link(sg);
                rootGroup.addChild(ll);
            }
        }

        void construct(Group parent,String parentName,HashMap<String,TransformGroup> tgMap) {
            String children[] = motion.getChildBones(parentName);
            for (int i=0;i<children.length;i++) {
                TransformGroup tg = new TransformGroup();
                tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                parent.addChild(tg);
                Part p = pHash.get(children[i]);
                if (p!=null) {
                    if ((p.rotationXYZ==null)&&(p.offsetXYZ==null)&&(p.scale==1.0)) {
                        tg.addChild(new Link(shapes.get(p.fileName)));
                    } else {
                        Transform3D t9a = new Transform3D();
                        Transform3D t9b = new Transform3D();
                        t9a.set(Transform3D.IDENTITY);
                        t9b.set(Transform3D.IDENTITY);
                        if (p.rotationXYZ!=null) {
                            t9a.rotX(p.rotationXYZ[0]/180.0*Math.PI);
                            t9b.rotY(p.rotationXYZ[1]/180.0*Math.PI);
                            t9a.mul(t9b);
                            t9b.rotZ(p.rotationXYZ[2]/180.0*Math.PI);
                            t9a.mul(t9b);
                        }
                        t9b.set(Transform3D.IDENTITY);
                        t9b.setScale(p.scale);
                        t9a.mul(t9b);
                        if (p.offsetXYZ!=null) {
                            t9b.set(Transform3D.IDENTITY);
                            t9b.setTranslation(new Vector3d(p.offsetXYZ[0],p.offsetXYZ[1],p.offsetXYZ[2]));
                            t9a.mul(t9b);
                        }
                        TransformGroup tg9 = new TransformGroup(t9a);
                        tg9.addChild(new Link(shapes.get(p.fileName)));
                        tg.addChild(tg9);
                    }
                }
                tgMap.put(children[i],tg);
                construct(tg,children[i],tgMap);
            }
        }

        Group getRootGroup() {
            return rootGroup;
        }

        void start() {
            if (sound!=null) {
                sound.setEnable(true);
                //sound.setPause(false);
            }
        }

        void stop() {
            if (sound!=null) {
                sound.setEnable(false);
                //sound.setPause(true);
            }
        }

        boolean isStoped() {
            return behavior.isStoped();
        }

        double getMotionLength() {
            return motion.getMotionLength();
        }

        void setMode(Motion.Mode m) {
            behavior.setMode(m);
        }

        void setPauseTime(double t) {
            behavior.setPauseTime(t);
        }
    }

    Action3DData() {
    }

    Action3DData(String urlString) throws Exception {
        url = new URL(urlString);
        init(url);
    }
    Action3DData(URL url) throws Exception {
        init(url);
    }

    void init(URL url) throws Exception {
        this.url = url;
        loadCatalog();
        loadAllShapes();
        loadAllMotions();
        loadAllSounds();
    }

    //cloneのような浅いコピーじゃなくて，かといって深い
    //コピーでもなく，その中間のコピー．つまり，変更されない
    //shapes,motions,soundsの中身だけ浅いコピーをするってこと．
    public Action3DData copy() {
        Action3DData ret = new Action3DData();

        ret.url = url;
        ret.comment = comment;
        ret.actionNames = actionNames.clone();
        ret.haltActionNo = haltActionNo;
        ret.walkActionNo = walkActionNo;
        ret.runActionNo = runActionNo;
        ret.minWalkSpeed = minWalkSpeed;
        ret.minRunSpeed = minRunSpeed;
        ret.autoActionControl = autoActionControl;

        ret.actions = new Action[actions.length];
        for (int i=0;i<actions.length;i++) {
            ret.actions[i] = actions[i].copy();
        }
        ret.shapes = new HashMap<String,SharedGroup>(shapes);
        ret.motions = new HashMap<String,Motion>(motions);
        ret.sounds = new HashMap<String,MediaContainer>(sounds);
        return ret;
    }

    void loadCatalog() throws Exception {
        loadCatalog_NEW();
        //loadCatalog_OLD();
    }
    void loadCatalog_NEW() throws Exception {
        JAXBContext jc = JAXBContext.newInstance("jp.sourceforge.acerola3d.a3.catalog");
        Unmarshaller u = jc.createUnmarshaller();
        A3 a3 = null;
        try {
            URL cURL = new URL("x-rzip:"+url.toString()+"!/CATALOG.XML");
            a3 = (A3)u.unmarshal(cURL.openStream());
        } catch(Exception e) {
            e.printStackTrace();
            try {
                URL cURL = new URL("x-rzip:"+url.toString()+"!/catalog.xml");
                a3 = (A3)u.unmarshal(cURL.openStream());
            } catch(Exception ee) {
                throw ee;
            }
        }
        haltActionNo = a3.getHaltActionNo().intValue();
        walkActionNo = a3.getWalkActionNo().intValue();
        runActionNo = a3.getRunActionNo().intValue();
        minWalkSpeed = a3.getMinWalkSpeed();
        minRunSpeed = a3.getMinRunSpeed();
        comment = a3.getC();
        actions = new Action[a3.getA().size()];
        actionNames = new String[a3.getA().size()];
        int i=0;
        for (A aNode : a3.getA()) {
            Action a = new Action();
            a.actionNo = i;
            a.actionName = aNode.getAn();
            actions[i] = a;
            actionNames[i] = a.actionName;
            a.loopFlag = aNode.isLoop();
            a.bvhFile = aNode.getBvh();
            a.scale = aNode.getScale();
            a.rotationXYZ = makeDouble3(aNode.getRot());
            a.offsetXYZ = makeDouble3(aNode.getOffset());
            a.pHash = new HashMap<String,Part>();
            for (P pNode : aNode.getP()) {
                Part p = new Part();
                String partName = pNode.getName().trim();
                p.fileName = pNode.getWrl().trim();
                p.scale = pNode.getScale();
                p.offsetXYZ = makeDouble3(pNode.getOffset());
                p.rotationXYZ = makeDouble3(pNode.getRot());
                a.pHash.put(partName,p);
            }
            S s = aNode.getS();
            if (s!=null) {
                a.soundFile = s.getFile();
                a.soundLoop = s.isLoop();
                if (s.getType()==SoundType.POINT_SOUND)
                    a.soundType = "PointSound";
                else if (s.getType()==SoundType.BACKGROUND_SOUND)
                    a.soundType = "BackgroundSound";
                else if (s.getType()==SoundType.CONE_SOUND)
                    a.soundType = "ConeSound";
                a.soundGain = (float)s.getGain();
                a.soundOffsetXYZ = makeFloat3(s.getOffset());
            }
            i++;
        }
    }
    double[] makeDouble3(String s) {
        if (s.equals("0.0 0.0 0.0"))
            return null;
        double ret[] = new double[3];
        StringTokenizer st = new StringTokenizer(s);
        int i=0;
        while (st.hasMoreTokens()) {
            ret[i] = Double.parseDouble(st.nextToken());
            i++;
        }
        return ret;
    }
    float[] makeFloat3(String s) {
        //if (s.equals("0.0 0.0 0.0"))
        //    return null;
        float ret[] = new float[3];
        StringTokenizer st = new StringTokenizer(s);
        int i=0;
        while (st.hasMoreTokens()) {
            ret[i] = Float.parseFloat(st.nextToken());
            i++;
        }
        return ret;
    }
    void loadCatalog_OLD() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = null;
        try {
            d = db.parse("x-rzip:"+url.toString()+"!/CATALOG.XML");
//            d = db.parse("jar:"+url.toString()+"!/CATALOG.XML");
        } catch(Exception e) {
            try {
                d = db.parse("x-rzip:"+url.toString()+"!/catalog.xml");
//                d = db.parse("jar:"+url.toString()+"!/catalog.xml");
            } catch (Exception ee) {
                throw ee;
            }
        }

        //a3の属性の処理
        org.w3c.dom.Node a3[] = xpath("/a3",d);
        NamedNodeMap nnm = a3[0].getAttributes();
        Attr attr = (Attr)nnm.getNamedItem("haltActionNo");
        if (attr!=null)
            haltActionNo = Integer.parseInt(attr.getValue().trim());
        attr = (Attr)nnm.getNamedItem("walkActionNo");
        if (attr!=null)
            walkActionNo = Integer.parseInt(attr.getValue().trim());
        attr = (Attr)nnm.getNamedItem("runActionNo");
        if (attr!=null)
            runActionNo = Integer.parseInt(attr.getValue().trim());
        attr = (Attr)nnm.getNamedItem("minWalkSpeed");
        if (attr!=null)
            minWalkSpeed = Double.parseDouble(attr.getValue().trim());
        attr = (Attr)nnm.getNamedItem("minRunSpeed");
        if (attr!=null)
            minRunSpeed = Double.parseDouble(attr.getValue().trim());
        attr = (Attr)nnm.getNamedItem("autoActionControl");
        if (attr!=null)
            autoActionControl = Boolean.parseBoolean(attr.getValue().trim());
        
        //コメントデータゲット
        org.w3c.dom.Node cc[] = xpath("/a3/c/text()",d);
        if (cc.length!=0)
            comment = ((Text)cc[0]).getData();
        else
            comment = "";

        //全<a>タグ(アクション情報)ゲット
        org.w3c.dom.Node a_nodes[] = xpath("/a3/a",d);
        actions = new Action[a_nodes.length];
        actionNames = new String[a_nodes.length];
        //1アクションごとにループ
        for (int i=0;i<a_nodes.length;i++) {
            Action a = new Action();
            a.actionNo = i;
            nnm = a_nodes[i].getAttributes();
            //以下<a>タグの属性の処理
            attr = (Attr)nnm.getNamedItem("an");
            a.actionName = attr.getValue().trim();
            actions[i] = a;
            actionNames[i] = a.actionName;
            attr = (Attr)nnm.getNamedItem("loop");
            if (attr!=null) {
                Boolean bbb = Boolean.valueOf(attr.getValue());
                a.loopFlag = bbb.booleanValue();
            } else {
                a.loopFlag = false;
            }
            attr = (Attr)nnm.getNamedItem("bvh");
            a.bvhFile = attr.getValue().trim();
            attr = (Attr)nnm.getNamedItem("scale");
            if (attr != null)
                a.scale = Double.parseDouble(attr.getValue());
            else
                a.scale = 1.0;
            attr = (Attr)nnm.getNamedItem("rot");
            if (attr != null) {
                a.rotationXYZ = new double[3];
                StringTokenizer st = new StringTokenizer(attr.getValue());
                int ii=0;
                while (st.hasMoreTokens()) {
                    a.rotationXYZ[ii] = Double.parseDouble(st.nextToken());
                    ii++;
                }
            }
            attr = (Attr)nnm.getNamedItem("offset");
            if (attr != null) {
                a.offsetXYZ = new double[3];
                StringTokenizer st = new StringTokenizer(attr.getValue());
                int ii=0;
                while (st.hasMoreTokens()) {
                    a.offsetXYZ[ii] = Double.parseDouble(st.nextToken());
                    ii++;
                }
            }
            a.pHash = new HashMap<String,Part>();
            org.w3c.dom.Node p_nodes[] = xpath("/a3/a[position()="+(i+1)+"]/p",d);
            for (int j=0;j<p_nodes.length;j++) {
                Part p = new Part();
                nnm = p_nodes[j].getAttributes();
                attr = (Attr)nnm.getNamedItem("name");
                String partName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("wrl");
                p.fileName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("scale");
                if (attr!=null)
                    p.scale = Double.parseDouble(attr.getValue().trim());
                attr = (Attr)nnm.getNamedItem("offset");
                if (attr!=null) {
                    p.offsetXYZ = new double[3];
                    StringTokenizer st = new StringTokenizer(attr.getValue());
                    int ii = 0;
                    while (st.hasMoreTokens()) {
                        p.offsetXYZ[ii] = Double.parseDouble(st.nextToken());
                        ii++;
                    }
                }
                attr = (Attr)nnm.getNamedItem("rot");
                if (attr!=null) {
                    p.rotationXYZ = new double[3];
                    StringTokenizer st = new StringTokenizer(attr.getValue());
                    int ii = 0;
                    while (st.hasMoreTokens()) {
                        p.rotationXYZ[ii] = Double.parseDouble(st.nextToken());
                        ii++;
                    }
                }
                a.pHash.put(partName,p);
            }
            org.w3c.dom.Node s_nodes[] = xpath("/a3/a[position()="+(i+1)+"]/s",d);
            if ((s_nodes != null)&&(s_nodes.length!=0)) {
                nnm = s_nodes[0].getAttributes();
                attr = (Attr)nnm.getNamedItem("file");
                a.soundFile = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("loop");
                if (attr!=null)
                    a.soundLoop = Boolean.parseBoolean(attr.getValue().trim());
                attr = (Attr)nnm.getNamedItem("type");
                if (attr!=null)
                    a.soundType = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("gain");
                if (attr!=null)
                    a.soundGain = Float.parseFloat(attr.getValue().trim());
                attr = (Attr)nnm.getNamedItem("offset");
                if (attr!=null) {
                    StringTokenizer st = new StringTokenizer(attr.getValue());
                    int ii = 0;
                    while (st.hasMoreTokens()) {
                        a.soundOffsetXYZ[ii] = Float.parseFloat(st.nextToken());
                        ii++;
                    }
                }
            }
        }
    }

    //xpathでNodeを抽出するためのメソッド．でも手抜き．
    //queryによってはNode[]にならないので，その時はバグる．
    static org.w3c.dom.Node[] xpath(String query,Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);

            org.w3c.dom.Node ret[] = new org.w3c.dom.Node[nl.getLength()];
            for (int i=0;i<nl.getLength();i++) {
                ret[i] = nl.item(i);
            }
            return ret;
        } catch (XPathExpressionException e) {
            return null;
        }
    }

    void loadAllShapes() throws Exception {
        HashSet<Part> s = new HashSet<Part>();
        for (int i=0;i<actions.length;i++)
            s.addAll(actions[i].pHash.values());
        shapes = new HashMap<String,SharedGroup>();
        for (Part p : s) {
            URL wrlURL = new URL("x-rzip:"+url.toString()+"!/"+p.fileName);
            SharedGroup sg = new SharedGroup();
            Transform3D t = new Transform3D();
            //このにp.scale,offset,rotの処理を書く
            TransformGroup tg = new TransformGroup(t);
            Scene scene = loader.load(wrlURL);
            //以下背景と霧を読み込むためのハックなのだが、
            //SharedGroupには追加できないのでだめだった。
            //Background[] bs = scene.getBackgroundNodes();
            //for (int i=0;i<bs.length;i++)
            //    tg.addChild(bs[i].cloneNode(false));
            //Fog fogs[] = scene.getFogNodes();
            //for (int i=0;i<fogs.length;i++)
            //    tg.addChild(fogs[i].cloneNode(false));
            tg.addChild(scene.getSceneGroup());
            sg.addChild(tg);
            //sg.compile();
            shapes.put(p.fileName,sg);
        }
    }

    void loadAllMotions() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i=0;i<actions.length;i++)
            if (actions[i].bvhFile!=null)
                s.add(actions[i].bvhFile);
        motions = new HashMap<String,Motion>();
        for (String filename : s) {
            URL motionURL = new URL("x-rzip:"+url.toString()+"!/"+filename);
            BVH bvh = new BVH(motionURL);
            motions.put(filename,bvh);
        }
    }

    void loadAllSounds() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i=0;i<actions.length;i++)
            if (actions[i].soundFile!=null)
                s.add(actions[i].soundFile);
        sounds = new HashMap<String,MediaContainer>();
        for (String filename : s) {
            URL soundURL = new URL("x-rzip:"+url.toString()+"!/"+filename);
            MediaContainer mc = new MediaContainer(soundURL);
            sounds.put(filename,mc);
        }
    }

//------------------------------------------------------------

    void construct3DNode(Action3D a3) {
        for (int i=0;i<actions.length;i++)
            actions[i].construct3DNode(a3);

        allActionBranchGroup = new BranchGroup();
        allActionBranchGroup.setCapability(BranchGroup.ALLOW_DETACH);
        allActionBranchGroup.setCapability(Group.ALLOW_CHILDREN_WRITE);  // <- Action3DでSwitchを使う場合には不要
        allActionBranchGroup.setCapability(Group.ALLOW_CHILDREN_EXTEND); // <- Action3DでSwitchを使う場合には不要

        //allActionSwitch = new Switch();
        ////allActionSwitch.setCapability(Switch.ALLOW_PICKABLE_WRITE);
        //allActionSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);
        //for (int i=0;i<actions.length;i++) {
        //    allActionSwitch.addChild(actions[i].rootGroup);
        //}
        allActionBranchGroup.addChild(actions[0].rootGroup);
        //allActionBranchGroup.addChild(allActionSwitch);
        //allActionSwitch.setWhichChild(0);
    }

//------------------------------------------------------------

    Node getNode() {
        allActionBranchGroup.detach();
        return allActionBranchGroup;
        //allActionSwitch.detach();
        //return allActionSwitch;
    }

    String getActionNameFromActionNo(int an) {
        return actionNames[an];
    }

    int getActionNoFromActionName(String an) {
        for (int i=0;i<actionNames.length;i++)
            if (actionNames[i].equals(an))
                return i;
        return -1;
    }

    int getActionCount() {
        return actions.length;
    }

    String[] getActionNames() {
        return (String[])actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = getActionNoFromActionName(actionName);
        return actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;//gaha
    }

    String getComment() {
        return comment;
    }

    int getFrameCount() {
        return actionNames.length;
    }

    void setMode(Motion.Mode m) {
        for (int i=0;i<actions.length;i++)
            actions[i].setMode(m);
    }

    void setAutoActionControl(boolean b) {
        autoActionControl = b;
    }
    boolean autoActionControl() {
        return autoActionControl;
    }

    void setHaltAction(int i) {
        haltActionNo = i;
    }
    void setHaltAction(Serializable s) {
        if (s instanceof String) {
            setHaltAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setHaltAction(((Integer)s).intValue());
        }
    }
    int getHaltActionNo() {
        return haltActionNo;
    }

    void setWalkAction(int i) {
        walkActionNo = i;
    }
    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            setWalkAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setWalkAction(((Integer)s).intValue());
        }
    }
    int getWalkActionNo() {
        return walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        minWalkSpeed = d;
    }
    double getMinWalkSpeed() {
        return minWalkSpeed;
    }

    void setRunAction(int i) {
        runActionNo = i;
    }
    void setRunAction(Serializable s) {
        if (s instanceof String) {
            setRunAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setRunAction(((Integer)s).intValue());
        }
    }
    int getRunActionNo() {
        return runActionNo;
    }

    void setMinRunSpeed(double d) {
        minRunSpeed = d;
    }
    double getMinRunSpeed() {
        return minRunSpeed;
    }
}
