package jp.sourceforge.acerola3d.a3;

import javax.vecmath.*;
import java.awt.*;

class A3Balloon implements Component2D {
    A3Object a3;
    String description = "none";
    double offsetX;
    double offsetY;
    double offsetZ;
    int width;
    int height;
    A3Balloon(String s,A3Object a3) {
        description = s;
        this.a3 = a3;
    }
    public void paint(Graphics2D g,A3CanvasInterface canvas) {
        Vector3d v = a3.getLoc();
        Point p = canvas.virtualCSToCanvas(new Point3d(v.x+offsetX,
                v.y+offsetY,v.z+offsetZ));

        int i0 = description.length();
        int i1 = i0/10;
        int i2 = i0%10;
        String desc[] = new String[i1+(i2==0?0:1)];
        for (int i=0;i<desc.length;i++) {
            int j0 = i*10;
            int j1 = i*10+10;
            j1 = j1>description.length()?description.length():j1;
            desc[i]=description.substring(j0,j1);
        }
        FontMetrics fm = g.getFontMetrics();
        width = fm.stringWidth("ww")*10+60;
        height = fm.getHeight()*desc.length+60;
        width  = width<50 ?50 :width;
        height = height<50?50:height;

        int x[] = {p.x       +0,p.x         +10,p.x         +10};
        int y[] = {p.y       +0,p.y         + 5,p.y          -5};
        g.setColor(Color.white);
        g.fillPolygon(x,y,3);
        g.fillRect(p.x+      10,p.y-height/2+10,width-60,height-20);
        g.fillRect(p.x+      20,p.y-height/2+ 0,width-80,height   );
        g.fillOval(p.x+      10,p.y-height/2+ 0,      20,       20);
        g.fillOval(p.x+width-70,p.y-height/2+ 0,      20,       20);
        g.fillOval(p.x+      10,p.y+height/2-20,      20,       20);
        g.fillOval(p.x+width-70,p.y+height/2-20,      20,       20);

        g.setColor(Color.black);
        for (int i=0;i<desc.length;i++) {
            g.drawString(desc[i],p.x+30,p.y+i*fm.getHeight()-height/2+20);
        }
    }
    public void setString(String s) {
        description = s;
    }
    public void setOffset(double x,double y,double z) {
        offsetX = x;
        offsetY = y;
        offsetZ = z;
    }
}
