import jp.sourceforge.acerola3d.a3.*;

public class A3FreezeTest {
    public static void main(String args[]) throws Exception {
        A3Window window = new A3Window(300,300);
        Action3D a3 = Action3D.load("x-res:///axis.a3");
        //Action3D a3 = Action3D.load("x-res:///dog_cat.a3");
        window.add(a3);
        double t = 0.0;
        int i = 0;
        for (;;) {
            a3.change(i%2);//---->(1)
            //a3.changeImmediately(i%2);//---->(2)
            //a3.setLoc(Math.sin(t),0.0,0.0);//---->(3)
            //a3.setLocImmediately(Math.sin(t),0.0,0.0);//---->(4)
            //a3.setQuat(Math.sin(t),0.0,0.0,Math.cos(t));//---->(5)
            //a3.setQuatImmediately(Math.sin(t),0.0,0.0,Math.cos(t));//---->(6)
            //window.setCameraLoc(Math.sin(t),0.0,3.0);//---->(7)
            //window.setCameraLocImmediately(Math.sin(t),0.0,3.0);//---->(8)
            //window.setCameraQuat(Math.sin(t),0.0,0.0,Math.cos(t));//---->(9)
            //window.setCameraQuatImmediately(Math.sin(t),0.0,0.0,Math.cos(t));//---->(10)
            //if ((i%2)==0) window.del(a3); else window.add(a3);//---->(11)
            //try{Thread.sleep(1000);}catch(Exception e){;}if ((i%2)==0) window.setVisible(false); else window.setVisible(true);//---->(12)
            i++;
            t = t+0.01;
            //System.out.print(".");System.out.flush();
        }
    }
}

/*
Eclipse上のantから実行してテストしてるけど、
Java Web Startで実行した時はまた違うのかもしれない。
再現性がない症状も多いし、かなり環境とかドライバに
依存した部分もありそうだけど、同じ症状のところも
ある。今のところとりあえず、まじめにスレッドセーフな
実装に直していってまた、様子を見るしかないかも。

環境1(Debian)
========================================

* 2008,01/20現在
* Linux(Debian etch)
* java6(build 1.6.0-b105)
* java3d-1.5.1-joal
* X11のドライバi810

* axis.a3で(1)の場合
  + ArrayIndexOutOfBoundsExceptionで止る．
    場所はAction3D.change(Action3D.java:178)
* dog_cat.a3で(1)の場合
  + ArrayIndexOutOfBoundsExceptionで止る．
    場所はAction3DData.change(Action3DData.java:485)
  + 何の予告もなくFreezeする．catの瞬間のFreezeなら
    音は出続ける．
* axis.a3で(10)の場合
  + BadTransformExceptionで止る．
    場所はA3Behavior.processStimulus(A3Behavior.java:38)

環境2(Windows)
========================================

* 2008,01/28現在
* WindowsXP
* java6(1.6.0_03)
* java3d-1.5.1-joal
* joal1.1.1

* axis.a3で(1)の場合
  + ArrayIndexOutOfBoundsExceptionで止る．
    場所はAction3D.change(Action3D.java:178)
* axis.a3で(2)の場合
  + ちょっともっさり
* axis.a3で(3)の場合
  + ちょっともっさり
* axis.a3で(4)の場合
  + ちょっともっさりしたあと、OutOfMemoryError
* axis.a3で(5)の場合
  + ちょっともっさり
* axis.a3で(6)の場合
  + ちょっともっさり
  + ガッツリFreezeすることもある
* axis.a3で(7)の場合
  + ちょっともっさり
* axis.a3で(8)の場合
  + ちょっともっさり
* axis.a3で(9)の場合
  + ちょっともっさり
* axis.a3で(10)の場合
  + ちょっともっさり
* axis.a3で(11)の場合
  + ちょっともっさり
* axis.a3で(12)の場合
  + 問題なし。
* dog_cat.a3で(1)の場合
  + 何の予告もなくFreezeする．catの瞬間のFreezeなら
    音は出続ける．
* dog_cat.a3で(2)の場合
  + 音は出ないけど、もっさりとchangeし続ける。

ちなみに、普通にやればJoalMixerは動いているが、
JavaWebStartだと音がでないようだ。

この環境でのテストでないけど、-Dj3d.rend=d3dを
つけて無理やりDirectXを使うと、changeの時に、
javax.media.j3d.GroupRetained.removeChild()で、
IndexOutOfBoundExceptionが出ることがあった。でも
再現性がない。

環境3(MacOSX)
========================================

このプログラムではJenaCheckで発生するFreezeを
再現できないっぽいなぁ．JenaCheckのFreezeは
JenaCheckだけでなく画面全体がフリーズする
のだけど…

* 2008,01/21現在
* MacOSX 10.4.11(PowerPC G5)
* java6(build 1.6.0-dp-b88-34)
* java3d-1.5.1-joal

* axis.a3で(1)の場合
  + ArrayIndexOutOfBoundsExceptionで止る．
    場所はAction3DData.change(Action3DData.java:485)
  + Windowが表示された瞬間にFreezeすることもある。
* axis.a3で(2)の場合
  + しばらくするとFreezeする．
  + VMごと落ることもある．Bus Errorと出る．
* axis.a3で(4)の場合
  + 長いこと動いてからVMが落ちた．Bus Errorと出る．
  + しばらくするとFreezeする．さらにしばらくすると
    OutOfMemoryError例外が発生．
* axis.a3で(11)の場合
  + しばらくするとFreezeする．さらにしばらくすると
    OutOfMemoryError例外が発生．
* dog_cat.a3で(1)の場合
  + 何の予告もなくFreezeする．catの瞬間のFreezeなら
    音は出続ける．
* dog_cat.a3で(2)の場合
  + かならず起動時にNullPointerExceptionが発生して止る．
    SoundScheduler.updateTransformedFieldsあたり．
* dog_cat.a3で(3,4)の場合
  + たまにVMごと落ちる．Bus Errorと出る．
* dog_cat.a3で(5)の場合
  + たまにVMごと落ちる．Bus Errorと出る．
  + 途中でFreezeすることもある．
* dog_cat.a3で(11)の場合
  + かならず起動時にNullPointerExceptionが発生して止る．
    SoundScheduler.updateTransformedFieldsあたり．
 */
