package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import java.util.*;

import javax.media.j3d.*;
import javax.vecmath.*;
/*
 * Action3DのためのBehavior。かなりのコードをこのBehavior
 * に移動して一括して管理することにした。スレッド関係のなんだかんだも、
 * このクラスで全て受け持つことにする。
 */
class ActionBehavior extends Behavior implements Cloneable {
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0,0.0,0.0),100.0);
    //  現在のアクションNO
    int actionNo = 0;
    boolean immediatelyFlag = false;
    int playCount;
    boolean loopFlag;
    ArrayList<Integer> actionQueue = new ArrayList<Integer>();
    static final int ACTION_QUEUE_SIZE = 3;
    Action3DData a3Data;
    BranchGroup allBranchGroup = null;
    
    long motionLength;
    int elapsedTime;
    Motion.Mode mode = Motion.Mode.PLAY;
    long timeOffset = 0;
    long pauseTime;
    Action3D a3;
    long previousTime;

    public ActionBehavior(Action3D action3d,Action3DData action3DData) {
        a3 = action3d;
        a3Data = action3DData;
        a3Data.construct3DNode(a3);
        
        actionNo = 0;
        Action3DData.Action action = a3Data.actions[actionNo];
        Motion motion = action.motion;
        motionLength = (long)(motion.getMotionLength()*1000.0);
        elapsedTime = (int)(1000.0*motion.getDefaultFrameTime());
        loopFlag = action.loopFlag;
        this.setSchedulingBounds(bounding);
        allBranchGroup = new BranchGroup();
        allBranchGroup.addChild(a3Data.getNode());
        allBranchGroup.addChild(this);
    }
    void init() {
        synchronized (actionQueue) {
            //gaha;
            actionNo = actionQueue.remove(0);
            //a3Data.allActionSwitch.setWhichChild(actionNo);
            Node n = a3Data.actions[actionNo].getRootGroup();
            a3Data.allActionBranchGroup.removeAllChildren();
            a3Data.allActionBranchGroup.addChild(n);
            a3Data.actions[actionNo].start();
        }
    }
    public void initialize() {
        if (elapsedTime==0) //<-- なんでこれが必要なのか
            return;         //<-- わからない
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        wakeupOn(w);
        timeOffset = System.currentTimeMillis();
        previousTime = -1;
    }
    @SuppressWarnings("unchecked")
    public void processStimulus(Enumeration criteria) {
        synchronized (actionQueue) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            wakeupOn(w);

            //autoActionControlの処理
            if (a3Data.autoActionControl==true) {
                double ls = a3.getSpeed();
                if (ls>0.001) {
                    int i = -1;
                    if (ls <= a3Data.getMinWalkSpeed()) {
                        i = a3Data.getHaltActionNo();
                    } else if (ls>a3Data.getMinWalkSpeed()&&ls<a3Data.getMinRunSpeed()) {
                        i = a3Data.getWalkActionNo();
                    } else {
                        i = a3Data.getRunActionNo();
                    }
                    if (actionQueue.size()<ACTION_QUEUE_SIZE)
                        actionQueue.add(i);
                    else
                        actionQueue.set(ACTION_QUEUE_SIZE-1,i);
                }
            }
            //アクション切り替えの処理
            if (immediatelyFlag==true) {
                if (actionQueue.size()>0) {
                    a3Data.actions[actionNo].stop();
                    actionNo = actionQueue.remove(0);
                    //a3Data.allActionSwitch.setWhichChild(actionNo);
                    Node n = a3Data.actions[actionNo].getRootGroup();
                    a3Data.allActionBranchGroup.removeAllChildren();
                    a3Data.allActionBranchGroup.addChild(n);
                    a3Data.actions[actionNo].start();
                    immediatelyFlag = false;
                    timeOffset = System.currentTimeMillis();
                    previousTime = -1;
                    loopFlag = a3Data.actions[actionNo].loopFlag;
                    motionLength = (long)(a3Data.actions[actionNo].getMotionLength()*1000.0);
                    elapsedTime = (int)(a3Data.actions[actionNo].motion.getDefaultFrameTime()*1000.0);
                }
            } else {
                if ((playCount>=1)&&(actionQueue.size()>0)) {
                    a3Data.actions[actionNo].stop();
                    actionNo = actionQueue.remove(0);
                    //a3Data.allActionSwitch.setWhichChild(actionNo);
                    Node n = a3Data.actions[actionNo].getRootGroup();
                    a3Data.allActionBranchGroup.removeAllChildren();
                    a3Data.allActionBranchGroup.addChild(n);
                    a3Data.actions[actionNo].start();
                    timeOffset = System.currentTimeMillis();
                    previousTime = -1;
                    loopFlag = a3Data.actions[actionNo].loopFlag;
                    motionLength = (long)(a3Data.actions[actionNo].getMotionLength()*1000.0);
                    elapsedTime = (int)(a3Data.actions[actionNo].motion.getDefaultFrameTime()*1000.0);
                }
            }
            long time;
            long nowTime = System.currentTimeMillis();
            if (mode == Motion.Mode.PLAY) {
                time = nowTime - timeOffset;
            } else {
                time = pauseTime;
            }
            playCount = (int)(time/motionLength);
            if ((loopFlag==false)&&(playCount>0)) {
                if (previousTime>=motionLength-1)
                    return;
                else
                    time = motionLength-1;
            }
            previousTime = time;
            time = time % motionLength;
            double timeD = ((double)time)/1000.0;
            Action3DData.Action a = a3Data.actions[actionNo];
            for (String boneName : a.tgMap.keySet()) {
                TransformGroup tg = a.tgMap.get(boneName);
                Transform3D t = a.motion.getTransform3D(boneName,timeD);
                tg.setTransform(t);
            }
        }
    }

    void initAction(int initActionNo) {
        synchronized (actionQueue) {
            //gaha?
            if ((initActionNo<0)||(initActionNo>=a3Data.actions.length))
                initActionNo=0;
            actionQueue.clear();
            actionQueue.add(initActionNo);
        }
    }
    void initAction(Serializable s) {
        if (s instanceof Integer)
            initAction(((Integer)s).intValue());
        if (s instanceof String)
            initAction(a3Data.getActionNoFromActionName((String)s));
    }
    void change(int newActionNo) {
        synchronized (actionQueue) {
            //gaha?
            if ((newActionNo<0)||(newActionNo>=a3Data.actions.length))
                return;
            if (actionQueue.size()<ACTION_QUEUE_SIZE)
                actionQueue.add(newActionNo);
            else
                actionQueue.set(ACTION_QUEUE_SIZE-1,newActionNo);
        }
    }
    void change(Serializable s) {
        if (s instanceof Integer)
            change(((Integer)s).intValue());
        if (s instanceof String)
            change(a3Data.getActionNoFromActionName((String)s));
    }
    void changeImmediately(int newActionNo) {
        synchronized (actionQueue) {
            //gaha?
            if ((newActionNo<0)||(newActionNo>=a3Data.actions.length))
                return;
            actionQueue.clear();
            actionQueue.add(newActionNo);
            immediatelyFlag = true;
        }
    }
    void changeImmediately(Serializable s) {
        if (s instanceof Integer)
            changeImmediately(((Integer)s).intValue());
        if (s instanceof String)
            changeImmediately(a3Data.getActionNoFromActionName((String)s));
    }
    

    public void setFrameTime(double d) {
        elapsedTime = (int)(1000.0*d);
    }

    public void setPauseTime(double t) {
        pauseTime = (long)(1000.0*t);
    }

    public void setMode(Motion.Mode m) {
        mode = m;
    }
    public boolean isStoped() {
        return ((loopFlag==false)&&(playCount>0));
    }

//-------------------------------
    Node getNode() {
        return allBranchGroup;
    }

    int getActionNo() {
        return 0;
    }
    String getActionName() {
        return null;
    }
    String getActionNameFromActionNo(int an) {
        return a3Data.actions[an].actionName;
    }

    int getActionNoFromActionName(String an) {
        return a3Data.getActionNoFromActionName(an);
    }

    int getActionCount() {
        return a3Data.actions.length;
    }

    String[] getActionNames() {
        return (String[])a3Data.actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return a3Data.actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return a3Data.actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = getActionNoFromActionName(actionName);
        return a3Data.actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;//gaha
    }

    String getComment() {
        return a3Data.comment;
    }

    int getFrameCount() {
        return a3Data.actionNames.length;
    }

    void setAutoActionControl(boolean b) {
        a3Data.autoActionControl = b;
    }
    boolean autoActionControl() {
        return a3Data.autoActionControl;
    }

    void setHaltAction(int i) {
        a3Data.haltActionNo = i;
    }
    void setHaltAction(Serializable s) {
        if (s instanceof String) {
            setHaltAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setHaltAction(((Integer)s).intValue());
        }
    }
    int getHaltActionNo() {
        return a3Data.haltActionNo;
    }

    void setWalkAction(int i) {
        a3Data.walkActionNo = i;
    }
    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            setWalkAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setWalkAction(((Integer)s).intValue());
        }
    }
    int getWalkActionNo() {
        return a3Data.walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        a3Data.minWalkSpeed = d;
    }
    double getMinWalkSpeed() {
        return a3Data.minWalkSpeed;
    }

    void setRunAction(int i) {
        a3Data.runActionNo = i;
    }
    void setRunAction(Serializable s) {
        if (s instanceof String) {
            setRunAction(getActionNoFromActionName((String)s));
        } else if (s instanceof Integer) {
            setRunAction(((Integer)s).intValue());
        }
    }
    int getRunActionNo() {
        return a3Data.runActionNo;
    }

    void setMinRunSpeed(double d) {
        a3Data.minRunSpeed = d;
    }
    double getMinRunSpeed() {
        return a3Data.minRunSpeed;
    }

//-------------------------------

    void setMotion(int actionNo,Motion motion) {
        String actionName = a3Data.getActionName(actionNo);
        a3Data.motions.put(actionName,motion);
    }
    void setMotion(Serializable action,Motion motion) {
        String actionName = null;
        if (action instanceof String)
            actionName = (String)action;
        if (action instanceof Integer)
            actionName = a3Data.getActionName((Integer)action);
        a3Data.motions.put(actionName,motion);
    }
    void setShape(int actionNo,String boneName,Node shape) {
        ;
    }
    void setShape(Serializable action,String boneName,Node shape) {
        ;
    }
    void setSound(int actionNo,MediaContainer sound) {
        ;
    }
    void setSound(Serializable action,MediaContainer sound) {
        ;
    }
}
