/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3applet;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;

class MyExamController
extends A3Controller {
    Tuple3d fixationPoint = new Vector3d(0.0, 1.0, 0.0);
    double distance = 3.0;
    Quat4d cameraQuat = new Quat4d(0.0, 0.0, 0.0, 1.0);
    int lastMouseX;
    int lastMouseY;

    MyExamController() {
    }

    @Override
    public void init() {
        this.fixationPoint.set(0.0, 1.0, 0.0);
        this.distance = 3.0;
        this.cameraQuat.set(0.0, 0.0, 0.0, 1.0);
        this.setCamera();
    }

    public void reset() {
        this.fixationPoint.set(0.0, 1.0, 0.0);
        this.distance = 3.0;
        this.cameraQuat.set(0.0, 0.0, 0.0, 1.0);
        this.setCamera();
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    @Override
    public void mouseDragged(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        int shiftX = me.getX() - this.lastMouseX;
        int shiftY = me.getY() - this.lastMouseY;
        if ((me.getModifiersEx() & 0x400) != 0) {
            Quat4d q0 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            double t = (double)(-shiftX) * 0.01;
            Quat4d q1 = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
            t = (double)(-shiftY) * 0.01;
            Quat4d q2 = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
            q0.mul(q1);
            q0.mul(q2);
            this.cameraQuat.mul(q0);
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            if ((me.getModifiers() & 1) == 0) {
                Point3d shift = this.a3canvas.canvasToVirtualCS(this.lastMouseX, this.lastMouseY, this.distance);
                shift.sub((Tuple3d)this.a3canvas.canvasToVirtualCS(me.getX(), me.getY(), this.distance));
                this.fixationPoint.add((Tuple3d)shift);
            } else {
                Point3d shift = this.a3canvas.canvasToPhysicalCS(this.lastMouseX, this.lastMouseY, this.distance);
                shift.sub((Tuple3d)this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), this.distance));
                shift.z = -shift.y;
                shift.y = 0.0;
                shift = this.a3canvas.physicalCSToVirtualCS(new Vector3d((Tuple3d)shift));
                this.fixationPoint.add((Tuple3d)shift);
            }
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.distance = this.distance * (double)(100 + shiftY) / 100.0;
        }
        this.setCamera();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    void setCamera() {
        Quat4d tmpQ = new Quat4d(0.0, 0.0, 1.0, 0.0);
        Quat4d cameraQuatC = new Quat4d();
        cameraQuatC.conjugate(this.cameraQuat);
        tmpQ.mul(this.cameraQuat, tmpQ);
        tmpQ.mul(cameraQuatC);
        tmpQ.scale(this.distance);
        Vector3d tmpV = new Vector3d(this.fixationPoint);
        tmpV.set(tmpV.x + tmpQ.x, tmpV.y + tmpQ.y, tmpV.z + tmpQ.z);
        this.a3canvas.setCameraLocImmediately(tmpV);
        this.a3canvas.setCameraQuatImmediately(this.cameraQuat);
    }

    @Override
    public void mouseReleased(A3Event e) {
    }

    @Override
    public void mouseClicked(A3Event ae) {
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

