/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3.bvh;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.bvh.analysis.DepthFirstAdapter;
import jp.sourceforge.acerola3d.a3.bvh.lexer.Lexer;
import jp.sourceforge.acerola3d.a3.bvh.node.ABvh;
import jp.sourceforge.acerola3d.a3.bvh.node.AChannelsLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AEndSiteBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AFrameTimeLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AFramesLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AHierarchyPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AIntegerNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.AJointBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AMotionPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AOffsetLine;
import jp.sourceforge.acerola3d.a3.bvh.node.ARealNumberNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.ARootBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AXPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.PNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.PSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.Start;
import jp.sourceforge.acerola3d.a3.bvh.node.TInteger;
import jp.sourceforge.acerola3d.a3.bvh.node.TRealNumber;
import jp.sourceforge.acerola3d.a3.bvh.parser.Parser;

class ParserBVH
extends DepthFirstAdapter {
    int frameCount;
    double frameTime;
    String rootBone;
    HashMap<String, Bone> bones = new HashMap();
    Tmp t;

    public ParserBVH(URL url) throws Exception {
        InputStream is = url.openStream();
        InputStreamReader reader = new InputStreamReader(is);
        Lexer lexer = new Lexer(new PushbackReader(reader));
        Parser parser = new Parser(lexer);
        Start ast = parser.parse();
        this.t = new Tmp();
        ast.apply(this);
        this.convert();
        this.t = null;
    }

    public double getMotionLength() {
        return (double)this.frameCount * this.frameTime;
    }

    public double getDefaultFrameTime() {
        return this.frameTime;
    }

    public String getRootBone() {
        return this.rootBone;
    }

    public String[] getChildBones(String b) {
        Bone bone = this.bones.get(b);
        return (String[])bone.children.clone();
    }

    public Transform3D getTransform3D(String bone, double time) {
        Bone b = this.bones.get(bone);
        int frame = (int)(time / this.frameTime);
        frame = frame < 0 ? 0 : frame;
        frame = frame >= this.frameCount ? this.frameCount - 1 : frame;
        return new Transform3D(b.transforms[frame]);
    }

    @Override
    public void caseABvh(ABvh node) {
        node.getHierarchyPart().apply(this);
        node.getMotionPart().apply(this);
    }

    @Override
    public void caseAHierarchyPart(AHierarchyPart node) {
        node.getRootBlock().apply(this);
    }

    @Override
    public void caseARootBlock(ARootBlock node) {
        this.t.currentBlock = this.t.rootBlock = new Block();
        this.t.blockQueue.add(this.t.currentBlock);
        this.t.currentBlock.name = node.getIdentifier().getText();
        this.t.currentBlock.children = new ArrayList();
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
    }

    @Override
    public void caseAOffsetLine(AOffsetLine node) {
        PNumber x_number = node.getXOffset();
        PNumber y_number = node.getYOffset();
        PNumber z_number = node.getZOffset();
        this.t.currentBlock.offsetX = this.pNumber2Double(x_number);
        this.t.currentBlock.offsetY = this.pNumber2Double(y_number);
        this.t.currentBlock.offsetZ = this.pNumber2Double(z_number);
    }

    @Override
    public void caseAChannelsLine(AChannelsLine node) {
        Object[] temp;
        TInteger integer = node.getInteger();
        int channelsCount = Integer.parseInt(integer.getText());
        if (channelsCount != (temp = node.getChannelType().toArray()).length) {
            System.out.println("ActionGenerator.caseAChannelsBlock()");
            System.out.println("pars error!!!");
        }
        for (int i = 0; i < temp.length; ++i) {
            Channel c = new Channel();
            this.t.channelQueue.add(c);
            if (temp[i] instanceof AXPositionChannelType) {
                this.t.currentBlock.x_position = c;
                continue;
            }
            if (temp[i] instanceof AYPositionChannelType) {
                this.t.currentBlock.y_position = c;
                continue;
            }
            if (temp[i] instanceof AZPositionChannelType) {
                this.t.currentBlock.z_position = c;
                continue;
            }
            if (temp[i] instanceof AXRotationChannelType) {
                this.t.currentBlock.x_rotation = c;
                continue;
            }
            if (temp[i] instanceof AYRotationChannelType) {
                this.t.currentBlock.y_rotation = c;
                continue;
            }
            if (temp[i] instanceof AZRotationChannelType) {
                this.t.currentBlock.z_rotation = c;
                continue;
            }
            if (temp[i] instanceof AXScaleChannelType) {
                this.t.currentBlock.x_scale = c;
                continue;
            }
            if (temp[i] instanceof AYScaleChannelType) {
                this.t.currentBlock.y_scale = c;
                continue;
            }
            if (!(temp[i] instanceof AZScaleChannelType)) continue;
            this.t.currentBlock.z_scale = c;
        }
    }

    @Override
    public void caseAJointBlock(AJointBlock node) {
        this.t.blockStack.push(this.t.parentBlock);
        this.t.parentBlock = this.t.currentBlock;
        this.t.currentBlock = new Block();
        this.t.blockQueue.add(this.t.currentBlock);
        this.t.currentBlock.name = node.getIdentifier().getText();
        this.t.currentBlock.children = new ArrayList();
        this.t.parentBlock.children.add(this.t.currentBlock.name);
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
        this.t.currentBlock = this.t.parentBlock;
        this.t.parentBlock = this.t.blockStack.pop();
    }

    @Override
    public void caseAEndSiteBlock(AEndSiteBlock node) {
        this.t.blockStack.push(this.t.parentBlock);
        this.t.parentBlock = this.t.currentBlock;
        this.t.currentBlock = new Block();
        this.t.currentBlock.name = null;
        node.getOffsetLine().apply(this);
        this.t.currentBlock = this.t.parentBlock;
        this.t.parentBlock = this.t.blockStack.pop();
    }

    @Override
    public void caseAMotionPart(AMotionPart node) {
        node.getFramesLine().apply(this);
        node.getFrameTimeLine().apply(this);
        this.t.channelsInit();
        Object[] temp = node.getNumber().toArray();
        if (temp.length != this.t.channelQueue.size() * this.t.frameCount) {
            System.out.println("ActionGenerator.caseAMotionPart().");
            System.out.println("parse error!!!");
            System.out.print(temp.length);
            System.out.print(" and " + this.t.channelQueue.size() * this.t.frameCount);
            System.out.println(" do not match.");
            return;
        }
        int tempCount = 0;
        for (int i = 0; i < this.t.frameCount; ++i) {
            for (int j = 0; j < this.t.channelQueue.size(); ++j) {
                double d;
                PNumber pn = (PNumber)temp[tempCount++];
                this.t.channelQueue.get((int)j).data[i] = d = this.pNumber2Double(pn);
            }
        }
    }

    @Override
    public void caseAFramesLine(AFramesLine node) {
        TInteger integer = node.getInteger();
        String is = integer.getText();
        this.t.frameCount = Integer.parseInt(is);
    }

    @Override
    public void caseAFrameTimeLine(AFrameTimeLine node) {
        PNumber num = node.getNumber();
        this.t.frameTime = this.pNumber2Double(num);
    }

    protected double pNumber2Double(PNumber num) {
        if (num instanceof ARealNumberNumber) {
            TRealNumber rn = ((ARealNumberNumber)num).getRealNumber();
            String rns = rn.getText();
            return Double.parseDouble(rns);
        }
        TInteger integer = ((AIntegerNumber)num).getInteger();
        int iii = Integer.parseInt(integer.getText());
        return iii;
    }

    void convert() {
        this.frameCount = this.t.frameCount;
        this.frameTime = this.t.frameTime;
        this.rootBone = this.t.rootBlock.name;
        Transform3D t1 = new Transform3D();
        Transform3D t2 = new Transform3D();
        double[] xyz = new double[3];
        Vector3d v = new Vector3d();
        for (Block block : this.t.blockQueue) {
            Bone bone = new Bone();
            bone.name = block.name;
            bone.children = block.children.toArray(new String[0]);
            bone.transforms = new Transform3D[this.frameCount];
            for (int j = 0; j < this.frameCount; ++j) {
                Transform3D t0 = new Transform3D();
                t0.setTranslation(new Vector3d(block.offsetX, block.offsetY, block.offsetZ));
                if (block.z_rotation != null) {
                    t1.rotZ(block.z_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                }
                if (block.x_rotation != null) {
                    t2.rotX(block.x_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                    t1.mul(t2);
                }
                if (block.y_rotation != null) {
                    t2.rotY(block.y_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                    t1.mul(t2);
                }
                xyz[2] = 0.0;
                xyz[1] = 0.0;
                xyz[0] = 0.0;
                if (block.x_position != null) {
                    xyz[0] = block.x_position.data[j];
                }
                if (block.y_position != null) {
                    xyz[1] = block.y_position.data[j];
                }
                if (block.z_position != null) {
                    xyz[2] = block.z_position.data[j];
                }
                v.set(xyz);
                t1.setTranslation(v);
                xyz[2] = 1.0;
                xyz[1] = 1.0;
                xyz[0] = 1.0;
                if (block.x_scale != null) {
                    xyz[0] = block.x_scale.data[j];
                }
                if (block.y_scale != null) {
                    xyz[1] = block.y_scale.data[j];
                }
                if (block.z_scale != null) {
                    xyz[2] = block.z_scale.data[j];
                }
                v.set(xyz);
                t1.setScale(v);
                t0.mul(t1);
                bone.transforms[j] = t0;
            }
            this.bones.put(bone.name, bone);
        }
    }

    class Tmp {
        int frameCount;
        double frameTime;
        ArrayList<Block> blockQueue = new ArrayList();
        Stack<Block> blockStack = new Stack();
        ArrayList<Channel> channelQueue = new ArrayList();
        Block rootBlock;
        Block parentBlock;
        Block currentBlock;

        Tmp() {
        }

        void channelsInit() {
            Iterator<Channel> i = this.channelQueue.iterator();
            while (i.hasNext()) {
                i.next().data = new double[this.frameCount];
            }
        }
    }

    class Channel {
        double[] data;

        Channel() {
        }
    }

    class Block {
        String name;
        ArrayList<String> children;
        double offsetX;
        double offsetY;
        double offsetZ;
        Channel x_position;
        Channel y_position;
        Channel z_position;
        Channel z_rotation;
        Channel x_rotation;
        Channel y_rotation;
        Channel x_scale;
        Channel y_scale;
        Channel z_scale;

        Block() {
        }
    }

    class Bone {
        String name;
        String[] children;
        Transform3D[] transforms;

        Bone() {
        }
    }
}

