/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Raster;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Behavior;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.CameraBehavior;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.EditController;
import jp.sourceforge.acerola3d.a3.ExamController;
import jp.sourceforge.acerola3d.a3.FlyController;
import jp.sourceforge.acerola3d.a3.NoneController;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.SimpleController;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import jp.sourceforge.acerola3d.a3.WalkController;
import org.jdesktop.j3d.audioengines.joal.JOALMixer;

public class A3Canvas
extends Canvas3D {
    private static final long serialVersionUID = 1L;
    VirtualUniverse universe;
    Locale locale;
    View view;
    BranchGroup rootGroup;
    TransformGroup tGroup;
    Transform3D transform;
    BranchGroup vpGroup;
    ViewPlatform vp;
    BranchGroup mainGroup;
    BranchGroup bgGroup;
    TimerBehavior timerBehavior;
    PickingBehavior pickingBehavior;
    CameraBehavior cameraBehavior;
    Light headLight;
    static UpperDirection upperDirection = UpperDirection.Y;
    A3Object background = null;
    A3Object avatar = null;
    Hashtable<A3Object, BranchGroup> a3Hash = new Hashtable();
    BranchGroup backgroundBG = null;
    Vector3d cameraNowV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNowS = 1.0;
    Vector3d cameraNextV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNextS = 1.0;
    Vector3d defaultV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d defaultQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double defaultS = 1.0;
    NaviMode naviMode = NaviMode.NONE;
    double naviSpeed = 1.0;
    A3Controller controller = null;
    ArrayList<Component2D> components2D = new ArrayList();
    volatile boolean check = false;
    GraphicsContext3D gc = this.getGraphicsContext3D();
    Raster readRaster;

    public static UpperDirection getUpperDirection() {
        return upperDirection;
    }

    public static A3Canvas createA3Canvas() {
        return A3Canvas.createA3Canvas(500, 500);
    }

    public static A3Canvas createA3Canvas(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration[] gcs = gd.getConfigurations();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gc = gct3d.getBestConfiguration(gcs);
        return A3Canvas.createA3Canvas(gc, w, h);
    }

    public static A3Canvas createA3Canvas(GraphicsConfiguration graCon) {
        return A3Canvas.createA3Canvas(graCon, 500, 500);
    }

    public static A3Canvas createA3Canvas(GraphicsConfiguration graCon, int w, int h) {
        return new A3Canvas(graCon, w, h);
    }

    public static void setUpperDirection(UpperDirection ud) {
        upperDirection = ud;
        if (upperDirection == UpperDirection.Y) {
            A3Behavior.vFront = new Vector3d(0.0, 0.0, 1.0);
            A3Behavior.vTop = new Vector3d(0.0, 1.0, 0.0);
        } else if (upperDirection == UpperDirection.Z) {
            A3Behavior.vFront = new Vector3d(0.0, -1.0, 0.0);
            A3Behavior.vTop = new Vector3d(0.0, 0.0, 1.0);
        }
    }

    A3Canvas(GraphicsConfiguration graCon, int w, int h) {
        super(graCon);
        this.prepareVirtualUniverse();
        this.setSize(w, h);
    }

    void prepareVirtualUniverse() {
        this.universe = new VirtualUniverse();
        this.locale = new Locale(this.universe);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D((Canvas3D)this);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.view.setBackClipDistance(1000.0);
        this.view.setUserHeadToVworldEnable(true);
        this.vpGroup = new BranchGroup();
        this.tGroup = new TransformGroup();
        this.tGroup.setCapability(18);
        this.tGroup.setCapability(17);
        this.vpGroup.addChild((Node)this.tGroup);
        this.transform = new Transform3D();
        this.tGroup.setTransform(this.transform);
        this.timerBehavior = new TimerBehavior();
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0);
        this.timerBehavior.setSchedulingBounds((Bounds)bs);
        this.tGroup.addChild((Node)this.timerBehavior);
        this.vp = new ViewPlatform();
        this.tGroup.addChild((Node)this.vp);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        this.headLight.setEnable(true);
        this.tGroup.addChild((Node)this.headLight);
        this.view.attachViewPlatform(this.vp);
        this.pickingBehavior = new PickingBehavior(this, this.view, this.tGroup, this.locale);
        this.vpGroup.addChild((Node)this.pickingBehavior);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0);
        this.pickingBehavior.setSchedulingBounds((Bounds)sb);
        this.cameraBehavior = new CameraBehavior(this);
        this.vpGroup.addChild((Node)this.cameraBehavior);
        this.cameraBehavior.setSchedulingBounds((Bounds)sb);
        this.mainGroup = new BranchGroup();
        this.mainGroup.setCapability(17);
        this.mainGroup.setCapability(12);
        this.mainGroup.setCapability(14);
        this.mainGroup.setCapability(13);
        this.bgGroup = new BranchGroup();
        this.bgGroup.setCapability(17);
        this.bgGroup.setCapability(12);
        this.bgGroup.setCapability(14);
        this.bgGroup.setCapability(13);
        this.rootGroup = new BranchGroup();
        this.rootGroup.addChild((Node)this.vpGroup);
        this.rootGroup.addChild((Node)this.mainGroup);
        this.rootGroup.addChild((Node)this.bgGroup);
        this.locale.addBranchGraph(this.rootGroup);
        JOALMixer mixer = null;
        String mixerClassName = System.getProperty("j3d.audiodevice");
        if (mixerClassName != null) {
            try {
                Class<?> c = Class.forName(mixerClassName);
                Class<AudioDevice> mixerClass = c.asSubclass(AudioDevice.class);
                Constructor<AudioDevice> constructor = mixerClass.getConstructor(PhysicalEnvironment.class);
                mixer = constructor.newInstance(environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mixer == null) {
            try {
                mixer = new JOALMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            try {
                mixer = new JavaSoundMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            System.out.println("null AudioDevice!");
        } else {
            environment.setAudioDevice((AudioDevice)mixer);
            mixer.initialize();
        }
    }

    public void add(A3Object a) {
        if (this.a3Hash.containsKey(a)) {
            return;
        }
        a.setA3Canvas(this);
        A3BranchGroup bg = a.getA3BranchGroup();
        this.mainGroup.addChild((Node)bg);
        this.a3Hash.put(a, bg);
    }

    public void del(A3Object a) {
        BranchGroup bg = this.a3Hash.get(a);
        if (bg == null) {
            return;
        }
        bg.detach();
        a.dispose();
        this.a3Hash.remove(a);
    }

    public void delAll() {
        Enumeration<A3Object> e = this.a3Hash.keys();
        while (e.hasMoreElements()) {
            A3Object a3 = e.nextElement();
            BranchGroup bg = this.a3Hash.get(a3);
            bg.detach();
            a3.dispose();
        }
        this.a3Hash.clear();
    }

    public void setBackground(A3Object a) {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        A3BranchGroup n = a.getA3BranchGroup();
        this.backgroundBG = new BranchGroup();
        this.backgroundBG.setCapability(17);
        this.backgroundBG.addChild((Node)n);
        this.mainGroup.addChild((Node)this.backgroundBG);
        this.background = a;
    }

    public void delBackground() {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        this.background = null;
    }

    public void setAvatar(A3Object a) {
        this.avatar = a;
    }

    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.defaultV = new Vector3d(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.defaultV = new Vector3d(loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.defaultQ = new Quat4d(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.defaultQ = new Quat4d(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.defaultQ = this.rot2quat(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.defaultQ = this.rot2quat(rot);
    }

    public void setDefaultCameraScale(double s) {
        this.defaultS = s;
    }

    public void resetCamera() {
        this.cameraNowV.set((Tuple3d)this.defaultV);
        this.cameraNowQ.set((Tuple4d)this.defaultQ);
        this.cameraNowS = this.defaultS;
        this.cameraNextV.set((Tuple3d)this.defaultV);
        this.cameraNextQ.set((Tuple4d)this.defaultQ);
        this.cameraNextS = this.defaultS;
    }

    public void setCameraLoc(double x, double y, double z) {
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.cameraNowV.set(x, y, z);
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.cameraNowV.set((Tuple3d)loc);
        this.cameraNextV.set((Tuple3d)loc);
    }

    public Vector3d getCameraLoc() {
        return new Vector3d(this.cameraNowV);
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNowQ.set(x, y, z, w);
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.cameraNowQ.set((Tuple4d)quat);
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public Quat4d getCameraQuat() {
        return new Quat4d(this.cameraNowQ);
    }

    public void setCameraRot(double x, double y, double z) {
        this.setCameraQuat(this.rot2quat(x, y, z));
    }

    public void setCameraRot(Vector3d rot) {
        this.setCameraQuat(this.rot2quat(rot));
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.setCameraQuatImmediately(this.rot2quat(x, y, z));
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.setCameraQuatImmediately(this.rot2quat(rot));
    }

    public void setCameraScale(double s) {
        this.cameraNextS = s;
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraNowS = s;
        this.cameraNextS = s;
    }

    public double getCameraScale() {
        return this.cameraNowS;
    }

    Quat4d rot2quat(double x, double y, double z) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotX(x);
        t0.mul(t1);
        t1.rotY(y);
        t0.mul(t1);
        t1.rotZ(z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    Quat4d rot2quat(Vector3d rot) {
        return this.rot2quat(rot.x, rot.y, rot.z);
    }

    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    public void setNavigationMode(NaviMode m) {
        this.naviMode = m;
        if (this.naviMode == NaviMode.NONE) {
            this.setA3Controller0(new NoneController());
        } else if (this.naviMode == NaviMode.WALK) {
            this.setA3Controller0(new WalkController());
        } else if (this.naviMode == NaviMode.FLY) {
            this.setA3Controller0(new FlyController());
        } else if (this.naviMode == NaviMode.EXAMINE) {
            this.setA3Controller0(new ExamController());
        } else if (this.naviMode == NaviMode.EDIT) {
            this.setA3Controller0(new EditController());
        } else if (this.naviMode == NaviMode.SIMPLE) {
            this.setA3Controller0(new SimpleController());
        }
    }

    public void setNavigationSpeed(double s) {
        this.naviSpeed = s;
    }

    public double getNavigationSpeed() {
        return this.naviSpeed;
    }

    void setA3Controller0(A3Controller c) {
        c.setA3Canvas(this);
        if (this.controller != null) {
            this.removeA3Listener(this.controller);
            this.removeKeyListener(this.controller);
            this.controller.stop();
        }
        this.controller = c;
        this.addA3Listener(this.controller);
        this.addKeyListener(this.controller);
        this.controller.init();
    }

    public void setA3Controller(A3Controller c) {
        this.naviMode = NaviMode.USER;
        this.setA3Controller0(c);
    }

    public Point3d canvasToVirtualCS(int x, int y) {
        return this.pickingBehavior.canvasToVirtualCS(x, y);
    }

    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToVirtualCS(x, y, dis);
    }

    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y);
    }

    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y, dis);
    }

    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        return this.pickingBehavior.physicalCSToVirtualCS(v);
    }

    public Point virtualCSToCanvas(Point3d p) {
        return this.pickingBehavior.virtualCSToCanvas(p);
    }

    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        return this.pickingBehavior.virtualCSToPhysicalCS(v);
    }

    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }

    synchronized void add(Component2D c) {
        if (!this.components2D.contains(c)) {
            this.components2D.add(c);
        }
    }

    synchronized void del(Component2D c) {
        this.components2D.remove(c);
    }

    public synchronized void postRender() {
        J3DGraphics2D gg = this.getGraphics2D();
        for (Component2D c : this.components2D) {
            c.paint(gg, this);
        }
        gg.flush(true);
    }

    public void postSwap() {
        super.postSwap();
        if (this.check) {
            this.gc.readRaster(this.readRaster);
            this.check = false;
        }
    }

    public void saveImage(File file) throws IOException {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        ImageIO.write((RenderedImage)image, "png", file);
    }

    public static enum NaviMode {
        NONE,
        EXAMINE,
        WALK,
        FLY,
        EDIT,
        SIMPLE,
        USER;

    }

    public static enum UpperDirection {
        X,
        Y,
        Z;

    }
}

