package jp.sourceforge.acerola3d.a3applet;

import jp.sourceforge.acerola3d.*;
import jp.sourceforge.acerola3d.a3.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;

import javax.swing.*;
import javax.swing.event.*;

public class A3Panel extends JPanel implements ActionListener, ChangeListener {
    private static final long serialVersionUID = 1L;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem proxyMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JComboBox actionNameCB;
    JButton resetViewButton;
    JTextArea commentTextArea;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength=100;
    double motionLength;

    Action3D a3;
    String actionName = "0";
    MyExamController controller;

    public A3Panel(String args[],javax.swing.JApplet applet) {
        setLayout(new BorderLayout());
        Box baseBox = Box.createVerticalBox();
        add(baseBox,BorderLayout.CENTER);

        menuBar = new JMenuBar();
menuBar.setMaximumSize(new Dimension(10000,40));
        baseBox.add(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        configMenu = new JMenu("Config");
        menuBar.add(configMenu);
        consoleMenuItem = new JMenuItem("Console");
        consoleMenuItem.addActionListener(this);
        configMenu.add(consoleMenuItem);
        proxyMenuItem = new JMenuItem("Proxy");
        proxyMenuItem.addActionListener(this);
        configMenu.add(proxyMenuItem);
        resetViewMenuItem = new JMenuItem("ResetView");
        resetViewMenuItem.addActionListener(this);
        configMenu.add(resetViewMenuItem);
        snapshotMenuItem = new JMenuItem("Snapshot");
        snapshotMenuItem.addActionListener(this);
        configMenu.add(snapshotMenuItem);
        backgroundMenuItem = new JMenuItem("Background");
        backgroundMenuItem.addActionListener(this);
        configMenu.add(backgroundMenuItem);

        consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        consoleTextArea = new JTextArea(20,60);
        consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(consoleTextArea);
        b.add(sp);
        clearConsoleButton = new JButton("Clear");
        clearConsoleButton.addActionListener(this);
        b.add(clearConsoleButton);
        consoleFrame.getContentPane().add(b);
        consoleFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(consoleTextArea,systemOut);
        PrintStream ps = new PrintStream(jtaos,true);
        System.setOut(ps);
        System.setErr(ps);
        consoleFrame.pack();
        
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        urlTextField = new JTextField();
        try {
            File f = null;
            if ((args!=null)&&(args.length==2)&&(args[0].equals("-open"))) {
                f  = new File(args[1]);
                urlTextField.setText(f.toURI().toString());
            } else if ((args!=null)&&(args.length==2)&&(args[0].equals("-applet"))) {
                URL url = null;
                if (args[1].startsWith("http://")||
                    args[1].startsWith("https://")||
                    args[1].startsWith("ftp://")||
                    args[1].startsWith("file://")) {
                    url = new URL(args[1]);
                    urlTextField.setText(url.toString());
                } else {
                    URL base = applet.getDocumentBase();
                    url = new URL(base,args[1]);
                    urlTextField.setText(url.toString());
                }
            } else if ((args!=null)&&(args.length==1)&&(args[0]!=null)) {
                f = new File(args[0]);
                urlTextField.setText(f.toURI().toString());
            } else {
                urlTextField.setText("x-res:///jp/sourceforge/acerola3d/a3applet/resources/acerola3d.a3");
            }
        } catch (Exception e) {
            urlTextField.setText("x-res:///jp/sourceforge/acerola3d/a3applet/resources/acerola3d.a3");
        }
        urlTextField.addActionListener(this);
urlTextField.setMaximumSize(new Dimension(3000,30));
        box1.add(urlTextField);
        refButton = new JButton("ref");
        refButton.addActionListener(this);
        box1.add(refButton);

        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);

        a3canvas = A3Canvas.createA3Canvas(300,300);
        controller = new MyExamController();
        a3canvas.setA3Controller(controller);
        box2.add(a3canvas);

        Box controlBox = makeControlBox();
        box2.add(controlBox);

        Box box3 = Box.createHorizontalBox();
        pauseCheckBox = new JCheckBox("pause");
        pauseCheckBox.setSelected(false);
        pauseCheckBox.addActionListener(this);
        box3.add(pauseCheckBox);
        slider = new JSlider();
        slider.setMinimum(0);
        slider.setMaximum(sliderLength);
        slider.addChangeListener(this);
        box3.add(slider);
        baseBox.add(box3);

        statusBarLabel = new JLabel("Status:");
        baseBox.add(statusBarLabel);

        loadAction3D();
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();

        controlBox.add(new JLabel("ActionName:"));
        actionNameCB = new JComboBox();
actionNameCB.setPreferredSize(new Dimension(50,30));
actionNameCB.setMaximumSize(new Dimension(400,10000));
        actionNameCB.addActionListener(this);
        controlBox.add(actionNameCB);

        resetViewButton = new JButton("Reset View");
        resetViewButton.addActionListener(this);
        controlBox.add(resetViewButton);

        controlBox.add(new JLabel("Left drag: rotation"));
        controlBox.add(new JLabel("Center drag: translation"));
        controlBox.add(new JLabel("Right drag: scale"));

        //controlBox.add(Box.createVerticalGlue());

        controlBox.add(new JLabel("***Comment***"));
        commentTextArea = new JTextArea(10,30);
        commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(commentTextArea);
sp.setPreferredSize(new Dimension(50,150));
sp.setMaximumSize(new Dimension(400,10000));
        controlBox.add(sp);

        //controlBox.add(Box.createVerticalGlue());

        String buildTime = null;
        try {
            URL url = getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(),"UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        } catch (Exception e) {
            buildTime = "???";
        }
        controlBox.add(new JLabel("build time:"));
        controlBox.add(new JLabel("   "+buildTime));

        return controlBox;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == actionNameCB) {
            actionName = (String)actionNameCB.getSelectedItem();
if (actionName == null) {
System.out.println("gaha1");
return;
}
            System.out.println("actionName:"+actionName);
            repaint();
        } else if (ae.getSource() == urlTextField) {
            loadAction3D();
        } else if (ae.getSource() == resetViewButton) {
            controller.reset();
        } else if (ae.getSource() == refButton) {
            ref();
        } else if (ae.getSource() == consoleMenuItem) {
            consoleFrame.setVisible(true);
        } else if (ae.getSource() == clearConsoleButton) {
            consoleTextArea.setText("");
        } else if (ae.getSource() == proxyMenuItem) {
            proxyConfig();
        } else if (ae.getSource() == resetViewMenuItem) {
            controller.reset();
        } else if (ae.getSource() == snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                a3canvas.saveImage(f);
            } catch (Exception e) {
                System.out.println("A3Panel:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == backgroundMenuItem){
            setBackground();
        } else if (ae.getSource() == pauseCheckBox) {
            if (a3 == null)
                return;
            if (pauseCheckBox.isSelected()) {
                a3.changeImmediately(actionName);
                a3.setMode(Motion.Mode.PAUSE);
                double t = motionLength*((double)slider.getValue()/(double)sliderLength);
                a3.setPauseTime(t);
            } else {
                a3.changeImmediately(actionName);
                a3.setMode(Motion.Mode.PLAY);
                double t = motionLength*((double)slider.getValue()/(double)sliderLength);
                a3.setPauseTime(t);
            }
        } else {
            System.out.append("gaha???");
        }
    }

    public void stateChanged(ChangeEvent ce) {
        if (a3==null)
            return;
        double t = motionLength*((double)slider.getValue()/(double)sliderLength);
        a3.setPauseTime(t);
    }

    void loadAction3D() {
        Action3D.clearCash();
        statusBarLabel.setText("Status: Loading ... ");
        statusBarLabel.repaint();
        if (a3!=null)
            a3canvas.del(a3);
        String urlString = urlTextField.getText();
        try {
            A23.initA23();
            a3 = Action3D.load(urlString);
        } catch(Exception e) {
            System.out.println("A3Panel.loadAction3D. error!");
            e.printStackTrace();
        }

        actionNameCB.removeAllItems();
        String sss[] = a3.getActionNames();
        for (int i=0;i<sss.length;i++)
            actionNameCB.addItem(sss[i]);
        a3canvas.add(a3);

        commentTextArea.setText(a3.getComment());
        if (pauseCheckBox.isSelected())
            a3.setMode(Motion.Mode.PAUSE);
        else
            a3.setMode(Motion.Mode.PLAY);
        motionLength = a3.getMotionLength(actionName);
        slider.setValue(0);

        a3.setLocImmediately(0.0,0.0,0.0);
        a3.setQuatImmediately(0.0,0.0,0.0,1.0);
        a3.setScaleImmediately(1.0);

        statusBarLabel.setText("Status: Loading ... done.");
    }

    public void repaint() {
        if (a3 == null)
            return;
        a3.changeImmediately(actionName);
        motionLength = a3.getMotionLength(actionName);
        slider.setValue(0);
    }

    ProxyPanel proxyPanel = null;
    String proxyData[] = {"","","",""};
    void proxyConfig() {
        if (proxyPanel == null) {
            proxyPanel = new ProxyPanel();
            proxyData[0] = System.getProperty("proxyHost");
            proxyData[1] = System.getProperty("proxyPort");
            proxyData[2] = System.getProperty("ftpProxyHost");
            proxyData[3] = System.getProperty("ftpProxyPort");
        }
        proxyPanel.setData(proxyData);

        Object options[] = {"Ok","Cancel"};
        int result = JOptionPane.showOptionDialog(this,proxyPanel,"proxy",
                                                  JOptionPane.DEFAULT_OPTION,
                                                  JOptionPane.INFORMATION_MESSAGE,
                                                  null,options,options[0]);
        if (result==0) {
            proxyData = proxyPanel.getData();
            if (!proxyData[0].equals("")) {
                System.getProperties().put("proxySet","true");
                System.getProperties().put("proxyHost",proxyData[0]);
                System.getProperties().put("proxyPort",proxyData[1]);
            } else {
                System.getProperties().put("proxySet","false");
                System.getProperties().put("proxyHost","");
                System.getProperties().put("proxyPort","");
            }
            if (!proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet","true");
                System.getProperties().put("ftpProxyHost",proxyData[2]);
                System.getProperties().put("ftpProxyPort",proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet","false");
                System.getProperties().put("ftpProxyHost","");
                System.getProperties().put("ftpProxyPort","");
            }
        }
    }

    class ProxyPanel extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();

            this.add(b0);
            b0.add(b1);
            b0.add(b2);

            b1.add(new JLabel("http: host"));
            httpHostTF = new JTextField(40);
            b1.add(httpHostTF);
            b1.add(new JLabel(" port "));
            httpPortTF = new JTextField(5);
            b1.add(httpPortTF);

            b2.add(new JLabel("ftp: host"));
            ftpHostTF = new JTextField(40);
            b2.add(ftpHostTF);
            b2.add(new JLabel(" port "));
            ftpPortTF = new JTextField(5);
            b2.add(ftpPortTF);
        }

        public void setData(String proxyData[]) {
            httpHostTF.setText(proxyData[0]);
            httpPortTF.setText(proxyData[1]);
            ftpHostTF.setText(proxyData[2]);
            ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String ret[] = new String[4];
            ret[0] = httpHostTF.getText();
            ret[1] = httpPortTF.getText();
            ret[2] = ftpHostTF.getText();
            ret[3] = ftpPortTF.getText();
            return ret;
        }
    }

    void ref() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(this);
        if(returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url=new URL(f.toURI().toString());}catch(Exception e){;}
        if (url == null)
            return;
        urlTextField.setText(url.toExternalForm());
        loadAction3D();
    }
    void setBackground() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url=new URL(f.toURI().toString());}catch(Exception e){;}
        if (url == null)
            return;
        Action3D a = null;
        try{
            a = Action3D.load(url);
        } catch(Exception e) {
            e.printStackTrace();
        }
        if (a!=null)
            a3canvas.setBackground(a);
    }
}
