/*
 * Decompiled with CFR 0.152.
 */
package org.ks1.j3dbvh.bvh;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Vector3d;
import org.ks1.j3dbvh.bvh.ChannelData;

public class BVHBehavior
extends Behavior {
    String bName;
    TransformGroup tg;
    Transform3D t;
    ChannelData[] channels;
    int frameCount;
    double frameTime;
    int elapsedTime;
    int count;
    double[] xLoc;
    double[] yLoc;
    double[] zLoc;
    double[] xRot;
    double[] yRot;
    double[] zRot;
    boolean stopFlag = false;

    public BVHBehavior(String bName, TransformGroup tg, Transform3D t, ChannelData[] cd) {
        this.bName = bName;
        this.tg = tg;
        this.t = t;
        this.channels = cd;
    }

    public void initialize() {
        if (this.elapsedTime == 0) {
            return;
        }
        WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        if (!this.stopFlag) {
            if (this.xRot != null && this.yRot != null && this.zRot != null) {
                this.t.rotZ(this.zRot[this.count]);
                Transform3D tt = new Transform3D();
                tt.rotX(this.xRot[this.count]);
                this.t.mul(tt);
                tt.rotY(this.yRot[this.count]);
                this.t.mul(tt);
            }
            if (this.xLoc != null && this.yLoc != null && this.zLoc != null) {
                this.t.setTranslation(new Vector3d(this.xLoc[this.count], this.yLoc[this.count], this.zLoc[this.count]));
            }
            this.tg.setTransform(this.t);
            ++this.count;
        }
        if (this.count >= this.frameCount) {
            this.count = 0;
        }
        WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    public void start() {
        this.count = 0;
        this.stopFlag = false;
    }

    public void stop() {
        this.stopFlag = true;
    }

    public void setFrameCount(int c) {
        this.frameCount = c;
    }

    public void setFrameTime(double d) {
        this.frameTime = d;
        this.elapsedTime = (int)(1000.0 * d);
    }

    public void calc() {
        if (this.frameCount != this.channels[0].size()) {
            System.out.println("BVHBehavior.calc().");
            System.out.println("????.");
        }
        for (int i = 0; i < this.channels.length; ++i) {
            int j;
            String s = this.channels[i].getChannelName();
            if (s.equals("Xposition")) {
                this.xLoc = new double[this.frameCount];
                for (j = 0; j < this.frameCount; ++j) {
                    this.xLoc[j] = (Double)this.channels[i].get(j);
                    this.xLoc[j] = this.xLoc[j];
                }
                continue;
            }
            if (s.equals("Yposition")) {
                this.yLoc = new double[this.frameCount];
                for (j = 0; j < this.frameCount; ++j) {
                    this.yLoc[j] = (Double)this.channels[i].get(j);
                    this.yLoc[j] = this.yLoc[j];
                }
                continue;
            }
            if (s.equals("Zposition")) {
                this.zLoc = new double[this.frameCount];
                for (j = 0; j < this.frameCount; ++j) {
                    this.zLoc[j] = (Double)this.channels[i].get(j);
                    this.zLoc[j] = this.zLoc[j];
                }
                continue;
            }
            if (s.equals("Xrotation")) {
                this.xRot = new double[this.frameCount];
                for (j = 0; j < this.frameCount; ++j) {
                    this.xRot[j] = (Double)this.channels[i].get(j);
                    this.xRot[j] = this.xRot[j] / 360.0 * 2.0 * Math.PI;
                }
                continue;
            }
            if (s.equals("Yrotation")) {
                this.yRot = new double[this.frameCount];
                for (j = 0; j < this.frameCount; ++j) {
                    this.yRot[j] = (Double)this.channels[i].get(j);
                    this.yRot[j] = this.yRot[j] / 360.0 * 2.0 * Math.PI;
                }
                continue;
            }
            if (!s.equals("Zrotation")) continue;
            this.zRot = new double[this.frameCount];
            for (j = 0; j < this.frameCount; ++j) {
                this.zRot[j] = (Double)this.channels[i].get(j);
                this.zRot[j] = this.zRot[j] / 360.0 * 2.0 * Math.PI;
            }
        }
        this.channels = null;
    }
}

