/*
 * Decompiled with CFR 0.152.
 */
package org.ks1.j3dbvh.bvh;

import java.awt.Color;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.ks1.j3dbvh.bvh.BVHBehavior;
import org.ks1.j3dbvh.bvh.BVHBlockData;
import org.ks1.j3dbvh.bvh.ChannelData;
import org.ks1.j3dbvh.bvh.analysis.DepthFirstAdapter;
import org.ks1.j3dbvh.bvh.lexer.Lexer;
import org.ks1.j3dbvh.bvh.node.AChannelsLine;
import org.ks1.j3dbvh.bvh.node.AEndSiteBlock;
import org.ks1.j3dbvh.bvh.node.AFrameTimeLine;
import org.ks1.j3dbvh.bvh.node.AFramesLine;
import org.ks1.j3dbvh.bvh.node.AHierarchyPart;
import org.ks1.j3dbvh.bvh.node.AIntegerNumber;
import org.ks1.j3dbvh.bvh.node.AJointBlock;
import org.ks1.j3dbvh.bvh.node.AMotionPart;
import org.ks1.j3dbvh.bvh.node.AOffsetLine;
import org.ks1.j3dbvh.bvh.node.ARealNumberNumber;
import org.ks1.j3dbvh.bvh.node.ARootBlock;
import org.ks1.j3dbvh.bvh.node.AXPositionChannelType;
import org.ks1.j3dbvh.bvh.node.AXRotationChannelType;
import org.ks1.j3dbvh.bvh.node.AXScaleChannelType;
import org.ks1.j3dbvh.bvh.node.AYPositionChannelType;
import org.ks1.j3dbvh.bvh.node.AYRotationChannelType;
import org.ks1.j3dbvh.bvh.node.AYScaleChannelType;
import org.ks1.j3dbvh.bvh.node.AZPositionChannelType;
import org.ks1.j3dbvh.bvh.node.AZRotationChannelType;
import org.ks1.j3dbvh.bvh.node.AZScaleChannelType;
import org.ks1.j3dbvh.bvh.node.PNumber;
import org.ks1.j3dbvh.bvh.node.PSuperBlock;
import org.ks1.j3dbvh.bvh.node.Start;
import org.ks1.j3dbvh.bvh.node.TInteger;
import org.ks1.j3dbvh.bvh.node.TRealNumber;
import org.ks1.j3dbvh.bvh.parser.Parser;

public class ActionGenerator
extends DepthFirstAdapter {
    static BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0);
    public Group rootGroup = null;
    BVHBlockData rootBlock = null;
    BVHBlockData parentBlock;
    BVHBlockData currentBlock;
    Stack<BVHBlockData> blockStack = new Stack();
    ArrayList<BVHBlockData> blockQueue = new ArrayList();
    BVHBehavior[] behaviors;
    ChannelData[] channels;
    int frameCount;
    double frameTime;

    public static ActionGenerator generate(Reader reader) {
        try {
            Lexer lexer = new Lexer(new PushbackReader(reader));
            Parser parser = new Parser(lexer);
            Start ast = parser.parse();
            ActionGenerator ag = new ActionGenerator();
            ast.apply(ag);
            return ag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void start() {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].start();
        }
    }

    @Override
    public void caseAHierarchyPart(AHierarchyPart node) {
        node.getRootBlock().apply(this);
        ArrayList<BVHBehavior> bTmp = new ArrayList<BVHBehavior>();
        ArrayList<ChannelData> cTmp = new ArrayList<ChannelData>();
        for (BVHBlockData d : this.blockQueue) {
            bTmp.add(d.behavior);
            for (int i = 0; i < d.channels.length; ++i) {
                cTmp.add(d.channels[i]);
            }
        }
        this.behaviors = bTmp.toArray(new BVHBehavior[0]);
        this.channels = cTmp.toArray(new ChannelData[0]);
    }

    @Override
    public void caseARootBlock(ARootBlock node) {
        this.currentBlock = this.rootBlock = new BVHBlockData();
        this.blockQueue.add(this.currentBlock);
        this.currentBlock.identifier = node.getIdentifier().getText();
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        this.makeJ3DGroup();
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
    }

    @Override
    public void caseAOffsetLine(AOffsetLine node) {
        PNumber x_number = node.getXOffset();
        PNumber y_number = node.getYOffset();
        PNumber z_number = node.getZOffset();
        this.currentBlock.offsetX = this.pNumber2Double(x_number);
        this.currentBlock.offsetY = this.pNumber2Double(y_number);
        this.currentBlock.offsetZ = this.pNumber2Double(z_number);
    }

    @Override
    public void caseAChannelsLine(AChannelsLine node) {
        Object[] temp;
        TInteger integer = node.getInteger();
        int channelsCount = Integer.parseInt(integer.getText());
        if (channelsCount != (temp = node.getChannelType().toArray()).length) {
            System.out.println("ActionGenerator.caseAChannelsBlock()");
            System.out.println("pars error!!!");
        }
        ChannelData[] cds = new ChannelData[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            ChannelData cd = null;
            if (temp[i] instanceof AXPositionChannelType) {
                cd = new ChannelData("Xposition");
            } else if (temp[i] instanceof AYPositionChannelType) {
                cd = new ChannelData("Yposition");
            } else if (temp[i] instanceof AZPositionChannelType) {
                cd = new ChannelData("Zposition");
            } else if (temp[i] instanceof AXRotationChannelType) {
                cd = new ChannelData("Xrotation");
            } else if (temp[i] instanceof AYRotationChannelType) {
                cd = new ChannelData("Yrotation");
            } else if (temp[i] instanceof AZRotationChannelType) {
                cd = new ChannelData("Zrotation");
            } else if (temp[i] instanceof AXScaleChannelType) {
                cd = new ChannelData("Xscale");
            } else if (temp[i] instanceof AYScaleChannelType) {
                cd = new ChannelData("Yscale");
            } else if (temp[i] instanceof AZScaleChannelType) {
                cd = new ChannelData("Zscale");
            }
            cds[i] = cd;
        }
        this.currentBlock.channels = cds;
    }

    public void makeJ3DGroup() {
        BVHBehavior b;
        TransformGroup tg0 = new TransformGroup();
        Transform3D t0 = new Transform3D();
        t0.set(new Vector3d(this.currentBlock.offsetX, this.currentBlock.offsetY, this.currentBlock.offsetZ));
        tg0.setTransform(t0);
        TransformGroup tg1 = new TransformGroup();
        tg1.setCapability(18);
        Transform3D t1 = new Transform3D();
        tg1.setTransform(t1);
        ChannelData[] cds = this.currentBlock.channels;
        this.currentBlock.behavior = b = new BVHBehavior(this.currentBlock.identifier, tg1, t1, cds);
        b.setSchedulingBounds((Bounds)bs);
        tg1.addChild((Node)b);
        tg0.addChild((Node)tg1);
        Point3d[] vertex = new Point3d[]{new Point3d(0.0, 0.0, 0.0), new Point3d(this.currentBlock.offsetX, this.currentBlock.offsetY, this.currentBlock.offsetZ)};
        LineArray geometry = new LineArray(vertex.length, 5);
        geometry.setCoordinates(0, vertex);
        geometry.setColor(0, new Color3f(Color.blue));
        geometry.setColor(1, new Color3f(Color.red));
        Shape3D shape = new Shape3D((Geometry)geometry);
        if (this.rootGroup == null) {
            this.rootGroup = tg0;
            this.currentBlock.j3dGroup = tg1;
        } else {
            this.parentBlock.j3dGroup.addChild((Node)tg0);
            this.parentBlock.j3dGroup.addChild((Node)shape);
            this.currentBlock.j3dGroup = tg1;
        }
    }

    @Override
    public void caseAJointBlock(AJointBlock node) {
        this.blockStack.push(this.parentBlock);
        this.parentBlock = this.currentBlock;
        this.currentBlock = new BVHBlockData();
        this.blockQueue.add(this.currentBlock);
        this.currentBlock.identifier = node.getIdentifier().getText();
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        this.makeJ3DGroup();
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
        this.currentBlock = this.parentBlock;
        this.parentBlock = this.blockStack.pop();
    }

    @Override
    public void caseAEndSiteBlock(AEndSiteBlock node) {
        this.blockStack.push(this.parentBlock);
        this.parentBlock = this.currentBlock;
        this.currentBlock = new BVHBlockData();
        this.currentBlock.identifier = null;
        node.getOffsetLine().apply(this);
        this.makeJ3DGroup();
        this.currentBlock = this.parentBlock;
        this.parentBlock = this.blockStack.pop();
    }

    @Override
    public void caseAMotionPart(AMotionPart node) {
        int i;
        node.getFramesLine().apply(this);
        node.getFrameTimeLine().apply(this);
        Object[] temp = node.getNumber().toArray();
        if (temp.length != this.channels.length * this.frameCount) {
            System.out.println("ActionGenerator.caseAMotionPart().");
            System.out.println("parse error!!!");
            System.out.print(temp.length);
            System.out.print(" and " + this.channels.length * this.frameCount);
            System.out.println(" do not match.");
            return;
        }
        int tempCount = 0;
        for (i = 0; i < this.frameCount; ++i) {
            for (int j = 0; j < this.channels.length; ++j) {
                PNumber pn = (PNumber)temp[tempCount++];
                double d = this.pNumber2Double(pn);
                this.channels[j].add(new Double(d));
            }
        }
        for (i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].calc();
        }
    }

    @Override
    public void caseAFramesLine(AFramesLine node) {
        TInteger integer = node.getInteger();
        String is = integer.getText();
        this.frameCount = Integer.parseInt(is);
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].setFrameCount(this.frameCount);
        }
    }

    @Override
    public void caseAFrameTimeLine(AFrameTimeLine node) {
        PNumber num = node.getNumber();
        this.frameTime = this.pNumber2Double(num);
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].setFrameTime(this.frameTime);
        }
    }

    protected double pNumber2Double(PNumber num) {
        if (num instanceof ARealNumberNumber) {
            TRealNumber rn = ((ARealNumberNumber)num).getRealNumber();
            String rns = rn.getText();
            return Double.parseDouble(rns);
        }
        TInteger integer = ((AIntegerNumber)num).getInteger();
        int iii = Integer.parseInt(integer.getText());
        return iii;
    }
}

