/*
 * Decompiled with CFR 0.152.
 */
package org.ks1.j3dbvh;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.ks1.j3dbvh.BVHData;
import org.ks1.j3dbvh.BVHLoader;
import org.ks1.j3dbvh.SimpleMouseNavigationBehavior;

public class Viewer
implements ActionListener {
    Frame frame;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    Canvas3D canvas3D;
    JButton proxyButton;
    JLabel statusBarLabel;
    BranchGroup rootGroup;
    BranchGroup targetGroup;
    ProxyPanel proxyPanel = null;
    String[] proxyData = new String[]{"", "", "", ""};

    public Viewer(String[] args) {
        this.frame = new Frame("j3dbvh Viewer");
        Box baseBox = Box.createVerticalBox();
        this.frame.add(baseBox);
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        this.urlTextField = new JTextField();
        try {
            File f = new File(args[0]);
            URL url = f.toURL();
            this.urlTextField.setText(url.toExternalForm());
        }
        catch (Exception e) {
            this.urlTextField.setText("file:///error.bvh");
        }
        this.urlTextField.addActionListener(this);
        this.urlTextField.setMaximumSize(new Dimension(3000, 30));
        box1.add(this.urlTextField);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        box1.add(this.refButton);
        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);
        this.canvas3D = this.makeCanvas3D();
        box2.add((Component)this.canvas3D);
        Box controlBox = this.makeControlBox();
        box2.add(controlBox);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.add(this.statusBarLabel);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                Viewer.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.loadBVH();
    }

    Canvas3D makeCanvas3D() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration[] gcs = gd.getConfigurations();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gc = gct3d.getBestConfiguration(gcs);
        Canvas3D canvas3D = new Canvas3D(gc);
        canvas3D.setSize(300, 300);
        PhysicalBody physicalBody = new PhysicalBody();
        PhysicalEnvironment physicalEnvironment = new PhysicalEnvironment();
        BranchGroup branchGroupForViewPlatform = new BranchGroup();
        Transform3D transform3DForViewPlatform = new Transform3D();
        transform3DForViewPlatform.set(new Vector3f(0.0f, 0.0f, 2.0f));
        ViewPlatform viewPlatform = new ViewPlatform();
        TransformGroup transformGroupForViewPlatform = new TransformGroup(transform3DForViewPlatform);
        transformGroupForViewPlatform.addChild((Node)viewPlatform);
        branchGroupForViewPlatform.addChild((Node)transformGroupForViewPlatform);
        DirectionalLight light = new DirectionalLight();
        light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        branchGroupForViewPlatform.addChild((Node)light);
        View view = new View();
        view.addCanvas3D(canvas3D);
        view.setPhysicalBody(physicalBody);
        view.setPhysicalEnvironment(physicalEnvironment);
        view.attachViewPlatform(viewPlatform);
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        Locale locale = new Locale(virtualUniverse);
        BranchGroup topGroup = new BranchGroup();
        TransformGroup tg = new TransformGroup();
        tg.setCapability(18);
        topGroup.addChild((Node)tg);
        Transform3D t = new Transform3D();
        tg.setTransform(t);
        SimpleMouseNavigationBehavior smnb = new SimpleMouseNavigationBehavior(tg, t);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        smnb.setSchedulingBounds((Bounds)bs);
        topGroup.addChild((Node)smnb);
        this.rootGroup = new BranchGroup();
        this.rootGroup.setCapability(12);
        this.rootGroup.setCapability(14);
        this.rootGroup.setCapability(13);
        tg.addChild((Node)this.rootGroup);
        locale.addBranchGraph(branchGroupForViewPlatform);
        locale.addBranchGraph(topGroup);
        return canvas3D;
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();
        this.proxyButton = new JButton("Proxy Configuration");
        this.proxyButton.addActionListener(this);
        controlBox.add(this.proxyButton);
        controlBox.add(Box.createVerticalGlue());
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.urlTextField) {
            this.loadBVH();
        } else if (ae.getSource() == this.proxyButton) {
            this.proxyConfig();
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        }
    }

    void loadBVH() {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        String urlString = this.urlTextField.getText();
        BVHData bvh = BVHLoader.load(urlString);
        if (this.targetGroup != null) {
            this.targetGroup.detach();
        }
        this.targetGroup = new BranchGroup();
        this.targetGroup.setCapability(17);
        Node n = bvh.getNode();
        this.targetGroup.addChild(n);
        this.rootGroup.addChild((Node)this.targetGroup);
        bvh.start();
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    void proxyConfig() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new ProxyPanel();
        }
        this.proxyPanel.setData(this.proxyData);
        Object[] options = new Object[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, this.proxyPanel, "proxy", -1, 1, null, options, options[0]);
        if (result == 0) {
            this.proxyData = this.proxyPanel.getData();
            if (!this.proxyData[0].equals("")) {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", this.proxyData[0]);
                System.getProperties().put("proxyPort", this.proxyData[1]);
            } else {
                System.getProperties().put("proxySet", "false");
            }
            if (!this.proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet", "true");
                System.getProperties().put("ftpProxyHost", this.proxyData[2]);
                System.getProperties().put("ftpProxyPort", this.proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet", "false");
            }
        }
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = f.toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        this.loadBVH();
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        final String[] argCopy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Viewer(argCopy);
            }
        });
    }

    class ProxyPanel
    extends JPanel {
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();
            this.add(b0);
            b0.add(b1);
            b0.add(b2);
            b1.add(new JLabel("http: host"));
            this.httpHostTF = new JTextField(40);
            b1.add(this.httpHostTF);
            b1.add(new JLabel(" port "));
            this.httpPortTF = new JTextField(5);
            b1.add(this.httpPortTF);
            b2.add(new JLabel("ftp: host"));
            this.ftpHostTF = new JTextField(40);
            b2.add(this.ftpHostTF);
            b2.add(new JLabel(" port "));
            this.ftpPortTF = new JTextField(5);
            b2.add(this.ftpPortTF);
        }

        public void setData(String[] proxyData) {
            this.httpHostTF.setText(proxyData[0]);
            this.httpPortTF.setText(proxyData[1]);
            this.ftpHostTF.setText(proxyData[2]);
            this.ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String[] ret = new String[]{this.httpHostTF.getText(), this.httpPortTF.getText(), this.ftpHostTF.getText(), this.ftpPortTF.getText()};
            return ret;
        }
    }
}

