/*
 * Decompiled with CFR 0.152.
 */
package org.ks1.j3dbvh;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SimpleMouseNavigationBehavior
extends Behavior {
    TransformGroup tg;
    Transform3D t;
    Quat4d q = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d v = new Vector3d(0.0, 0.0, 0.0);
    double s = 1.0;
    int pressedX;
    int pressedY;
    int mouseX;
    int mouseY;
    long pressedTime;
    int mode;
    static final int ROTATION_MODE = 0;
    static final int TRANSLATION_MODE = 1;
    static final int SCALING_MODE = 2;

    public SimpleMouseNavigationBehavior(TransformGroup tg, Transform3D t) {
        this.tg = tg;
        this.t = t;
        this.s = t.get(this.q, this.v);
    }

    public void initialize() {
        this.t.set(this.q, this.v, this.s);
        this.tg.setTransform(this.t);
        WakeupOnAWTEvent w = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupOnAWTEvent w = (WakeupOnAWTEvent)criteria.nextElement();
            AWTEvent[] e = w.getAWTEvent();
            for (int i = 0; i < e.length; ++i) {
                if (e[i].getID() == 501) {
                    this.processMousePressed((MouseEvent)e[i]);
                    continue;
                }
                if (e[i].getID() == 506) {
                    this.processMouseDragged((MouseEvent)e[i]);
                    continue;
                }
                if (e[i].getID() != 502) continue;
                this.processMouseReleased((MouseEvent)e[i]);
            }
        }
    }

    void processMousePressed(MouseEvent me) {
        this.pressedX = me.getX();
        this.pressedY = me.getY();
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.pressedTime = System.currentTimeMillis();
        if (me.getButton() == 1) {
            this.mode = 0;
        } else if (me.getButton() == 2) {
            this.mode = 1;
        } else if (me.getButton() == 3) {
            this.mode = 2;
        }
        WakeupOnAWTEvent[] ws = new WakeupOnAWTEvent[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(502)};
        WakeupOr w = new WakeupOr((WakeupCriterion[])ws);
        this.wakeupOn((WakeupCondition)w);
    }

    void processMouseDragged(MouseEvent me) {
        double dX = me.getX() - this.mouseX;
        double dY = me.getY() - this.mouseY;
        if (this.mode == 0) {
            double cos = Math.cos(dX * Math.PI / 180.0 / 2.0);
            double sin = Math.sin(dX * Math.PI / 180.0 / 2.0);
            Quat4d qTmp = new Quat4d(0.0, sin, 0.0, cos);
            qTmp.mul(this.q);
            this.q = qTmp;
            cos = Math.cos(dY * Math.PI / 180.0 / 2.0);
            sin = Math.sin(dY * Math.PI / 180.0 / 2.0);
            qTmp = new Quat4d(sin, 0.0, 0.0, cos);
            qTmp.mul(this.q);
            this.q = qTmp;
        } else if (this.mode == 1) {
            double tx = 0.0;
            double ty = 0.0;
            double tz = 0.0;
            if ((me.getModifiers() & 1) != 0) {
                tx = dX * this.s / 100.0;
                tz = dY * this.s / 100.0;
            } else {
                tx = dX * this.s / 100.0;
                ty = -dY * this.s / 100.0;
            }
            this.v.add((Tuple3d)new Vector3d(tx, ty, tz));
        } else if (this.mode == 2) {
            this.s -= this.s * dY / 100.0;
        }
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.t.set(this.q, this.v, this.s);
        this.tg.setTransform(this.t);
        WakeupOnAWTEvent[] ws = new WakeupOnAWTEvent[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(502)};
        WakeupOr w = new WakeupOr((WakeupCriterion[])ws);
        this.wakeupOn((WakeupCondition)w);
    }

    void processMouseReleased(MouseEvent me) {
        WakeupOnAWTEvent w = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)w);
    }
}

