/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3applet;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Object;

class MyExamController
extends A3Controller {
    A3Object targetA3;
    Tuple3d lastPhysicalV = null;
    int lastMouseX;
    int lastMouseY;

    MyExamController() {
    }

    void setA3(A3Object a3) {
        this.targetA3 = a3;
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
        A3Object a3 = ae.getA3Object();
        if (a3 != null) {
            Vector3d v = new Vector3d();
            v.sub((Tuple3d)a3.getLoc(), (Tuple3d)this.a3canvas.getCameraLoc());
            v = this.a3canvas.virtualCSToPhysicalCS(v);
            this.lastPhysicalV = this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), -v.z);
        } else {
            this.lastPhysicalV = null;
        }
    }

    @Override
    public void mouseDragged(A3Event ae) {
        if (this.targetA3 == null) {
            return;
        }
        MouseEvent me = ae.getMouseEvent();
        int shiftX = me.getX() - this.lastMouseX;
        int shiftY = me.getY() - this.lastMouseY;
        if ((me.getModifiersEx() & 0x400) != 0) {
            Vector3d selectedV = new Vector3d(0.0, 0.0, 0.0);
            Vector3d tmpV = new Vector3d();
            tmpV.sub((Tuple3d)this.a3canvas.getCameraLoc(), (Tuple3d)selectedV);
            Quat4d q0 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            double t = (double)shiftX * 0.01;
            Quat4d q1 = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
            t = (double)shiftY * 0.01;
            Quat4d q2 = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
            q0.mul(q1);
            q0.mul(q2);
            Quat4d cameraQ = this.a3canvas.getCameraQuat();
            q1.set(q0.x, q0.y, q0.z, 0.0);
            q2.mul(cameraQ, q1);
            cameraQ.conjugate();
            q2.mul(cameraQ);
            q0.x = q2.x;
            q0.y = q2.y;
            q0.z = q2.z;
            q0.mul(this.targetA3.getQuat());
            this.targetA3.setQuat(q0);
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            if (this.lastPhysicalV != null) {
                Vector3d v = new Vector3d();
                v.sub((Tuple3d)this.targetA3.getLoc(), (Tuple3d)this.a3canvas.getCameraLoc());
                v = this.a3canvas.virtualCSToPhysicalCS(v);
                Point3d nowPhysicalV = this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), -v.z);
                v.sub((Tuple3d)nowPhysicalV, this.lastPhysicalV);
                if ((me.getModifiers() & 1) != 0) {
                    v = new Vector3d(v.x, 0.0, -v.y);
                }
                v = this.a3canvas.physicalCSToVirtualCS(v);
                v.add((Tuple3d)this.targetA3.getLoc());
                this.targetA3.setLocImmediately(v.x, v.y, v.z);
                this.lastPhysicalV.set((Tuple3d)nowPhysicalV);
            }
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            double s = this.targetA3.getScale() * (double)(100 - shiftY) / 100.0;
            this.targetA3.setScale(s);
        }
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    @Override
    public void mouseReleased(A3Event e) {
    }

    @Override
    public void mouseClicked(A3Event ae) {
        this.turnToOrigin();
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    void turnToOrigin() {
        Vector3d selectedV = new Vector3d();
        if (this.targetA3 != null) {
            selectedV.set((Tuple3d)this.targetA3.getLoc());
        } else {
            selectedV.set(0.0, 0.0, 0.0);
        }
        Quat4d tmpQ1 = this.a3canvas.getCameraQuat();
        Quat4d tmpQ2 = new Quat4d(0.0, 0.0, -1.0, 0.0);
        Quat4d tmpQ3 = new Quat4d();
        tmpQ3.mul(tmpQ1, tmpQ2);
        tmpQ1.conjugate();
        tmpQ3.mul(tmpQ1);
        Vector3d tmpV1 = new Vector3d(tmpQ3.x, tmpQ3.y, tmpQ3.z);
        Vector3d tmpV2 = new Vector3d();
        tmpV2.sub((Tuple3d)selectedV, (Tuple3d)this.a3canvas.getCameraLoc());
        if (tmpV2.length() < 1.0E-5) {
            System.out.println("x");
            return;
        }
        tmpV2.normalize();
        Vector3d tmpV3 = new Vector3d();
        tmpV3.cross(tmpV1, tmpV2);
        if (tmpV3.length() < 1.0E-5) {
            System.out.println("X");
            return;
        }
        tmpV3.normalize();
        double t = 0.5 * Math.acos(tmpV1.dot(tmpV2));
        double st = Math.sin(t);
        double ct = Math.cos(t);
        Quat4d q = new Quat4d(st * tmpV3.x, st * tmpV3.y, st * tmpV3.z, ct);
        tmpQ1.set((Tuple4d)this.a3canvas.getCameraQuat());
        q.mul(tmpQ1);
        this.a3canvas.setCameraQuatImmediately(q);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

