/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.TimerBehavior;

class A3Behavior
extends Behavior {
    static Vector3d vFront = new Vector3d(0.0, 0.0, 1.0);
    static Vector3d vTop = new Vector3d(0.0, 1.0, 0.0);
    static long elapsedTime = 100L;
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3Canvas canvas = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;

    A3Behavior(A3Object a) {
        this.a3 = a;
        this.topGroup = new A3BranchGroup();
        this.topGroup.setA3(this.a3);
        this.t = new Transform3D();
        this.transGroup = new TransformGroup(this.t);
        this.transGroup.setCapability(18);
        this.transGroup.addChild((Node)this);
        this.topGroup.addChild((Node)this.transGroup);
    }

    void setA3Canvas(A3Canvas c) {
        this.canvas = c;
    }

    void setNode(Node n) {
        this.transGroup.addChild(n);
    }

    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        if (this.canvas == null) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            this.wakeupOn((WakeupCondition)w);
        } else {
            WakeupOnBehaviorPost w = new WakeupOnBehaviorPost((Behavior)this.canvas.timerBehavior, 1);
            this.wakeupOn((WakeupCondition)w);
        }
        if (!this.needRecalc) {
            return;
        }
        this.nowS += 0.2 * (this.nextS - this.nowS);
        if (this.autoDirectionControl) {
            this.autoQuatControl();
        } else {
            this.nowQ.normalize();
            this.nowQ.interpolate(this.nextQ, 0.2);
            this.nowQ.normalize();
        }
        this.nowV.interpolate((Tuple3d)this.nextV, 0.2);
        this.t.set(this.nowQ, this.nowV, this.nextS);
        this.transGroup.setTransform(this.t);
        if (!this.isInterpolate) {
            this.needRecalc = false;
        }
    }

    void autoQuatControl() {
        Vector3d dv = new Vector3d();
        dv.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        double ls = dv.lengthSquared();
        if (ls > 0.001) {
            double d = dv.dot(vTop);
            Vector3d vTmp1 = new Vector3d(vTop);
            vTmp1.scale(d);
            Vector3d vTmp2 = new Vector3d(dv);
            vTmp2.sub((Tuple3d)vTmp1);
            if (vTmp2.length() < 1.0E-5) {
                vTmp1.cross(vFront, vTop);
                AxisAngle4d angle = new AxisAngle4d(vTmp1.x, vTmp1.y, vTmp1.z, 1.5707963267948966);
                this.nowQ.set(angle);
            } else {
                AxisAngle4d an = null;
                vTmp2.normalize();
                d = Math.acos(0.999999 * vTmp2.dot(vFront));
                vTmp1.cross(vTmp2, vFront);
                if (vTmp1.lengthSquared() < 1.0E-4) {
                    vTmp1.set((Tuple3d)vTop);
                }
                an = new AxisAngle4d(vTmp1.x, vTmp1.y, vTmp1.z, -d);
                this.nowQ.set(an);
                dv.normalize();
                d = Math.acos(0.999999 * dv.dot(vTmp2));
                vTmp1.cross(dv, vTmp2);
                if (vTmp1.lengthSquared() < 1.0E-4) {
                    vTmp1.set((Tuple3d)vFront);
                }
                an = new AxisAngle4d(vTmp1.x, vTmp1.y, vTmp1.z, -d);
                Quat4d qTmp = new Quat4d();
                qTmp.set(an);
                this.nowQ.mul(qTmp, this.nowQ);
            }
        }
    }

    void setEnableBehavior(boolean b) {
        this.isInterpolate = b;
    }

    void setAutoDirectionControl(boolean b) {
        this.autoDirectionControl = b;
    }

    void move(Vector3d v, Quat4d q, double s) {
        if (this.isInterpolate) {
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
            this.nextQ.normalize();
        } else {
            this.nowS = s;
            this.nowV.set((Tuple3d)v);
            this.nowQ.set((Tuple4d)q);
            this.nextS = s;
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.nowS = s;
        this.nowV.set((Tuple3d)v);
        this.nowQ.set((Tuple4d)q);
        this.nextS = s;
        this.nextV.set((Tuple3d)v);
        this.nextQ.set((Tuple4d)q);
        this.t.set(this.nowQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    void setLoc(Vector3d v) {
        if (this.isInterpolate) {
            this.nextV.set((Tuple3d)v);
        } else {
            this.nowV.set((Tuple3d)v);
            this.nextV.set((Tuple3d)v);
        }
        this.needRecalc = true;
    }

    void setLocImmediately(Vector3d v) {
        this.nowV.set((Tuple3d)v);
        this.nextV.set((Tuple3d)v);
        this.t.set(this.nowQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    Vector3d getLoc() {
        return new Vector3d(this.nowV);
    }

    void setQuat(Quat4d q) {
        if (this.isInterpolate) {
            this.nextQ.set((Tuple4d)q);
        } else {
            this.nowQ.set((Tuple4d)q);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setQuatImmediately(Quat4d q) {
        this.nowQ.set((Tuple4d)q);
        this.nextQ.set((Tuple4d)q);
        this.t.set(this.nowQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    Quat4d getQuat() {
        return new Quat4d(this.nowQ);
    }

    void setScale(double s) {
        if (this.isInterpolate) {
            this.nextS = s;
        } else {
            this.nowS = s;
            this.nextS = s;
        }
        this.needRecalc = true;
    }

    void setScaleImmediately(double s) {
        this.nowS = s;
        this.nextS = s;
        this.t.set(this.nowQ, this.nowV, this.nowS);
        this.transGroup.setTransform(this.t);
    }

    double getScale() {
        return this.nowS;
    }

    double getSpeed() {
        if (this.isInterpolate) {
            Vector3d tmpV = new Vector3d();
            tmpV.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
            double d = tmpV.length();
            double t = this.canvas != null ? (double)TimerBehavior.elapsedTime / 1000.0 : (double)elapsedTime / 1000.0;
            return d / t;
        }
        return 0.0;
    }
}

