/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class RZipURLConnection
extends URLConnection {
    String internalURL = null;
    String entryName = null;
    int size = -1;
    InputStream inputStream = null;

    public RZipURLConnection(URL url) {
        super(url);
        String urlString = url.toExternalForm();
        this.entryName = urlString.substring(urlString.lastIndexOf(33) + 1);
        this.internalURL = urlString.substring(0, urlString.lastIndexOf(33));
        this.internalURL = this.internalURL.substring(7);
        this.internalURL = this.checkInternalURL(this.internalURL);
        if (this.internalURL.startsWith("x-res://") && !this.internalURL.startsWith("x-res:///")) {
            this.internalURL = "x-res:///" + this.internalURL.substring(8);
        }
    }

    @Override
    public void connect() throws IOException {
        int len;
        ZipEntry ze;
        InputStream is = new URL(this.internalURL).openStream();
        ZipInputStream zis = new ZipInputStream(is);
        if (this.entryName.startsWith("/")) {
            this.entryName = this.entryName.substring(1);
        }
        do {
            if ((ze = zis.getNextEntry()) != null) continue;
            throw new IOException();
        } while (!ze.getName().equals(this.entryName));
        BufferedInputStream bis = new BufferedInputStream(zis);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        byte[] buf = new byte[1024];
        while ((len = bis.read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        bos.flush();
        bos.close();
        bis.close();
        byte[] b = baos.toByteArray();
        this.size = b.length;
        this.inputStream = new BufferedInputStream(new ByteArrayInputStream(b));
        this.connected = true;
    }

    @Override
    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.inputStream == null) {
            throw new IOException();
        }
        return this.inputStream;
    }

    String checkInternalURL(String s) {
        if (s.startsWith("file://") && !s.startsWith("file:///")) {
            return "file:///" + s.substring(7);
        }
        return s;
    }
}

