/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import org.jdesktop.j3d.loaders.vrml97.impl.BindableNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.MFString;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFTime;

public class NavigationInfo
extends BindableNode {
    MFFloat avatarSize;
    SFBool headlight;
    SFFloat speed;
    MFString type;
    SFFloat visibilityLimit;

    public NavigationInfo(Loader loader) {
        super(loader, loader.getNavigationInfoStack());
        String[] navTypes = new String[]{new String("EXAMINE")};
        float[] av = new float[]{0.25f, 1.6f, 0.75f};
        this.avatarSize = new MFFloat(av);
        this.headlight = new SFBool(true);
        this.speed = new SFFloat(1.0f);
        this.type = new MFString(navTypes);
        this.visibilityLimit = new SFFloat(0.0f);
        loader.addNavigationInfo(this);
        this.initFields();
    }

    public NavigationInfo(Loader loader, SFBool bind, SFTime bindTime, SFBool isBound, MFFloat avatarSize, SFBool healdlight, SFFloat speed, MFString type, SFFloat visibilityLimit) {
        super(loader, loader.getNavigationInfoStack(), bind, bindTime, isBound);
        this.bind = bind;
        this.bindTime = bindTime;
        this.avatarSize = avatarSize;
        this.headlight = this.headlight;
        this.speed = speed;
        this.type = type;
        this.visibilityLimit = visibilityLimit;
        loader.addNavigationInfo(this);
        this.initFields();
    }

    public void notifyMethod(String eventInName, double time) {
        NavigationInfo top;
        if (eventInName.equals("bind")) {
            super.notifyMethod(eventInName, time);
        } else if (!this.browser.navigationInfoStack.empty() && (top = (NavigationInfo)this.browser.navigationInfoStack.peek()) == this) {
            System.out.println("navigation updateView");
            this.browser.updateView();
        }
    }

    public String getType() {
        return "NavigationInfo";
    }

    public Object clone() {
        return new NavigationInfo(this.loader, (SFBool)this.bind.clone(), (SFTime)this.bindTime.clone(), (SFBool)this.isBound.clone(), (MFFloat)this.avatarSize.clone(), (SFBool)this.headlight.clone(), (SFFloat)this.speed.clone(), (MFString)this.type.clone(), (SFFloat)this.visibilityLimit.clone());
    }

    void initFields() {
        this.initBindableFields();
        this.speed.init(this, this.FieldSpec, 3, "speed");
        this.headlight.init(this, this.FieldSpec, 3, "headlight");
        this.avatarSize.init(this, this.FieldSpec, 3, "avatarSize");
        this.type.init(this, this.FieldSpec, 3, "type");
        this.visibilityLimit.init(this, this.FieldSpec, 3, "visibilityLimit");
    }
}

