/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Material;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.TextureSrc;
import org.jdesktop.j3d.loaders.vrml97.impl.TextureTransform;

public class Appearance
extends Node {
    javax.media.j3d.Appearance impl;
    SFNode material;
    SFNode texture;
    SFNode textureTransform;
    boolean haveTexture = false;
    int numUses = 0;
    TexCoordGeneration texGen;
    TextureAttributes ta = new TextureAttributes();
    Transform3D tr = new Transform3D();
    Transform3D T = new Transform3D();
    Transform3D C = new Transform3D();
    Transform3D R = new Transform3D();
    Transform3D S = new Transform3D();
    Vector3d v1 = new Vector3d();
    Vector3d v2 = new Vector3d();
    Vector3d v3 = new Vector3d();
    Vector3d v4 = new Vector3d();
    AxisAngle4f al = new AxisAngle4f();

    public Appearance(Loader loader) {
        super(loader);
        this.material = new SFNode(null);
        this.texture = new SFNode(null);
        this.textureTransform = new SFNode(null);
        this.initFields();
    }

    Appearance(Loader loader, SFNode material, SFNode texture, SFNode textureTransform) {
        super(loader);
        this.material = material;
        this.texture = texture;
        this.textureTransform = textureTransform;
        this.initFields();
    }

    private void updateMaterial() {
        if (this.material.node != null) {
            this.impl.setMaterial(((Material)this.material.node).impl);
            this.impl.setTransparencyAttributes(((Material)this.material.node).implTransp);
        }
    }

    private void updateTexture() {
        Texture tex;
        this.haveTexture = false;
        if (this.texture.node != null && (tex = ((TextureSrc)((Object)this.texture.node)).getImplTexture()) != null) {
            this.impl.setTexture(tex);
            tex.setEnable(true);
            this.haveTexture = true;
        }
    }

    void updateTextureTransform() {
        if (this.textureTransform.node != null) {
            ((TextureTransform)this.textureTransform.node).owner = this;
            TextureTransform tf = (TextureTransform)this.textureTransform.node;
            double tx = tf.translation.vec2f[0];
            double ty = tf.translation.vec2f[0];
            this.v1.set(tx, ty, 0.0);
            this.T.set(this.v1);
            double cx = tf.center.vec2f[0];
            double cy = tf.center.vec2f[1];
            this.v2.set(cx, cy, 0.0);
            this.C.set(this.v2);
            double r = tf.rotation.value;
            this.al.set(0.0f, 0.0f, 1.0f, (float)r);
            this.R.setRotation(this.al);
            double sx = tf.scale.vec2f[0];
            double sy = tf.scale.vec2f[1];
            this.v3.set(sx, sy, 1.0);
            this.S.setScale(this.v3);
            this.tr.setIdentity();
            this.tr.mul(this.T);
            this.tr.mul(this.C);
            this.tr.mul(this.R);
            this.tr.mul(this.S);
            this.v2.negate();
            this.C.set(this.v2);
            this.tr.mul(this.C);
            this.ta.setTextureTransform(this.tr);
            this.impl.setTextureAttributes(this.ta);
        }
    }

    public void setTexGen(BoundingBox box) {
        Vector4f tEq;
        Vector4f sEq;
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        box.getLower(min);
        box.getUpper(max);
        float xRange = (float)(max.x - min.x);
        float yRange = (float)(max.y - min.y);
        float zRange = (float)(max.z - min.z);
        Vector4f xEq = new Vector4f(1.0f / xRange, 0.0f, 0.0f, (float)(-min.x) / xRange);
        Vector4f yEq = new Vector4f(0.0f, 1.0f / yRange, 0.0f, (float)(-min.y) / xRange);
        Vector4f zEq = new Vector4f(0.0f, 0.0f, 1.0f / zRange, (float)(-min.z) / xRange);
        if (xRange >= yRange) {
            if (xRange >= zRange) {
                sEq = xEq;
                tEq = yRange >= zRange ? yEq : zEq;
            } else {
                sEq = zEq;
                tEq = xEq;
            }
        } else if (yRange >= zRange) {
            sEq = yEq;
            tEq = xRange >= zRange ? xEq : zEq;
        } else {
            sEq = zEq;
            tEq = yEq;
        }
        this.texGen = new TexCoordGeneration(0, 0, sEq, tEq);
        this.impl.setTexCoordGeneration(this.texGen);
        this.texGen.setEnable(true);
    }

    public void initImpl() {
        this.impl = new javax.media.j3d.Appearance();
        this.updateMaterial();
        this.updateTexture();
        this.updateTextureTransform();
        this.implReady = true;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("material")) {
            this.updateMaterial();
        } else if (eventInName.equals("texture")) {
            this.updateTexture();
        } else if (eventInName.equals("textureTransform")) {
            if (this.textureTransform.node != null) {
                System.err.println("Appearance: textureTransform not implemented");
            }
        } else if (eventInName.equals("route_material")) {
            this.impl.setCapability(1);
        } else if (eventInName.equals("route_texture")) {
            this.impl.setCapability(3);
        } else if (eventInName.equals("route_textureTransform")) {
            this.impl.setCapability(7);
        } else {
            System.err.println("Appearance: unknown eventInName " + eventInName);
        }
    }

    public Object clone() {
        Appearance a = new Appearance(this.loader, (SFNode)this.material.clone(), (SFNode)this.texture.clone(), (SFNode)this.textureTransform.clone());
        return a;
    }

    public String getType() {
        return "Appearance";
    }

    void initFields() {
        this.material.init(this, this.FieldSpec, 3, "material");
        this.texture.init(this, this.FieldSpec, 3, "texture");
        this.textureTransform.init(this, this.FieldSpec, 3, "textureTransform");
    }
}

