/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3.bvh.parser;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import jp.sourceforge.acerola3d.a3.bvh.analysis.Analysis;
import jp.sourceforge.acerola3d.a3.bvh.analysis.AnalysisAdapter;
import jp.sourceforge.acerola3d.a3.bvh.lexer.Lexer;
import jp.sourceforge.acerola3d.a3.bvh.lexer.LexerException;
import jp.sourceforge.acerola3d.a3.bvh.node.ABvh;
import jp.sourceforge.acerola3d.a3.bvh.node.AChannelsLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AEndSiteBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AEndSiteSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AFrameTimeLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AFramesLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AHierarchyPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AIntegerNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.AJointBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AJointSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AMotionPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AOffsetLine;
import jp.sourceforge.acerola3d.a3.bvh.node.ARealNumberNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.ARootBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AXPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.EOF;
import jp.sourceforge.acerola3d.a3.bvh.node.Node;
import jp.sourceforge.acerola3d.a3.bvh.node.NodeCast;
import jp.sourceforge.acerola3d.a3.bvh.node.PBvh;
import jp.sourceforge.acerola3d.a3.bvh.node.PChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.PChannelsLine;
import jp.sourceforge.acerola3d.a3.bvh.node.PEndSiteBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.PFrameTimeLine;
import jp.sourceforge.acerola3d.a3.bvh.node.PFramesLine;
import jp.sourceforge.acerola3d.a3.bvh.node.PHierarchyPart;
import jp.sourceforge.acerola3d.a3.bvh.node.PJointBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.PMotionPart;
import jp.sourceforge.acerola3d.a3.bvh.node.PNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.POffsetLine;
import jp.sourceforge.acerola3d.a3.bvh.node.PRootBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.PSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.Start;
import jp.sourceforge.acerola3d.a3.bvh.node.Switchable;
import jp.sourceforge.acerola3d.a3.bvh.node.TChannels;
import jp.sourceforge.acerola3d.a3.bvh.node.TEndSite;
import jp.sourceforge.acerola3d.a3.bvh.node.TFrameTime;
import jp.sourceforge.acerola3d.a3.bvh.node.TFrames;
import jp.sourceforge.acerola3d.a3.bvh.node.THierarchy;
import jp.sourceforge.acerola3d.a3.bvh.node.TIdentifier;
import jp.sourceforge.acerola3d.a3.bvh.node.TInteger;
import jp.sourceforge.acerola3d.a3.bvh.node.TJoint;
import jp.sourceforge.acerola3d.a3.bvh.node.TLBrace;
import jp.sourceforge.acerola3d.a3.bvh.node.TMotion;
import jp.sourceforge.acerola3d.a3.bvh.node.TOffset;
import jp.sourceforge.acerola3d.a3.bvh.node.TRBrace;
import jp.sourceforge.acerola3d.a3.bvh.node.TRealNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.TRoot;
import jp.sourceforge.acerola3d.a3.bvh.node.TXPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TXRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TXScale;
import jp.sourceforge.acerola3d.a3.bvh.node.TYPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TYRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TYScale;
import jp.sourceforge.acerola3d.a3.bvh.node.TZPosition;
import jp.sourceforge.acerola3d.a3.bvh.node.TZRotation;
import jp.sourceforge.acerola3d.a3.bvh.node.TZScale;
import jp.sourceforge.acerola3d.a3.bvh.node.Token;
import jp.sourceforge.acerola3d.a3.bvh.node.TypedLinkedList;
import jp.sourceforge.acerola3d.a3.bvh.node.X1PChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.X1PNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.X1PSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.X2PChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.X2PNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.X2PSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.XPChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.XPNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.XPSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.parser.ParserException;
import jp.sourceforge.acerola3d.a3.bvh.parser.State;
import jp.sourceforge.acerola3d.a3.bvh.parser.TokenIndex;

public class Parser {
    public final Analysis ignoredTokens = new AnalysisAdapter();
    protected Node node;
    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_shift;
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];
    private static final int SHIFT = 0;
    private static final int REDUCE = 1;
    private static final int ACCEPT = 2;
    private static final int ERROR = 3;
    private static int[][][] actionTable;
    private static int[][][] gotoTable;
    private static String[] errorMessages;
    private static int[] errors;

    protected void filter() throws ParserException, LexerException, IOException {
    }

    public Parser(Lexer lexer) {
        this.lexer = lexer;
        if (actionTable == null) {
            try {
                int k;
                int j;
                int i;
                DataInputStream s = new DataInputStream(new BufferedInputStream(Parser.class.getResourceAsStream("parser.dat")));
                int length = s.readInt();
                actionTable = new int[length][][];
                for (i = 0; i < actionTable.length; ++i) {
                    length = s.readInt();
                    Parser.actionTable[i] = new int[length][3];
                    for (j = 0; j < actionTable[i].length; ++j) {
                        for (k = 0; k < 3; ++k) {
                            Parser.actionTable[i][j][k] = s.readInt();
                        }
                    }
                }
                length = s.readInt();
                gotoTable = new int[length][][];
                for (i = 0; i < gotoTable.length; ++i) {
                    length = s.readInt();
                    Parser.gotoTable[i] = new int[length][2];
                    for (j = 0; j < gotoTable[i].length; ++j) {
                        for (k = 0; k < 2; ++k) {
                            Parser.gotoTable[i][j][k] = s.readInt();
                        }
                    }
                }
                length = s.readInt();
                errorMessages = new String[length];
                for (i = 0; i < errorMessages.length; ++i) {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();
                    for (int j2 = 0; j2 < length; ++j2) {
                        buffer.append(s.readChar());
                    }
                    Parser.errorMessages[i] = buffer.toString();
                }
                length = s.readInt();
                errors = new int[length];
                for (i = 0; i < errors.length; ++i) {
                    Parser.errors[i] = s.readInt();
                }
                s.close();
            }
            catch (Exception e) {
                throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
            }
        }
    }

    private int goTo(int index) {
        int state = this.state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];
        while (low <= high) {
            int middle = (low + high) / 2;
            if (state < gotoTable[index][middle][0]) {
                high = middle - 1;
                continue;
            }
            if (state > gotoTable[index][middle][0]) {
                low = middle + 1;
                continue;
            }
            value = gotoTable[index][middle][1];
            break;
        }
        return value;
    }

    private void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException {
        this.node = node;
        if (filter) {
            this.filter();
        }
        if (!this.stack.hasNext()) {
            this.stack.add(new State(state, this.node));
            return;
        }
        State s = (State)this.stack.next();
        s.state = state;
        s.node = this.node;
    }

    private int state() {
        State s = (State)this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private Node pop() {
        return (Node)((State)this.stack.previous()).node;
    }

    private int index(Switchable token) {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

    public Start parse() throws ParserException, LexerException, IOException {
        this.push(0, null, false);
        TypedLinkedList ign = null;
        while (true) {
            if (this.index(this.lexer.peek()) == -1) {
                if (ign == null) {
                    ign = new TypedLinkedList(NodeCast.instance);
                }
                ign.add(this.lexer.next());
                continue;
            }
            if (ign != null) {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }
            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();
            int index = this.index(this.lexer.peek());
            this.action[0] = actionTable[this.state()][0][1];
            this.action[1] = actionTable[this.state()][0][2];
            int low = 1;
            int high = actionTable[this.state()].length - 1;
            while (low <= high) {
                int middle = (low + high) / 2;
                if (index < actionTable[this.state()][middle][0]) {
                    high = middle - 1;
                    continue;
                }
                if (index > actionTable[this.state()][middle][0]) {
                    low = middle + 1;
                    continue;
                }
                this.action[0] = actionTable[this.state()][middle][1];
                this.action[1] = actionTable[this.state()][middle][2];
                break;
            }
            block0 : switch (this.action[0]) {
                case 0: {
                    this.push(this.action[1], this.lexer.next(), true);
                    this.last_shift = this.action[1];
                    break;
                }
                case 1: {
                    switch (this.action[1]) {
                        case 0: {
                            Node node = this.new0();
                            this.push(this.goTo(0), node, true);
                            break block0;
                        }
                        case 1: {
                            Node node = this.new1();
                            this.push(this.goTo(1), node, true);
                            break block0;
                        }
                        case 2: {
                            Node node = this.new2();
                            this.push(this.goTo(2), node, true);
                            break block0;
                        }
                        case 3: {
                            Node node = this.new3();
                            this.push(this.goTo(13), node, false);
                            break block0;
                        }
                        case 4: {
                            Node node = this.new4();
                            this.push(this.goTo(13), node, false);
                            break block0;
                        }
                        case 5: {
                            Node node = this.new5();
                            this.push(this.goTo(3), node, true);
                            break block0;
                        }
                        case 6: {
                            Node node = this.new6();
                            this.push(this.goTo(4), node, true);
                            break block0;
                        }
                        case 7: {
                            Node node = this.new7();
                            this.push(this.goTo(4), node, true);
                            break block0;
                        }
                        case 8: {
                            Node node = this.new8();
                            this.push(this.goTo(5), node, true);
                            break block0;
                        }
                        case 9: {
                            Node node = this.new9();
                            this.push(this.goTo(5), node, true);
                            break block0;
                        }
                        case 10: {
                            Node node = this.new10();
                            this.push(this.goTo(14), node, false);
                            break block0;
                        }
                        case 11: {
                            Node node = this.new11();
                            this.push(this.goTo(14), node, false);
                            break block0;
                        }
                        case 12: {
                            Node node = this.new12();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 13: {
                            Node node = this.new13();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 14: {
                            Node node = this.new14();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 15: {
                            Node node = this.new15();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 16: {
                            Node node = this.new16();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 17: {
                            Node node = this.new17();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 18: {
                            Node node = this.new18();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 19: {
                            Node node = this.new19();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 20: {
                            Node node = this.new20();
                            this.push(this.goTo(6), node, true);
                            break block0;
                        }
                        case 21: {
                            Node node = this.new21();
                            this.push(this.goTo(7), node, true);
                            break block0;
                        }
                        case 22: {
                            Node node = this.new22();
                            this.push(this.goTo(7), node, true);
                            break block0;
                        }
                        case 23: {
                            Node node = this.new23();
                            this.push(this.goTo(8), node, true);
                            break block0;
                        }
                        case 24: {
                            Node node = this.new24();
                            this.push(this.goTo(9), node, true);
                            break block0;
                        }
                        case 25: {
                            Node node = this.new25();
                            this.push(this.goTo(10), node, true);
                            break block0;
                        }
                        case 26: {
                            Node node = this.new26();
                            this.push(this.goTo(10), node, true);
                            break block0;
                        }
                        case 27: {
                            Node node = this.new27();
                            this.push(this.goTo(15), node, false);
                            break block0;
                        }
                        case 28: {
                            Node node = this.new28();
                            this.push(this.goTo(15), node, false);
                            break block0;
                        }
                        case 29: {
                            Node node = this.new29();
                            this.push(this.goTo(11), node, true);
                            break block0;
                        }
                        case 30: {
                            Node node = this.new30();
                            this.push(this.goTo(12), node, true);
                        }
                    }
                    break;
                }
                case 2: {
                    EOF node2 = (EOF)this.lexer.next();
                    PBvh node1 = (PBvh)this.pop();
                    Start node = new Start(node1, node2);
                    return node;
                }
                case 3: {
                    throw new ParserException(this.last_token, "[" + this.last_line + "," + this.last_pos + "] " + errorMessages[errors[this.action[1]]]);
                }
            }
        }
    }

    Node new0() {
        PMotionPart node2 = (PMotionPart)this.pop();
        PHierarchyPart node1 = (PHierarchyPart)this.pop();
        ABvh node = new ABvh(node1, node2);
        return node;
    }

    Node new1() {
        PRootBlock node2 = (PRootBlock)this.pop();
        THierarchy node1 = (THierarchy)this.pop();
        AHierarchyPart node = new AHierarchyPart(node1, node2);
        return node;
    }

    Node new2() {
        TRBrace node7 = (TRBrace)this.pop();
        XPSuperBlock node6 = (XPSuperBlock)this.pop();
        PChannelsLine node5 = (PChannelsLine)this.pop();
        POffsetLine node4 = (POffsetLine)this.pop();
        TLBrace node3 = (TLBrace)this.pop();
        TIdentifier node2 = (TIdentifier)this.pop();
        TRoot node1 = (TRoot)this.pop();
        ARootBlock node = new ARootBlock(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new3() {
        PSuperBlock node2 = (PSuperBlock)this.pop();
        XPSuperBlock node1 = (XPSuperBlock)this.pop();
        X1PSuperBlock node = new X1PSuperBlock(node1, node2);
        return node;
    }

    Node new4() {
        PSuperBlock node1 = (PSuperBlock)this.pop();
        X2PSuperBlock node = new X2PSuperBlock(node1);
        return node;
    }

    Node new5() {
        PNumber node4 = (PNumber)this.pop();
        PNumber node3 = (PNumber)this.pop();
        PNumber node2 = (PNumber)this.pop();
        TOffset node1 = (TOffset)this.pop();
        AOffsetLine node = new AOffsetLine(node1, node2, node3, node4);
        return node;
    }

    Node new6() {
        TInteger node1 = (TInteger)this.pop();
        AIntegerNumber node = new AIntegerNumber(node1);
        return node;
    }

    Node new7() {
        TRealNumber node1 = (TRealNumber)this.pop();
        ARealNumberNumber node = new ARealNumberNumber(node1);
        return node;
    }

    Node new8() {
        XPChannelType node3 = null;
        TInteger node2 = (TInteger)this.pop();
        TChannels node1 = (TChannels)this.pop();
        AChannelsLine node = new AChannelsLine(node1, node2, node3);
        return node;
    }

    Node new9() {
        XPChannelType node3 = (XPChannelType)this.pop();
        TInteger node2 = (TInteger)this.pop();
        TChannels node1 = (TChannels)this.pop();
        AChannelsLine node = new AChannelsLine(node1, node2, node3);
        return node;
    }

    Node new10() {
        PChannelType node2 = (PChannelType)this.pop();
        XPChannelType node1 = (XPChannelType)this.pop();
        X1PChannelType node = new X1PChannelType(node1, node2);
        return node;
    }

    Node new11() {
        PChannelType node1 = (PChannelType)this.pop();
        X2PChannelType node = new X2PChannelType(node1);
        return node;
    }

    Node new12() {
        TXPosition node1 = (TXPosition)this.pop();
        AXPositionChannelType node = new AXPositionChannelType(node1);
        return node;
    }

    Node new13() {
        TYPosition node1 = (TYPosition)this.pop();
        AYPositionChannelType node = new AYPositionChannelType(node1);
        return node;
    }

    Node new14() {
        TZPosition node1 = (TZPosition)this.pop();
        AZPositionChannelType node = new AZPositionChannelType(node1);
        return node;
    }

    Node new15() {
        TXRotation node1 = (TXRotation)this.pop();
        AXRotationChannelType node = new AXRotationChannelType(node1);
        return node;
    }

    Node new16() {
        TYRotation node1 = (TYRotation)this.pop();
        AYRotationChannelType node = new AYRotationChannelType(node1);
        return node;
    }

    Node new17() {
        TZRotation node1 = (TZRotation)this.pop();
        AZRotationChannelType node = new AZRotationChannelType(node1);
        return node;
    }

    Node new18() {
        TXScale node1 = (TXScale)this.pop();
        AXScaleChannelType node = new AXScaleChannelType(node1);
        return node;
    }

    Node new19() {
        TYScale node1 = (TYScale)this.pop();
        AYScaleChannelType node = new AYScaleChannelType(node1);
        return node;
    }

    Node new20() {
        TZScale node1 = (TZScale)this.pop();
        AZScaleChannelType node = new AZScaleChannelType(node1);
        return node;
    }

    Node new21() {
        PJointBlock node1 = (PJointBlock)this.pop();
        AJointSuperBlock node = new AJointSuperBlock(node1);
        return node;
    }

    Node new22() {
        PEndSiteBlock node1 = (PEndSiteBlock)this.pop();
        AEndSiteSuperBlock node = new AEndSiteSuperBlock(node1);
        return node;
    }

    Node new23() {
        TRBrace node7 = (TRBrace)this.pop();
        XPSuperBlock node6 = (XPSuperBlock)this.pop();
        PChannelsLine node5 = (PChannelsLine)this.pop();
        POffsetLine node4 = (POffsetLine)this.pop();
        TLBrace node3 = (TLBrace)this.pop();
        TIdentifier node2 = (TIdentifier)this.pop();
        TJoint node1 = (TJoint)this.pop();
        AJointBlock node = new AJointBlock(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new24() {
        TRBrace node4 = (TRBrace)this.pop();
        POffsetLine node3 = (POffsetLine)this.pop();
        TLBrace node2 = (TLBrace)this.pop();
        TEndSite node1 = (TEndSite)this.pop();
        AEndSiteBlock node = new AEndSiteBlock(node1, node2, node3, node4);
        return node;
    }

    Node new25() {
        XPNumber node4 = null;
        PFrameTimeLine node3 = (PFrameTimeLine)this.pop();
        PFramesLine node2 = (PFramesLine)this.pop();
        TMotion node1 = (TMotion)this.pop();
        AMotionPart node = new AMotionPart(node1, node2, node3, node4);
        return node;
    }

    Node new26() {
        XPNumber node4 = (XPNumber)this.pop();
        PFrameTimeLine node3 = (PFrameTimeLine)this.pop();
        PFramesLine node2 = (PFramesLine)this.pop();
        TMotion node1 = (TMotion)this.pop();
        AMotionPart node = new AMotionPart(node1, node2, node3, node4);
        return node;
    }

    Node new27() {
        PNumber node2 = (PNumber)this.pop();
        XPNumber node1 = (XPNumber)this.pop();
        X1PNumber node = new X1PNumber(node1, node2);
        return node;
    }

    Node new28() {
        PNumber node1 = (PNumber)this.pop();
        X2PNumber node = new X2PNumber(node1);
        return node;
    }

    Node new29() {
        TInteger node2 = (TInteger)this.pop();
        TFrames node1 = (TFrames)this.pop();
        AFramesLine node = new AFramesLine(node1, node2);
        return node;
    }

    Node new30() {
        PNumber node2 = (PNumber)this.pop();
        TFrameTime node1 = (TFrameTime)this.pop();
        AFrameTimeLine node = new AFrameTimeLine(node1, node2);
        return node;
    }
}

