/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.ActionBehavior;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3.bvh.BVH;
import org.jdesktop.j3d.loaders.vrml97.VrmlLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Action3DData {
    static VrmlLoader loader = null;
    static boolean isInitialized = false;
    URL url;
    String comment;
    int defaultActionNo = 0;
    int walkActionNo = 0;
    int runActionNo = 0;
    double minWalkSpeed = 0.1;
    double minRunSpeed = 0.3;
    boolean autoActionControl = false;
    Action[] actions;
    String[] actionNames;
    HashMap<String, SharedGroup> shapes;
    HashMap<String, Motion> motions;
    HashMap<String, MediaContainer> sounds;
    BranchGroup allActionBranchGroup;
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

    static void initAction3DData() {
        if (isInitialized) {
            return;
        }
        try {
            loader = new VrmlLoader(51);
        }
        catch (Exception e) {
            System.out.println("Action3DData.initAction3DData(). gaha!");
            e.printStackTrace();
        }
        isInitialized = true;
    }

    Action3DData() {
    }

    Action3DData(String urlString) throws Exception {
        this.url = new URL(urlString);
        this.init(this.url);
    }

    Action3DData(URL url) throws Exception {
        this.init(url);
    }

    void init(URL url) throws Exception {
        this.url = url;
        this.loadCatalog();
        this.loadAllShapes();
        this.loadAllMotions();
        this.loadAllSounds();
    }

    public Action3DData copy() {
        Action3DData ret = new Action3DData();
        ret.url = this.url;
        ret.comment = this.comment;
        ret.actionNames = (String[])this.actionNames.clone();
        ret.defaultActionNo = this.defaultActionNo;
        ret.walkActionNo = this.walkActionNo;
        ret.runActionNo = this.runActionNo;
        ret.minWalkSpeed = this.minWalkSpeed;
        ret.minRunSpeed = this.minRunSpeed;
        ret.actions = new Action[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            ret.actions[i] = this.actions[i].copy();
        }
        ret.shapes = new HashMap<String, SharedGroup>(this.shapes);
        ret.motions = new HashMap<String, Motion>(this.motions);
        ret.sounds = new HashMap<String, MediaContainer>(this.sounds);
        return ret;
    }

    void loadCatalog() throws Exception {
        org.w3c.dom.Node[] cc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = null;
        try {
            d = db.parse("x-rzip:" + this.url.toString() + "!/CATALOG.XML");
        }
        catch (Exception e) {
            d = db.parse("x-rzip:" + this.url.toString() + "!/catalog.xml");
        }
        org.w3c.dom.Node[] a3 = Action3DData.xpath("/a3", d);
        NamedNodeMap nnm = a3[0].getAttributes();
        Attr attr = (Attr)nnm.getNamedItem("defaultActionNo");
        if (attr != null) {
            this.defaultActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("walkActionNo")) != null) {
            this.walkActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("runActionNo")) != null) {
            this.runActionNo = Integer.parseInt(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("minWalkSpeed")) != null) {
            this.minWalkSpeed = Double.parseDouble(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("minRunSpeed")) != null) {
            this.minRunSpeed = Double.parseDouble(attr.getValue().trim());
        }
        if ((attr = (Attr)nnm.getNamedItem("autoActionControl")) != null) {
            this.autoActionControl = Boolean.parseBoolean(attr.getValue().trim());
        }
        this.comment = (cc = Action3DData.xpath("/a3/c/text()", d)).length != 0 ? ((Text)cc[0]).getData() : "";
        org.w3c.dom.Node[] a_nodes = Action3DData.xpath("/a3/a", d);
        this.actions = new Action[a_nodes.length];
        this.actionNames = new String[a_nodes.length];
        for (int i = 0; i < a_nodes.length; ++i) {
            int ii;
            StringTokenizer st;
            Action a = new Action();
            a.actionNo = i;
            nnm = a_nodes[i].getAttributes();
            attr = (Attr)nnm.getNamedItem("an");
            a.actionName = attr.getValue().trim();
            this.actions[i] = a;
            this.actionNames[i] = a.actionName;
            attr = (Attr)nnm.getNamedItem("loop");
            if (attr != null) {
                Boolean bbb = Boolean.valueOf(attr.getValue());
                a.loopFlag = bbb;
            } else {
                a.loopFlag = false;
            }
            attr = (Attr)nnm.getNamedItem("bvh");
            a.bvhFile = attr.getValue().trim();
            attr = (Attr)nnm.getNamedItem("scale");
            a.scale = attr != null ? Double.parseDouble(attr.getValue()) : 1.0;
            attr = (Attr)nnm.getNamedItem("rot");
            if (attr != null) {
                a.rotationXYZ = new double[3];
                st = new StringTokenizer(attr.getValue());
                ii = 0;
                while (st.hasMoreTokens()) {
                    a.rotationXYZ[ii] = Double.parseDouble(st.nextToken());
                    ++ii;
                }
            }
            if ((attr = (Attr)nnm.getNamedItem("offset")) != null) {
                a.offsetXYZ = new double[3];
                st = new StringTokenizer(attr.getValue());
                ii = 0;
                while (st.hasMoreTokens()) {
                    a.offsetXYZ[ii] = Double.parseDouble(st.nextToken());
                    ++ii;
                }
            }
            a.pHash = new HashMap();
            org.w3c.dom.Node[] p_nodes = Action3DData.xpath("/a3/a[position()=" + (i + 1) + "]/p", d);
            for (int j = 0; j < p_nodes.length; ++j) {
                int ii2;
                StringTokenizer st2;
                Part p = new Part();
                nnm = p_nodes[j].getAttributes();
                attr = (Attr)nnm.getNamedItem("name");
                String partName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("wrl");
                p.fileName = attr.getValue().trim();
                attr = (Attr)nnm.getNamedItem("scale");
                if (attr != null) {
                    p.scale = Double.parseDouble(attr.getValue().trim());
                }
                if ((attr = (Attr)nnm.getNamedItem("offset")) != null) {
                    st2 = new StringTokenizer(attr.getValue());
                    ii2 = 0;
                    while (st2.hasMoreTokens()) {
                        p.offsetXYZ[ii2] = Double.parseDouble(st2.nextToken());
                        ++ii2;
                    }
                }
                if ((attr = (Attr)nnm.getNamedItem("rot")) != null) {
                    st2 = new StringTokenizer(attr.getValue());
                    ii2 = 0;
                    while (st2.hasMoreTokens()) {
                        p.rotationXYZ[ii2] = Double.parseDouble(st2.nextToken());
                        ++ii2;
                    }
                }
                a.pHash.put(partName, p);
            }
            org.w3c.dom.Node[] s_nodes = Action3DData.xpath("/a3/a[position()=" + (i + 1) + "]/s", d);
            if (s_nodes == null || s_nodes.length == 0) continue;
            nnm = s_nodes[0].getAttributes();
            attr = (Attr)nnm.getNamedItem("file");
            a.soundFile = attr.getValue().trim();
            attr = (Attr)nnm.getNamedItem("loop");
            if (attr != null) {
                a.soundLoop = Boolean.parseBoolean(attr.getValue().trim());
            }
            if ((attr = (Attr)nnm.getNamedItem("type")) != null) {
                a.soundType = attr.getValue().trim();
            }
            if ((attr = (Attr)nnm.getNamedItem("gain")) != null) {
                a.soundGain = Float.parseFloat(attr.getValue().trim());
            }
            if ((attr = (Attr)nnm.getNamedItem("offset")) == null) continue;
            StringTokenizer st3 = new StringTokenizer(attr.getValue());
            int ii3 = 0;
            while (st3.hasMoreTokens()) {
                a.soundOffsetXYZ[ii3] = Float.parseFloat(st3.nextToken());
                ++ii3;
            }
        }
    }

    static org.w3c.dom.Node[] xpath(String query, Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            org.w3c.dom.Node[] ret = new org.w3c.dom.Node[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                ret[i] = nl.item(i);
            }
            return ret;
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    void loadAllShapes() throws Exception {
        HashSet<Part> s = new HashSet<Part>();
        for (int i = 0; i < this.actions.length; ++i) {
            s.addAll(this.actions[i].pHash.values());
        }
        this.shapes = new HashMap();
        for (Part p : s) {
            URL wrlURL = new URL("x-rzip:" + this.url.toString() + "!/" + p.fileName);
            SharedGroup sg = new SharedGroup();
            Transform3D t = new Transform3D();
            TransformGroup tg = new TransformGroup(t);
            tg.addChild((Node)loader.load(wrlURL).getSceneGroup());
            sg.addChild((Node)tg);
            this.shapes.put(p.fileName, sg);
        }
    }

    void loadAllMotions() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].bvhFile == null) continue;
            s.add(this.actions[i].bvhFile);
        }
        this.motions = new HashMap();
        for (String filename : s) {
            URL motionURL = new URL("x-rzip:" + this.url.toString() + "!/" + filename);
            BVH bvh = new BVH(motionURL);
            this.motions.put(filename, bvh);
        }
    }

    void loadAllSounds() throws Exception {
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].soundFile == null) continue;
            s.add(this.actions[i].soundFile);
        }
        this.sounds = new HashMap();
        for (String filename : s) {
            URL soundURL = new URL("x-rzip:" + this.url.toString() + "!/" + filename);
            MediaContainer mc = new MediaContainer(soundURL);
            this.sounds.put(filename, mc);
        }
    }

    void construct3DNode(Action3D a3) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].construct3DNode(a3);
        }
        this.allActionBranchGroup = new BranchGroup();
        this.allActionBranchGroup.setCapability(17);
        this.allActionBranchGroup.setCapability(13);
        this.allActionBranchGroup.setCapability(14);
        this.allActionBranchGroup.addChild((Node)this.actions[0].rootGroup);
    }

    Node getNode() {
        this.allActionBranchGroup.detach();
        return this.allActionBranchGroup;
    }

    String getActionNameFromActionNo(int an) {
        return this.actionNames[an];
    }

    int getActionNoFromActionName(String an) {
        for (int i = 0; i < this.actionNames.length; ++i) {
            if (!this.actionNames[i].equals(an)) continue;
            return i;
        }
        return -1;
    }

    int getActionCount() {
        return this.actions.length;
    }

    String[] getActionNames() {
        return (String[])this.actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return this.actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return this.actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = this.getActionNoFromActionName(actionName);
        return this.actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;
    }

    String getComment() {
        return this.comment;
    }

    int getFrameCount() {
        return this.actionNames.length;
    }

    void setMode(Motion.Mode m) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setMode(m);
        }
    }

    void setAutoActionControl(boolean b) {
        this.autoActionControl = b;
    }

    boolean autoActionControl() {
        return this.autoActionControl;
    }

    void setDefaultAction(int i) {
        this.defaultActionNo = i;
    }

    void setDefaultAction(Serializable s) {
        if (s instanceof String) {
            this.setDefaultAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setDefaultAction((Integer)s);
        }
    }

    int getDefaultActionNo() {
        return this.defaultActionNo;
    }

    void setWalkAction(int i) {
        this.walkActionNo = i;
    }

    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            this.setWalkAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setWalkAction((Integer)s);
        }
    }

    int getWalkActionNo() {
        return this.walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        this.minWalkSpeed = d;
    }

    double getMinWalkSpeed() {
        return this.minWalkSpeed;
    }

    void setRunAction(int i) {
        this.runActionNo = i;
    }

    void setRunAction(Serializable s) {
        if (s instanceof String) {
            this.setRunAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setRunAction((Integer)s);
        }
    }

    int getRunActionNo() {
        return this.runActionNo;
    }

    void setMinRunSpeed(double d) {
        this.minRunSpeed = d;
    }

    double getMinRunSpeed() {
        return this.minRunSpeed;
    }

    class Action {
        int actionNo;
        String actionName;
        boolean loopFlag;
        String bvhFile;
        String soundFile;
        boolean soundLoop;
        String soundType = "PointSound";
        float soundGain = 1.0f;
        float[] soundOffsetXYZ = new float[]{0.0f, 0.0f, 0.0f};
        Sound sound;
        double scale;
        double[] offsetXYZ;
        double[] rotationXYZ;
        HashMap<String, Part> pHash;
        Group rootGroup;
        ActionBehavior behavior;
        Motion motion;
        HashMap<String, TransformGroup> tgMap;

        Action() {
        }

        Action copy() {
            Action ret = new Action();
            ret.actionNo = this.actionNo;
            ret.actionName = this.actionName;
            ret.loopFlag = this.loopFlag;
            ret.bvhFile = this.bvhFile;
            ret.soundFile = this.soundFile;
            ret.soundLoop = this.soundLoop;
            ret.soundType = this.soundType;
            ret.soundGain = this.soundGain;
            ret.soundOffsetXYZ = (float[])this.soundOffsetXYZ.clone();
            ret.scale = this.scale;
            ret.rotationXYZ = this.rotationXYZ == null ? null : (double[])this.rotationXYZ.clone();
            ret.offsetXYZ = this.offsetXYZ == null ? null : (double[])this.offsetXYZ.clone();
            ret.pHash = new HashMap<String, Part>(this.pHash);
            ret.motion = this.motion;
            return ret;
        }

        void construct3DNode(Action3D a3) {
            this.tgMap = new HashMap();
            this.rootGroup = new BranchGroup();
            this.rootGroup.setCapability(17);
            TransformGroup tg = new TransformGroup();
            tg.setCapability(18);
            tg.setCapability(17);
            TransformGroup tg0 = null;
            if (this.rotationXYZ == null && this.offsetXYZ == null && this.scale == 1.0) {
                tg0 = null;
            } else {
                Transform3D t0a = new Transform3D();
                Transform3D t0b = new Transform3D();
                if (this.rotationXYZ != null) {
                    t0a.rotX(this.rotationXYZ[0] / 360.0 * 2.0 * Math.PI);
                    t0b.rotY(this.rotationXYZ[1] / 360.0 * 2.0 * Math.PI);
                    t0a.mul(t0b);
                    t0b.rotZ(this.rotationXYZ[2] / 360.0 * 2.0 * Math.PI);
                    t0a.mul(t0b);
                }
                t0b.set(2.0);
                t0b.setScale(this.scale);
                if (this.offsetXYZ != null) {
                    t0b.setTranslation(new Vector3d(this.offsetXYZ[0], this.offsetXYZ[1], this.offsetXYZ[2]));
                }
                t0a.mul(t0b);
                tg0 = new TransformGroup(t0a);
                tg0.addChild((Node)tg);
            }
            if (tg0 != null) {
                this.rootGroup.addChild(tg0);
            } else {
                this.rootGroup.addChild((Node)tg);
            }
            this.motion = Action3DData.this.motions.get(this.bvhFile);
            String rootBoneName = this.motion.getRootBone();
            Part p = this.pHash.get(rootBoneName);
            if (p != null) {
                Link n = null;
                if (p.rotationXYZ == null && p.offsetXYZ == null && p.scale == 1.0) {
                    n = new Link(Action3DData.this.shapes.get(p.fileName));
                } else {
                    Transform3D t9a = new Transform3D();
                    Transform3D t9b = new Transform3D();
                    t9a.set(2.0);
                    t9b.set(2.0);
                    if (p.rotationXYZ != null) {
                        t9a.rotX(p.rotationXYZ[0] / 360.0 * Math.PI);
                        t9b.rotY(p.rotationXYZ[1] / 360.0 * Math.PI);
                        t9a.mul(t9b);
                        t9b.rotZ(p.rotationXYZ[2] / 360.0 * Math.PI);
                        t9a.mul(t9b);
                    }
                    t9b.set(2.0);
                    t9b.setScale(p.scale);
                    t9a.mul(t9b);
                    if (p.offsetXYZ != null) {
                        t9b.set(2.0);
                        t9b.setTranslation(new Vector3d(p.offsetXYZ[0], p.offsetXYZ[1], p.offsetXYZ[2]));
                        t9a.mul(t9b);
                    }
                    TransformGroup tg9 = new TransformGroup(t9a);
                    tg9.addChild((Node)new Link(Action3DData.this.shapes.get(p.fileName)));
                    n = tg9;
                }
                tg.addChild((Node)n);
            }
            this.tgMap.put(rootBoneName, tg);
            this.construct((Group)tg, rootBoneName, this.tgMap);
            if (this.soundFile != null) {
                MediaContainer mc = Action3DData.this.sounds.get(this.soundFile);
                this.sound = this.soundType.equals("BackgroundSound") ? new BackgroundSound(mc, this.soundGain) : new PointSound(mc, this.soundGain, this.soundOffsetXYZ[0], this.soundOffsetXYZ[1], this.soundOffsetXYZ[2]);
                this.sound.setEnable(false);
                this.sound.setPause(false);
                if (this.soundLoop) {
                    this.sound.setLoop(-1);
                } else {
                    this.sound.setLoop(0);
                }
                this.sound.setSchedulingBounds((Bounds)bounding);
                this.sound.setCapability(23);
                SharedGroup sg = new SharedGroup();
                sg.addChild((Node)this.sound);
                Link ll = new Link(sg);
                this.rootGroup.addChild((Node)ll);
            }
        }

        void construct(Group parent, String parentName, HashMap<String, TransformGroup> tgMap) {
            String[] children = this.motion.getChildBones(parentName);
            for (int i = 0; i < children.length; ++i) {
                TransformGroup tg = new TransformGroup();
                tg.setCapability(18);
                parent.addChild((Node)tg);
                Part p = this.pHash.get(children[i]);
                if (p != null) {
                    if (p.rotationXYZ == null && p.offsetXYZ == null && p.scale == 1.0) {
                        tg.addChild((Node)new Link(Action3DData.this.shapes.get(p.fileName)));
                    } else {
                        Transform3D t9a = new Transform3D();
                        Transform3D t9b = new Transform3D();
                        t9a.set(2.0);
                        t9b.set(2.0);
                        if (p.rotationXYZ != null) {
                            t9a.rotX(p.rotationXYZ[0] / 360.0 * Math.PI);
                            t9b.rotY(p.rotationXYZ[1] / 360.0 * Math.PI);
                            t9a.mul(t9b);
                            t9b.rotZ(p.rotationXYZ[2] / 360.0 * Math.PI);
                            t9a.mul(t9b);
                        }
                        t9b.set(2.0);
                        t9b.setScale(p.scale);
                        t9a.mul(t9b);
                        if (p.offsetXYZ != null) {
                            t9b.set(2.0);
                            t9b.setTranslation(new Vector3d(p.offsetXYZ[0], p.offsetXYZ[1], p.offsetXYZ[2]));
                            t9a.mul(t9b);
                        }
                        TransformGroup tg9 = new TransformGroup(t9a);
                        tg9.addChild((Node)new Link(Action3DData.this.shapes.get(p.fileName)));
                        tg.addChild((Node)tg9);
                    }
                }
                tgMap.put(children[i], tg);
                this.construct((Group)tg, children[i], tgMap);
            }
        }

        Group getRootGroup() {
            return this.rootGroup;
        }

        void start() {
            if (this.sound != null) {
                this.sound.setEnable(true);
            }
        }

        void stop() {
            if (this.sound != null) {
                this.sound.setEnable(false);
            }
        }

        boolean isStoped() {
            return this.behavior.isStoped();
        }

        double getMotionLength() {
            return this.motion.getMotionLength();
        }

        void setMode(Motion.Mode m) {
            this.behavior.setMode(m);
        }

        void setPauseTime(double t) {
            this.behavior.setPauseTime(t);
        }
    }

    class Part {
        String fileName;
        double scale = 1.0;
        double[] offsetXYZ;
        double[] rotationXYZ;

        Part() {
        }
    }
}

